// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the savings opportunity for Auto Scaling group recommendations after applying the Savings Plans and Reserved Instances discounts.
 *
 * Savings opportunity represents the estimated monthly savings you can achieve by implementing Compute Optimizer recommendations.
 */
public class AutoScalingGroupSavingsOpportunityAfterDiscounts private constructor(builder: Builder) {
    /**
     * An object that describes the estimated monthly savings possible by adopting Compute Optimizer’s Auto Scaling group recommendations. This is based on the Savings Plans and Reserved Instances pricing discounts.
     */
    public val estimatedMonthlySavings: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupEstimatedMonthlySavings? = builder.estimatedMonthlySavings
    /**
     * The estimated monthly savings possible as a percentage of monthly cost after applying the Savings Plans and Reserved Instances discounts. This saving can be achieved by adopting Compute Optimizer’s Auto Scaling group recommendations.
     */
    public val savingsOpportunityPercentage: kotlin.Double = builder.savingsOpportunityPercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupSavingsOpportunityAfterDiscounts = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingGroupSavingsOpportunityAfterDiscounts(")
        append("estimatedMonthlySavings=$estimatedMonthlySavings,")
        append("savingsOpportunityPercentage=$savingsOpportunityPercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = estimatedMonthlySavings?.hashCode() ?: 0
        result = 31 * result + (savingsOpportunityPercentage.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingGroupSavingsOpportunityAfterDiscounts

        if (estimatedMonthlySavings != other.estimatedMonthlySavings) return false
        if (!(savingsOpportunityPercentage?.equals(other.savingsOpportunityPercentage) ?: (other.savingsOpportunityPercentage == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupSavingsOpportunityAfterDiscounts = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An object that describes the estimated monthly savings possible by adopting Compute Optimizer’s Auto Scaling group recommendations. This is based on the Savings Plans and Reserved Instances pricing discounts.
         */
        public var estimatedMonthlySavings: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupEstimatedMonthlySavings? = null
        /**
         * The estimated monthly savings possible as a percentage of monthly cost after applying the Savings Plans and Reserved Instances discounts. This saving can be achieved by adopting Compute Optimizer’s Auto Scaling group recommendations.
         */
        public var savingsOpportunityPercentage: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupSavingsOpportunityAfterDiscounts) : this() {
            this.estimatedMonthlySavings = x.estimatedMonthlySavings
            this.savingsOpportunityPercentage = x.savingsOpportunityPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupSavingsOpportunityAfterDiscounts = AutoScalingGroupSavingsOpportunityAfterDiscounts(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupEstimatedMonthlySavings] inside the given [block]
         */
        public fun estimatedMonthlySavings(block: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupEstimatedMonthlySavings.Builder.() -> kotlin.Unit) {
            this.estimatedMonthlySavings = aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingGroupEstimatedMonthlySavings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
