// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A summary of a recommendation.
 */
public class RecommendationSummary private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the recommendation summary.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * An object that describes the performance risk ratings for a given resource type.
     */
    public val currentPerformanceRiskRatings: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRiskRatings? = builder.currentPerformanceRiskRatings
    /**
     * An array of objects that describes the estimated monthly saving amounts for the instances running on the specified `inferredWorkloadTypes`. The array contains the top five savings opportunites for the instances that run inferred workload types.
     */
    public val inferredWorkloadSavings: List<InferredWorkloadSaving>? = builder.inferredWorkloadSavings
    /**
     * The resource type that the recommendation summary applies to.
     */
    public val recommendationResourceType: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationSourceType? = builder.recommendationResourceType
    /**
     * An object that describes the savings opportunity for a given resource type. Savings opportunity includes the estimated monthly savings amount and percentage.
     */
    public val savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = builder.savingsOpportunity
    /**
     * An array of objects that describe a recommendation summary.
     */
    public val summaries: List<Summary>? = builder.summaries

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationSummary(")
        append("accountId=$accountId,")
        append("currentPerformanceRiskRatings=$currentPerformanceRiskRatings,")
        append("inferredWorkloadSavings=$inferredWorkloadSavings,")
        append("recommendationResourceType=$recommendationResourceType,")
        append("savingsOpportunity=$savingsOpportunity,")
        append("summaries=$summaries")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (currentPerformanceRiskRatings?.hashCode() ?: 0)
        result = 31 * result + (inferredWorkloadSavings?.hashCode() ?: 0)
        result = 31 * result + (recommendationResourceType?.hashCode() ?: 0)
        result = 31 * result + (savingsOpportunity?.hashCode() ?: 0)
        result = 31 * result + (summaries?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationSummary

        if (accountId != other.accountId) return false
        if (currentPerformanceRiskRatings != other.currentPerformanceRiskRatings) return false
        if (inferredWorkloadSavings != other.inferredWorkloadSavings) return false
        if (recommendationResourceType != other.recommendationResourceType) return false
        if (savingsOpportunity != other.savingsOpportunity) return false
        if (summaries != other.summaries) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID of the recommendation summary.
         */
        public var accountId: kotlin.String? = null
        /**
         * An object that describes the performance risk ratings for a given resource type.
         */
        public var currentPerformanceRiskRatings: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRiskRatings? = null
        /**
         * An array of objects that describes the estimated monthly saving amounts for the instances running on the specified `inferredWorkloadTypes`. The array contains the top five savings opportunites for the instances that run inferred workload types.
         */
        public var inferredWorkloadSavings: List<InferredWorkloadSaving>? = null
        /**
         * The resource type that the recommendation summary applies to.
         */
        public var recommendationResourceType: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationSourceType? = null
        /**
         * An object that describes the savings opportunity for a given resource type. Savings opportunity includes the estimated monthly savings amount and percentage.
         */
        public var savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = null
        /**
         * An array of objects that describe a recommendation summary.
         */
        public var summaries: List<Summary>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationSummary) : this() {
            this.accountId = x.accountId
            this.currentPerformanceRiskRatings = x.currentPerformanceRiskRatings
            this.inferredWorkloadSavings = x.inferredWorkloadSavings
            this.recommendationResourceType = x.recommendationResourceType
            this.savingsOpportunity = x.savingsOpportunity
            this.summaries = x.summaries
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.RecommendationSummary = RecommendationSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRiskRatings] inside the given [block]
         */
        public fun currentPerformanceRiskRatings(block: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRiskRatings.Builder.() -> kotlin.Unit) {
            this.currentPerformanceRiskRatings = aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRiskRatings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity] inside the given [block]
         */
        public fun savingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.savingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
