// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the projected metrics of an Amazon RDS recommendation option.
 *
 *  To determine the performance difference between your current Amazon RDS and the recommended option, compare the metric data of your service against its projected metric data.
 */
public class RdsDatabaseRecommendedOptionProjectedMetric private constructor(builder: Builder) {
    /**
     * An array of objects that describe the projected metric.
     */
    public val projectedMetrics: List<RdsDatabaseProjectedMetric>? = builder.projectedMetrics
    /**
     * The rank identifier of the RDS instance recommendation option.
     */
    public val rank: kotlin.Int = builder.rank
    /**
     * The recommended DB instance class for the Amazon RDS.
     */
    public val recommendedDbInstanceClass: kotlin.String? = builder.recommendedDbInstanceClass

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.RdsDatabaseRecommendedOptionProjectedMetric = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsDatabaseRecommendedOptionProjectedMetric(")
        append("projectedMetrics=$projectedMetrics,")
        append("rank=$rank,")
        append("recommendedDbInstanceClass=$recommendedDbInstanceClass")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = projectedMetrics?.hashCode() ?: 0
        result = 31 * result + (rank)
        result = 31 * result + (recommendedDbInstanceClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsDatabaseRecommendedOptionProjectedMetric

        if (projectedMetrics != other.projectedMetrics) return false
        if (rank != other.rank) return false
        if (recommendedDbInstanceClass != other.recommendedDbInstanceClass) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.RdsDatabaseRecommendedOptionProjectedMetric = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of objects that describe the projected metric.
         */
        public var projectedMetrics: List<RdsDatabaseProjectedMetric>? = null
        /**
         * The rank identifier of the RDS instance recommendation option.
         */
        public var rank: kotlin.Int = 0
        /**
         * The recommended DB instance class for the Amazon RDS.
         */
        public var recommendedDbInstanceClass: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.RdsDatabaseRecommendedOptionProjectedMetric) : this() {
            this.projectedMetrics = x.projectedMetrics
            this.rank = x.rank
            this.recommendedDbInstanceClass = x.recommendedDbInstanceClass
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.RdsDatabaseRecommendedOptionProjectedMetric = RdsDatabaseRecommendedOptionProjectedMetric(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
