// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a filter that returns a more specific list of recommendation export jobs. Use this filter with the DescribeRecommendationExportJobs action.
 *
 * You can use `EBSFilter` with the GetEBSVolumeRecommendations action, `LambdaFunctionRecommendationFilter` with the GetLambdaFunctionRecommendations action, and `Filter` with the GetAutoScalingGroupRecommendations and GetEC2InstanceRecommendations actions.
 */
public class JobFilter private constructor(builder: Builder) {
    /**
     * The name of the filter.
     *
     * Specify `ResourceType` to return export jobs of a specific resource type (for example, `Ec2Instance`).
     *
     * Specify `JobStatus` to return export jobs with a specific status (e.g, `Complete`).
     */
    public val name: aws.sdk.kotlin.services.computeoptimizer.model.JobFilterName? = builder.name
    /**
     * The value of the filter.
     *
     * The valid values for this parameter are as follows, depending on what you specify for the `name` parameter:
     * + Specify `Ec2Instance` or `AutoScalingGroup` if you specify the `name` parameter as `ResourceType`. There is no filter for EBS volumes because volume recommendations cannot be exported at this time.
     * + Specify `Queued`, `InProgress`, `Complete`, or `Failed` if you specify the `name` parameter as `JobStatus`.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.JobFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobFilter(")
        append("name=$name,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobFilter

        if (name != other.name) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.JobFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the filter.
         *
         * Specify `ResourceType` to return export jobs of a specific resource type (for example, `Ec2Instance`).
         *
         * Specify `JobStatus` to return export jobs with a specific status (e.g, `Complete`).
         */
        public var name: aws.sdk.kotlin.services.computeoptimizer.model.JobFilterName? = null
        /**
         * The value of the filter.
         *
         * The valid values for this parameter are as follows, depending on what you specify for the `name` parameter:
         * + Specify `Ec2Instance` or `AutoScalingGroup` if you specify the `name` parameter as `ResourceType`. There is no filter for EBS volumes because volume recommendations cannot be exported at this time.
         * + Specify `Queued`, `InProgress`, `Complete`, or `Failed` if you specify the `name` parameter as `JobStatus`.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.JobFilter) : this() {
            this.name = x.name
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.JobFilter = JobFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
