// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.serde

import aws.sdk.kotlin.services.computeoptimizer.model.ComputeOptimizerException
import aws.sdk.kotlin.services.computeoptimizer.model.ExportEbsVolumeRecommendationsResponse
import aws.sdk.kotlin.services.computeoptimizer.model.S3Destination
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ExportEBSVolumeRecommendationsOperationDeserializer: HttpDeserialize<ExportEbsVolumeRecommendationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ExportEbsVolumeRecommendationsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwExportEbsVolumeRecommendationsError(context, call)
        }
        val builder = ExportEbsVolumeRecommendationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeExportEBSVolumeRecommendationsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwExportEbsVolumeRecommendationsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ComputeOptimizerException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "OptInRequiredException" -> OptInRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "MissingAuthenticationToken" -> MissingAuthenticationTokenDeserializer().deserialize(context, wrappedCall)
        else -> ComputeOptimizerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeExportEBSVolumeRecommendationsOperationBody(builder: ExportEbsVolumeRecommendationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobId"))
    val S3DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("s3Destination"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(JOBID_DESCRIPTOR)
        field(S3DESTINATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                S3DESTINATION_DESCRIPTOR.index -> builder.s3Destination = deserializeS3DestinationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
