// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon Elastic Block Store (Amazon EBS) volume recommendation.
 */
public class VolumeRecommendation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the volume.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * An array of objects that describe the current configuration of the volume.
     */
    public val currentConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration? = builder.currentConfiguration
    /**
     * The risk of the current EBS volume not meeting the performance needs of its workloads. The higher the risk, the more likely the current EBS volume doesn't have sufficient capacity.
     */
    public val currentPerformanceRisk: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRisk? = builder.currentPerformanceRisk
    /**
     * Describes the effective recommendation preferences for Amazon EBS volume.
     */
    public val effectiveRecommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.EbsEffectiveRecommendationPreferences? = builder.effectiveRecommendationPreferences
    /**
     * The finding classification of the volume.
     *
     * Findings for volumes include:
     * + **`NotOptimized`**—A volume is considered not optimized when Compute Optimizer identifies a recommendation that can provide better performance for your workload.
     * + **`Optimized`**—An volume is considered optimized when Compute Optimizer determines that the volume is correctly provisioned to run your workload based on the chosen volume type. For optimized resources, Compute Optimizer might recommend a new generation volume type.
     */
    public val finding: aws.sdk.kotlin.services.computeoptimizer.model.EbsFinding? = builder.finding
    /**
     * The timestamp of when the volume recommendation was last generated.
     */
    public val lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRefreshTimestamp
    /**
     * The number of days for which utilization metrics were analyzed for the volume.
     */
    public val lookBackPeriodInDays: kotlin.Double = builder.lookBackPeriodInDays
    /**
     * A list of tags assigned to your Amazon EBS volume recommendations.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * An array of objects that describe the utilization metrics of the volume.
     */
    public val utilizationMetrics: List<EbsUtilizationMetric>? = builder.utilizationMetrics
    /**
     * The Amazon Resource Name (ARN) of the current volume.
     */
    public val volumeArn: kotlin.String? = builder.volumeArn
    /**
     * An array of objects that describe the recommendation options for the volume.
     */
    public val volumeRecommendationOptions: List<VolumeRecommendationOption>? = builder.volumeRecommendationOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VolumeRecommendation(")
        append("accountId=$accountId,")
        append("currentConfiguration=$currentConfiguration,")
        append("currentPerformanceRisk=$currentPerformanceRisk,")
        append("effectiveRecommendationPreferences=$effectiveRecommendationPreferences,")
        append("finding=$finding,")
        append("lastRefreshTimestamp=$lastRefreshTimestamp,")
        append("lookBackPeriodInDays=$lookBackPeriodInDays,")
        append("tags=$tags,")
        append("utilizationMetrics=$utilizationMetrics,")
        append("volumeArn=$volumeArn,")
        append("volumeRecommendationOptions=$volumeRecommendationOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (currentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (currentPerformanceRisk?.hashCode() ?: 0)
        result = 31 * result + (effectiveRecommendationPreferences?.hashCode() ?: 0)
        result = 31 * result + (finding?.hashCode() ?: 0)
        result = 31 * result + (lastRefreshTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lookBackPeriodInDays.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (utilizationMetrics?.hashCode() ?: 0)
        result = 31 * result + (volumeArn?.hashCode() ?: 0)
        result = 31 * result + (volumeRecommendationOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VolumeRecommendation

        if (accountId != other.accountId) return false
        if (currentConfiguration != other.currentConfiguration) return false
        if (currentPerformanceRisk != other.currentPerformanceRisk) return false
        if (effectiveRecommendationPreferences != other.effectiveRecommendationPreferences) return false
        if (finding != other.finding) return false
        if (lastRefreshTimestamp != other.lastRefreshTimestamp) return false
        if (lookBackPeriodInDays != other.lookBackPeriodInDays) return false
        if (tags != other.tags) return false
        if (utilizationMetrics != other.utilizationMetrics) return false
        if (volumeArn != other.volumeArn) return false
        if (volumeRecommendationOptions != other.volumeRecommendationOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID of the volume.
         */
        public var accountId: kotlin.String? = null
        /**
         * An array of objects that describe the current configuration of the volume.
         */
        public var currentConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration? = null
        /**
         * The risk of the current EBS volume not meeting the performance needs of its workloads. The higher the risk, the more likely the current EBS volume doesn't have sufficient capacity.
         */
        public var currentPerformanceRisk: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRisk? = null
        /**
         * Describes the effective recommendation preferences for Amazon EBS volume.
         */
        public var effectiveRecommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.EbsEffectiveRecommendationPreferences? = null
        /**
         * The finding classification of the volume.
         *
         * Findings for volumes include:
         * + **`NotOptimized`**—A volume is considered not optimized when Compute Optimizer identifies a recommendation that can provide better performance for your workload.
         * + **`Optimized`**—An volume is considered optimized when Compute Optimizer determines that the volume is correctly provisioned to run your workload based on the chosen volume type. For optimized resources, Compute Optimizer might recommend a new generation volume type.
         */
        public var finding: aws.sdk.kotlin.services.computeoptimizer.model.EbsFinding? = null
        /**
         * The timestamp of when the volume recommendation was last generated.
         */
        public var lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of days for which utilization metrics were analyzed for the volume.
         */
        public var lookBackPeriodInDays: kotlin.Double = 0.0
        /**
         * A list of tags assigned to your Amazon EBS volume recommendations.
         */
        public var tags: List<Tag>? = null
        /**
         * An array of objects that describe the utilization metrics of the volume.
         */
        public var utilizationMetrics: List<EbsUtilizationMetric>? = null
        /**
         * The Amazon Resource Name (ARN) of the current volume.
         */
        public var volumeArn: kotlin.String? = null
        /**
         * An array of objects that describe the recommendation options for the volume.
         */
        public var volumeRecommendationOptions: List<VolumeRecommendationOption>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendation) : this() {
            this.accountId = x.accountId
            this.currentConfiguration = x.currentConfiguration
            this.currentPerformanceRisk = x.currentPerformanceRisk
            this.effectiveRecommendationPreferences = x.effectiveRecommendationPreferences
            this.finding = x.finding
            this.lastRefreshTimestamp = x.lastRefreshTimestamp
            this.lookBackPeriodInDays = x.lookBackPeriodInDays
            this.tags = x.tags
            this.utilizationMetrics = x.utilizationMetrics
            this.volumeArn = x.volumeArn
            this.volumeRecommendationOptions = x.volumeRecommendationOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendation = VolumeRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration] inside the given [block]
         */
        public fun currentConfiguration(block: aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration.Builder.() -> kotlin.Unit) {
            this.currentConfiguration = aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.EbsEffectiveRecommendationPreferences] inside the given [block]
         */
        public fun effectiveRecommendationPreferences(block: aws.sdk.kotlin.services.computeoptimizer.model.EbsEffectiveRecommendationPreferences.Builder.() -> kotlin.Unit) {
            this.effectiveRecommendationPreferences = aws.sdk.kotlin.services.computeoptimizer.model.EbsEffectiveRecommendationPreferences.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
