// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * The Amazon ECS service configurations used for recommendations.
 */
public class ServiceConfiguration private constructor(builder: Builder) {
    /**
     * Describes the Auto Scaling configuration methods for an Amazon ECS service. This affects the generated recommendations. For example, if Auto Scaling is configured on a service’s CPU, then Compute Optimizer doesn’t generate CPU size recommendations.
     *
     * The Auto Scaling configuration methods include:
     * + `TARGET_TRACKING_SCALING_CPU` — If the Amazon ECS service is configured to use target scaling on CPU, Compute Optimizer doesn't generate CPU recommendations.
     * + `TARGET_TRACKING_SCALING_MEMORY` — If the Amazon ECS service is configured to use target scaling on memory, Compute Optimizer doesn't generate memory recommendations.
     *
     * For more information about step scaling and target scaling, see [ Step scaling policies for Application Auto Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) and [ Target tracking scaling policies for Application Auto Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) in the *Application Auto Scaling User Guide*.
     */
    public val autoScalingConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingConfiguration? = builder.autoScalingConfiguration
    /**
     * The container configurations within a task of an Amazon ECS service.
     */
    public val containerConfigurations: List<ContainerConfiguration>? = builder.containerConfigurations
    /**
     * The number of CPU units used by the tasks in the Amazon ECS service.
     */
    public val cpu: kotlin.Int? = builder.cpu
    /**
     * The amount of memory used by the tasks in the Amazon ECS service.
     */
    public val memory: kotlin.Int? = builder.memory
    /**
     * The task definition ARN used by the tasks in the Amazon ECS service.
     */
    public val taskDefinitionArn: kotlin.String? = builder.taskDefinitionArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.ServiceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceConfiguration(")
        append("autoScalingConfiguration=$autoScalingConfiguration,")
        append("containerConfigurations=$containerConfigurations,")
        append("cpu=$cpu,")
        append("memory=$memory,")
        append("taskDefinitionArn=$taskDefinitionArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingConfiguration?.hashCode() ?: 0
        result = 31 * result + (containerConfigurations?.hashCode() ?: 0)
        result = 31 * result + (cpu ?: 0)
        result = 31 * result + (memory ?: 0)
        result = 31 * result + (taskDefinitionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceConfiguration

        if (autoScalingConfiguration != other.autoScalingConfiguration) return false
        if (containerConfigurations != other.containerConfigurations) return false
        if (cpu != other.cpu) return false
        if (memory != other.memory) return false
        if (taskDefinitionArn != other.taskDefinitionArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.ServiceConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the Auto Scaling configuration methods for an Amazon ECS service. This affects the generated recommendations. For example, if Auto Scaling is configured on a service’s CPU, then Compute Optimizer doesn’t generate CPU size recommendations.
         *
         * The Auto Scaling configuration methods include:
         * + `TARGET_TRACKING_SCALING_CPU` — If the Amazon ECS service is configured to use target scaling on CPU, Compute Optimizer doesn't generate CPU recommendations.
         * + `TARGET_TRACKING_SCALING_MEMORY` — If the Amazon ECS service is configured to use target scaling on memory, Compute Optimizer doesn't generate memory recommendations.
         *
         * For more information about step scaling and target scaling, see [ Step scaling policies for Application Auto Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) and [ Target tracking scaling policies for Application Auto Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) in the *Application Auto Scaling User Guide*.
         */
        public var autoScalingConfiguration: aws.sdk.kotlin.services.computeoptimizer.model.AutoScalingConfiguration? = null
        /**
         * The container configurations within a task of an Amazon ECS service.
         */
        public var containerConfigurations: List<ContainerConfiguration>? = null
        /**
         * The number of CPU units used by the tasks in the Amazon ECS service.
         */
        public var cpu: kotlin.Int? = null
        /**
         * The amount of memory used by the tasks in the Amazon ECS service.
         */
        public var memory: kotlin.Int? = null
        /**
         * The task definition ARN used by the tasks in the Amazon ECS service.
         */
        public var taskDefinitionArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.ServiceConfiguration) : this() {
            this.autoScalingConfiguration = x.autoScalingConfiguration
            this.containerConfigurations = x.containerConfigurations
            this.cpu = x.cpu
            this.memory = x.memory
            this.taskDefinitionArn = x.taskDefinitionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.ServiceConfiguration = ServiceConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
