// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



public class PutRecommendationPreferencesRequest private constructor(builder: Builder) {
    /**
     * The status of the enhanced infrastructure metrics recommendation preference to create or update.
     *
     * Specify the `Active` status to activate the preference, or specify `Inactive` to deactivate the preference.
     *
     * For more information, see [Enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    public val enhancedInfrastructureMetrics: aws.sdk.kotlin.services.computeoptimizer.model.EnhancedInfrastructureMetrics? = builder.enhancedInfrastructureMetrics
    /**
     * The provider of the external metrics recommendation preference to create or update.
     *
     * Specify a valid provider in the `source` field to activate the preference. To delete this preference, see the DeleteRecommendationPreferences action.
     *
     * This preference can only be set for the `Ec2Instance` resource type.
     *
     * For more information, see [External metrics ingestion](https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html) in the *Compute Optimizer User Guide*.
     */
    public val externalMetricsPreference: aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference? = builder.externalMetricsPreference
    /**
     * The status of the inferred workload types recommendation preference to create or update.
     *
     * The inferred workload type feature is active by default. To deactivate it, create a recommendation preference.
     *
     * Specify the `Inactive` status to deactivate the feature, or specify `Active` to activate it.
     *
     * For more information, see [Inferred workload types](https://docs.aws.amazon.com/compute-optimizer/latest/ug/inferred-workload-types.html) in the *Compute Optimizer User Guide*.
     */
    public val inferredWorkloadTypes: aws.sdk.kotlin.services.computeoptimizer.model.InferredWorkloadTypesPreference? = builder.inferredWorkloadTypes
    /**
     * The preference to control the number of days the utilization metrics of the Amazon Web Services resource are analyzed. When this preference isn't specified, we use the default value `DAYS_14`.
     *
     * You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
     */
    public val lookBackPeriod: aws.sdk.kotlin.services.computeoptimizer.model.LookBackPeriodPreference? = builder.lookBackPeriod
    /**
     * The preference to control which resource type values are considered when generating rightsizing recommendations. You can specify this preference as a combination of include and exclude lists. You must specify either an `includeList` or `excludeList`. If the preference is an empty set of resource type values, an error occurs.
     *
     * You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
     */
    public val preferredResources: List<PreferredResource>? = builder.preferredResources
    /**
     * The target resource type of the recommendation preference to create.
     *
     * The `Ec2Instance` option encompasses standalone instances and instances that are part of Auto Scaling groups. The `AutoScalingGroup` option encompasses only instances that are part of an Auto Scaling group.
     *
     * The valid values for this parameter are `Ec2Instance` and `AutoScalingGroup`.
     */
    public val resourceType: aws.sdk.kotlin.services.computeoptimizer.model.ResourceType? = builder.resourceType
    /**
     * The status of the savings estimation mode preference to create or update.
     *
     * Specify the `AfterDiscounts` status to activate the preference, or specify `BeforeDiscounts` to deactivate the preference.
     *
     * Only the account manager or delegated administrator of your organization can activate this preference.
     *
     * For more information, see [ Savings estimation mode](https://docs.aws.amazon.com/compute-optimizer/latest/ug/savings-estimation-mode.html) in the *Compute Optimizer User Guide*.
     */
    public val savingsEstimationMode: aws.sdk.kotlin.services.computeoptimizer.model.SavingsEstimationMode? = builder.savingsEstimationMode
    /**
     * An object that describes the scope of the recommendation preference to create.
     *
     * You can create recommendation preferences at the organization level (for management accounts of an organization only), account level, and resource level. For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     *
     * You cannot create recommendation preferences for Auto Scaling groups at the organization and account levels. You can create recommendation preferences for Auto Scaling groups only at the resource level by specifying a scope name of `ResourceArn` and a scope value of the Auto Scaling group Amazon Resource Name (ARN). This will configure the preference for all instances that are part of the specified Auto Scaling group. You also cannot create recommendation preferences at the resource level for instances that are part of an Auto Scaling group. You can create recommendation preferences at the resource level only for standalone instances.
     */
    public val scope: aws.sdk.kotlin.services.computeoptimizer.model.Scope? = builder.scope
    /**
     * The preference to control the resource’s CPU utilization thresholds - threshold and headroom. When this preference isn't specified, we use the following default values:
     * + `P99_5` for threshold
     * + `PERCENT_17` for headroom
     *
     * You can only set this preference for the Amazon EC2 instance resource type.
     */
    public val utilizationPreferences: List<UtilizationPreference>? = builder.utilizationPreferences

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.PutRecommendationPreferencesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutRecommendationPreferencesRequest(")
        append("enhancedInfrastructureMetrics=$enhancedInfrastructureMetrics,")
        append("externalMetricsPreference=$externalMetricsPreference,")
        append("inferredWorkloadTypes=$inferredWorkloadTypes,")
        append("lookBackPeriod=$lookBackPeriod,")
        append("preferredResources=$preferredResources,")
        append("resourceType=$resourceType,")
        append("savingsEstimationMode=$savingsEstimationMode,")
        append("scope=$scope,")
        append("utilizationPreferences=$utilizationPreferences")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enhancedInfrastructureMetrics?.hashCode() ?: 0
        result = 31 * result + (externalMetricsPreference?.hashCode() ?: 0)
        result = 31 * result + (inferredWorkloadTypes?.hashCode() ?: 0)
        result = 31 * result + (lookBackPeriod?.hashCode() ?: 0)
        result = 31 * result + (preferredResources?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (savingsEstimationMode?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (utilizationPreferences?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutRecommendationPreferencesRequest

        if (enhancedInfrastructureMetrics != other.enhancedInfrastructureMetrics) return false
        if (externalMetricsPreference != other.externalMetricsPreference) return false
        if (inferredWorkloadTypes != other.inferredWorkloadTypes) return false
        if (lookBackPeriod != other.lookBackPeriod) return false
        if (preferredResources != other.preferredResources) return false
        if (resourceType != other.resourceType) return false
        if (savingsEstimationMode != other.savingsEstimationMode) return false
        if (scope != other.scope) return false
        if (utilizationPreferences != other.utilizationPreferences) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.PutRecommendationPreferencesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The status of the enhanced infrastructure metrics recommendation preference to create or update.
         *
         * Specify the `Active` status to activate the preference, or specify `Inactive` to deactivate the preference.
         *
         * For more information, see [Enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
         */
        public var enhancedInfrastructureMetrics: aws.sdk.kotlin.services.computeoptimizer.model.EnhancedInfrastructureMetrics? = null
        /**
         * The provider of the external metrics recommendation preference to create or update.
         *
         * Specify a valid provider in the `source` field to activate the preference. To delete this preference, see the DeleteRecommendationPreferences action.
         *
         * This preference can only be set for the `Ec2Instance` resource type.
         *
         * For more information, see [External metrics ingestion](https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html) in the *Compute Optimizer User Guide*.
         */
        public var externalMetricsPreference: aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference? = null
        /**
         * The status of the inferred workload types recommendation preference to create or update.
         *
         * The inferred workload type feature is active by default. To deactivate it, create a recommendation preference.
         *
         * Specify the `Inactive` status to deactivate the feature, or specify `Active` to activate it.
         *
         * For more information, see [Inferred workload types](https://docs.aws.amazon.com/compute-optimizer/latest/ug/inferred-workload-types.html) in the *Compute Optimizer User Guide*.
         */
        public var inferredWorkloadTypes: aws.sdk.kotlin.services.computeoptimizer.model.InferredWorkloadTypesPreference? = null
        /**
         * The preference to control the number of days the utilization metrics of the Amazon Web Services resource are analyzed. When this preference isn't specified, we use the default value `DAYS_14`.
         *
         * You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
         */
        public var lookBackPeriod: aws.sdk.kotlin.services.computeoptimizer.model.LookBackPeriodPreference? = null
        /**
         * The preference to control which resource type values are considered when generating rightsizing recommendations. You can specify this preference as a combination of include and exclude lists. You must specify either an `includeList` or `excludeList`. If the preference is an empty set of resource type values, an error occurs.
         *
         * You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
         */
        public var preferredResources: List<PreferredResource>? = null
        /**
         * The target resource type of the recommendation preference to create.
         *
         * The `Ec2Instance` option encompasses standalone instances and instances that are part of Auto Scaling groups. The `AutoScalingGroup` option encompasses only instances that are part of an Auto Scaling group.
         *
         * The valid values for this parameter are `Ec2Instance` and `AutoScalingGroup`.
         */
        public var resourceType: aws.sdk.kotlin.services.computeoptimizer.model.ResourceType? = null
        /**
         * The status of the savings estimation mode preference to create or update.
         *
         * Specify the `AfterDiscounts` status to activate the preference, or specify `BeforeDiscounts` to deactivate the preference.
         *
         * Only the account manager or delegated administrator of your organization can activate this preference.
         *
         * For more information, see [ Savings estimation mode](https://docs.aws.amazon.com/compute-optimizer/latest/ug/savings-estimation-mode.html) in the *Compute Optimizer User Guide*.
         */
        public var savingsEstimationMode: aws.sdk.kotlin.services.computeoptimizer.model.SavingsEstimationMode? = null
        /**
         * An object that describes the scope of the recommendation preference to create.
         *
         * You can create recommendation preferences at the organization level (for management accounts of an organization only), account level, and resource level. For more information, see [Activating enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
         *
         * You cannot create recommendation preferences for Auto Scaling groups at the organization and account levels. You can create recommendation preferences for Auto Scaling groups only at the resource level by specifying a scope name of `ResourceArn` and a scope value of the Auto Scaling group Amazon Resource Name (ARN). This will configure the preference for all instances that are part of the specified Auto Scaling group. You also cannot create recommendation preferences at the resource level for instances that are part of an Auto Scaling group. You can create recommendation preferences at the resource level only for standalone instances.
         */
        public var scope: aws.sdk.kotlin.services.computeoptimizer.model.Scope? = null
        /**
         * The preference to control the resource’s CPU utilization thresholds - threshold and headroom. When this preference isn't specified, we use the following default values:
         * + `P99_5` for threshold
         * + `PERCENT_17` for headroom
         *
         * You can only set this preference for the Amazon EC2 instance resource type.
         */
        public var utilizationPreferences: List<UtilizationPreference>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.PutRecommendationPreferencesRequest) : this() {
            this.enhancedInfrastructureMetrics = x.enhancedInfrastructureMetrics
            this.externalMetricsPreference = x.externalMetricsPreference
            this.inferredWorkloadTypes = x.inferredWorkloadTypes
            this.lookBackPeriod = x.lookBackPeriod
            this.preferredResources = x.preferredResources
            this.resourceType = x.resourceType
            this.savingsEstimationMode = x.savingsEstimationMode
            this.scope = x.scope
            this.utilizationPreferences = x.utilizationPreferences
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.PutRecommendationPreferencesRequest = PutRecommendationPreferencesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference] inside the given [block]
         */
        public fun externalMetricsPreference(block: aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference.Builder.() -> kotlin.Unit) {
            this.externalMetricsPreference = aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.Scope] inside the given [block]
         */
        public fun scope(block: aws.sdk.kotlin.services.computeoptimizer.model.Scope.Builder.() -> kotlin.Unit) {
            this.scope = aws.sdk.kotlin.services.computeoptimizer.model.Scope.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
