// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * The preference to control which resource type values are considered when generating rightsizing recommendations. You can specify this preference as a combination of include and exclude lists. You must specify either an `includeList` or `excludeList`. If the preference is an empty set of resource type values, an error occurs. For more information, see [ Rightsizing recommendation preferences](https://docs.aws.amazon.com/compute-optimizer/latest/ug/rightsizing-preferences.html) in the *Compute Optimizer User Guide*.
 *
 * + This preference is only available for the Amazon EC2 instance and Auto Scaling group resource types.
 * + Compute Optimizer only supports the customization of `Ec2InstanceTypes`.
 */
public class PreferredResource private constructor(builder: Builder) {
    /**
     * The preferred resource type values to exclude from the recommendation candidates. If this isn’t specified, all supported resources are included by default. You can specify up to 1000 values in this list.
     */
    public val excludeList: List<String>? = builder.excludeList
    /**
     * The preferred resource type values to include in the recommendation candidates. You can specify the exact resource type value, such as m5.large, or use wild card expressions, such as m5. If this isn’t specified, all supported resources are included by default. You can specify up to 1000 values in this list.
     */
    public val includeList: List<String>? = builder.includeList
    /**
     * The type of preferred resource to customize.
     *
     * Compute Optimizer only supports the customization of `Ec2InstanceTypes`.
     */
    public val name: aws.sdk.kotlin.services.computeoptimizer.model.PreferredResourceName? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.PreferredResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PreferredResource(")
        append("excludeList=$excludeList,")
        append("includeList=$includeList,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = excludeList?.hashCode() ?: 0
        result = 31 * result + (includeList?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PreferredResource

        if (excludeList != other.excludeList) return false
        if (includeList != other.includeList) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.PreferredResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The preferred resource type values to exclude from the recommendation candidates. If this isn’t specified, all supported resources are included by default. You can specify up to 1000 values in this list.
         */
        public var excludeList: List<String>? = null
        /**
         * The preferred resource type values to include in the recommendation candidates. You can specify the exact resource type value, such as m5.large, or use wild card expressions, such as m5. If this isn’t specified, all supported resources are included by default. You can specify up to 1000 values in this list.
         */
        public var includeList: List<String>? = null
        /**
         * The type of preferred resource to customize.
         *
         * Compute Optimizer only supports the customization of `Ec2InstanceTypes`.
         */
        public var name: aws.sdk.kotlin.services.computeoptimizer.model.PreferredResourceName? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.PreferredResource) : this() {
            this.excludeList = x.excludeList
            this.includeList = x.includeList
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.PreferredResource = PreferredResource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
