// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes the recommendation options for licenses.
 */
public class LicenseRecommendationOption private constructor(builder: Builder) {
    /**
     * The recommended edition of the license for the application that runs on the instance.
     */
    public val licenseEdition: aws.sdk.kotlin.services.computeoptimizer.model.LicenseEdition? = builder.licenseEdition
    /**
     * The recommended license type associated with the instance.
     */
    public val licenseModel: aws.sdk.kotlin.services.computeoptimizer.model.LicenseModel? = builder.licenseModel
    /**
     * The operating system of a license recommendation option.
     */
    public val operatingSystem: kotlin.String? = builder.operatingSystem
    /**
     * The rank of the license recommendation option.
     *
     *  The top recommendation option is ranked as `1`.
     */
    public val rank: kotlin.Int = builder.rank
    /**
     * Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an individual resource.
     *
     * Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute Optimizer recommendation.
     *
     * Savings opportunity data requires that you opt in to Cost Explorer, as well as activate **Receive Amazon EC2 resource recommendations** in the Cost Explorer preferences page. That creates a connection between Cost Explorer and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects the projected dollar savings associated with each of the recommendations generated. For more information, see [Enabling Cost Explorer](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html) and [Optimizing your cost with Rightsizing Recommendations](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html) in the *Cost Management User Guide*.
     */
    public val savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = builder.savingsOpportunity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.LicenseRecommendationOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LicenseRecommendationOption(")
        append("licenseEdition=$licenseEdition,")
        append("licenseModel=$licenseModel,")
        append("operatingSystem=$operatingSystem,")
        append("rank=$rank,")
        append("savingsOpportunity=$savingsOpportunity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = licenseEdition?.hashCode() ?: 0
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (rank)
        result = 31 * result + (savingsOpportunity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LicenseRecommendationOption

        if (licenseEdition != other.licenseEdition) return false
        if (licenseModel != other.licenseModel) return false
        if (operatingSystem != other.operatingSystem) return false
        if (rank != other.rank) return false
        if (savingsOpportunity != other.savingsOpportunity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.LicenseRecommendationOption = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The recommended edition of the license for the application that runs on the instance.
         */
        public var licenseEdition: aws.sdk.kotlin.services.computeoptimizer.model.LicenseEdition? = null
        /**
         * The recommended license type associated with the instance.
         */
        public var licenseModel: aws.sdk.kotlin.services.computeoptimizer.model.LicenseModel? = null
        /**
         * The operating system of a license recommendation option.
         */
        public var operatingSystem: kotlin.String? = null
        /**
         * The rank of the license recommendation option.
         *
         *  The top recommendation option is ranked as `1`.
         */
        public var rank: kotlin.Int = 0
        /**
         * Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an individual resource.
         *
         * Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute Optimizer recommendation.
         *
         * Savings opportunity data requires that you opt in to Cost Explorer, as well as activate **Receive Amazon EC2 resource recommendations** in the Cost Explorer preferences page. That creates a connection between Cost Explorer and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects the projected dollar savings associated with each of the recommendations generated. For more information, see [Enabling Cost Explorer](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html) and [Optimizing your cost with Rightsizing Recommendations](https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html) in the *Cost Management User Guide*.
         */
        public var savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.LicenseRecommendationOption) : this() {
            this.licenseEdition = x.licenseEdition
            this.licenseModel = x.licenseModel
            this.operatingSystem = x.operatingSystem
            this.rank = x.rank
            this.savingsOpportunity = x.savingsOpportunity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.LicenseRecommendationOption = LicenseRecommendationOption(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity] inside the given [block]
         */
        public fun savingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.savingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
