// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes the savings opportunity for Lambda functions recommendations after applying Savings Plans discounts.
 *
 * Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can achieve this by implementing a given Compute Optimizer recommendation.
 */
public class LambdaSavingsOpportunityAfterDiscounts private constructor(builder: Builder) {
    /**
     * The estimated monthly savings possible by adopting Compute Optimizer’s Lambda function recommendations. This includes any applicable Savings Plans discounts.
     */
    public val estimatedMonthlySavings: aws.sdk.kotlin.services.computeoptimizer.model.LambdaEstimatedMonthlySavings? = builder.estimatedMonthlySavings
    /**
     * The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer’s Lambda function recommendations. This includes any applicable Savings Plans discounts.
     */
    public val savingsOpportunityPercentage: kotlin.Double = builder.savingsOpportunityPercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.LambdaSavingsOpportunityAfterDiscounts = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaSavingsOpportunityAfterDiscounts(")
        append("estimatedMonthlySavings=$estimatedMonthlySavings,")
        append("savingsOpportunityPercentage=$savingsOpportunityPercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = estimatedMonthlySavings?.hashCode() ?: 0
        result = 31 * result + (savingsOpportunityPercentage.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaSavingsOpportunityAfterDiscounts

        if (estimatedMonthlySavings != other.estimatedMonthlySavings) return false
        if (savingsOpportunityPercentage != other.savingsOpportunityPercentage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.LambdaSavingsOpportunityAfterDiscounts = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The estimated monthly savings possible by adopting Compute Optimizer’s Lambda function recommendations. This includes any applicable Savings Plans discounts.
         */
        public var estimatedMonthlySavings: aws.sdk.kotlin.services.computeoptimizer.model.LambdaEstimatedMonthlySavings? = null
        /**
         * The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer’s Lambda function recommendations. This includes any applicable Savings Plans discounts.
         */
        public var savingsOpportunityPercentage: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.LambdaSavingsOpportunityAfterDiscounts) : this() {
            this.estimatedMonthlySavings = x.estimatedMonthlySavings
            this.savingsOpportunityPercentage = x.savingsOpportunityPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.LambdaSavingsOpportunityAfterDiscounts = LambdaSavingsOpportunityAfterDiscounts(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.LambdaEstimatedMonthlySavings] inside the given [block]
         */
        public fun estimatedMonthlySavings(block: aws.sdk.kotlin.services.computeoptimizer.model.LambdaEstimatedMonthlySavings.Builder.() -> kotlin.Unit) {
            this.estimatedMonthlySavings = aws.sdk.kotlin.services.computeoptimizer.model.LambdaEstimatedMonthlySavings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
