// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes a recommendation option for an Lambda function.
 */
public class LambdaFunctionMemoryRecommendationOption private constructor(builder: Builder) {
    /**
     * The memory size, in MB, of the function recommendation option.
     */
    public val memorySize: kotlin.Int = builder.memorySize
    /**
     * An array of objects that describe the projected utilization metrics of the function recommendation option.
     */
    public val projectedUtilizationMetrics: List<LambdaFunctionMemoryProjectedMetric>? = builder.projectedUtilizationMetrics
    /**
     * The rank of the function recommendation option.
     *
     * The top recommendation option is ranked as `1`.
     */
    public val rank: kotlin.Int = builder.rank
    /**
     * An object that describes the savings opportunity for the Lambda function recommendation option. Savings opportunity includes the estimated monthly savings amount and percentage.
     */
    public val savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = builder.savingsOpportunity
    /**
     * An object that describes the savings opportunity for the Lambda recommendation option which includes Saving Plans discounts. Savings opportunity includes the estimated monthly savings and percentage.
     */
    public val savingsOpportunityAfterDiscounts: aws.sdk.kotlin.services.computeoptimizer.model.LambdaSavingsOpportunityAfterDiscounts? = builder.savingsOpportunityAfterDiscounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionMemoryRecommendationOption(")
        append("memorySize=$memorySize,")
        append("projectedUtilizationMetrics=$projectedUtilizationMetrics,")
        append("rank=$rank,")
        append("savingsOpportunity=$savingsOpportunity,")
        append("savingsOpportunityAfterDiscounts=$savingsOpportunityAfterDiscounts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = memorySize
        result = 31 * result + (projectedUtilizationMetrics?.hashCode() ?: 0)
        result = 31 * result + (rank)
        result = 31 * result + (savingsOpportunity?.hashCode() ?: 0)
        result = 31 * result + (savingsOpportunityAfterDiscounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaFunctionMemoryRecommendationOption

        if (memorySize != other.memorySize) return false
        if (projectedUtilizationMetrics != other.projectedUtilizationMetrics) return false
        if (rank != other.rank) return false
        if (savingsOpportunity != other.savingsOpportunity) return false
        if (savingsOpportunityAfterDiscounts != other.savingsOpportunityAfterDiscounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The memory size, in MB, of the function recommendation option.
         */
        public var memorySize: kotlin.Int = 0
        /**
         * An array of objects that describe the projected utilization metrics of the function recommendation option.
         */
        public var projectedUtilizationMetrics: List<LambdaFunctionMemoryProjectedMetric>? = null
        /**
         * The rank of the function recommendation option.
         *
         * The top recommendation option is ranked as `1`.
         */
        public var rank: kotlin.Int = 0
        /**
         * An object that describes the savings opportunity for the Lambda function recommendation option. Savings opportunity includes the estimated monthly savings amount and percentage.
         */
        public var savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = null
        /**
         * An object that describes the savings opportunity for the Lambda recommendation option which includes Saving Plans discounts. Savings opportunity includes the estimated monthly savings and percentage.
         */
        public var savingsOpportunityAfterDiscounts: aws.sdk.kotlin.services.computeoptimizer.model.LambdaSavingsOpportunityAfterDiscounts? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption) : this() {
            this.memorySize = x.memorySize
            this.projectedUtilizationMetrics = x.projectedUtilizationMetrics
            this.rank = x.rank
            this.savingsOpportunity = x.savingsOpportunity
            this.savingsOpportunityAfterDiscounts = x.savingsOpportunityAfterDiscounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.LambdaFunctionMemoryRecommendationOption = LambdaFunctionMemoryRecommendationOption(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity] inside the given [block]
         */
        public fun savingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.savingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.LambdaSavingsOpportunityAfterDiscounts] inside the given [block]
         */
        public fun savingsOpportunityAfterDiscounts(block: aws.sdk.kotlin.services.computeoptimizer.model.LambdaSavingsOpportunityAfterDiscounts.Builder.() -> kotlin.Unit) {
            this.savingsOpportunityAfterDiscounts = aws.sdk.kotlin.services.computeoptimizer.model.LambdaSavingsOpportunityAfterDiscounts.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
