// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes the savings opportunity for instance recommendations after applying the Savings Plans and Reserved Instances discounts.
 *
 * Savings opportunity after discounts represents the estimated monthly savings you can achieve by implementing Compute Optimizer recommendations.
 */
public class InstanceSavingsOpportunityAfterDiscounts private constructor(builder: Builder) {
    /**
     * An object that describes the estimated monthly savings possible by adopting Compute Optimizer’s Amazon EC2 instance recommendations. This is based on pricing after applying the Savings Plans and Reserved Instances discounts.
     */
    public val estimatedMonthlySavings: aws.sdk.kotlin.services.computeoptimizer.model.InstanceEstimatedMonthlySavings? = builder.estimatedMonthlySavings
    /**
     * The estimated monthly savings possible as a percentage of monthly cost after applying the Savings Plans and Reserved Instances discounts. This saving can be achieved by adopting Compute Optimizer’s EC2 instance recommendations.
     */
    public val savingsOpportunityPercentage: kotlin.Double = builder.savingsOpportunityPercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.InstanceSavingsOpportunityAfterDiscounts = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceSavingsOpportunityAfterDiscounts(")
        append("estimatedMonthlySavings=$estimatedMonthlySavings,")
        append("savingsOpportunityPercentage=$savingsOpportunityPercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = estimatedMonthlySavings?.hashCode() ?: 0
        result = 31 * result + (savingsOpportunityPercentage.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceSavingsOpportunityAfterDiscounts

        if (estimatedMonthlySavings != other.estimatedMonthlySavings) return false
        if (savingsOpportunityPercentage != other.savingsOpportunityPercentage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.InstanceSavingsOpportunityAfterDiscounts = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that describes the estimated monthly savings possible by adopting Compute Optimizer’s Amazon EC2 instance recommendations. This is based on pricing after applying the Savings Plans and Reserved Instances discounts.
         */
        public var estimatedMonthlySavings: aws.sdk.kotlin.services.computeoptimizer.model.InstanceEstimatedMonthlySavings? = null
        /**
         * The estimated monthly savings possible as a percentage of monthly cost after applying the Savings Plans and Reserved Instances discounts. This saving can be achieved by adopting Compute Optimizer’s EC2 instance recommendations.
         */
        public var savingsOpportunityPercentage: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.InstanceSavingsOpportunityAfterDiscounts) : this() {
            this.estimatedMonthlySavings = x.estimatedMonthlySavings
            this.savingsOpportunityPercentage = x.savingsOpportunityPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.InstanceSavingsOpportunityAfterDiscounts = InstanceSavingsOpportunityAfterDiscounts(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.InstanceEstimatedMonthlySavings] inside the given [block]
         */
        public fun estimatedMonthlySavings(block: aws.sdk.kotlin.services.computeoptimizer.model.InstanceEstimatedMonthlySavings.Builder.() -> kotlin.Unit) {
            this.estimatedMonthlySavings = aws.sdk.kotlin.services.computeoptimizer.model.InstanceEstimatedMonthlySavings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
