// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



public class GetLicenseRecommendationsRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account for which to return license recommendations.
     *
     * If your account is the management account of an organization, use this parameter to specify the member account for which you want to return license recommendations.
     *
     * Only one account ID can be specified per request.
     */
    public val accountIds: List<String>? = builder.accountIds
    /**
     * An array of objects to specify a filter that returns a more specific list of license recommendations.
     */
    public val filters: List<LicenseRecommendationFilter>? = builder.filters
    /**
     * The maximum number of license recommendations to return with a single request.
     *
     *  To retrieve the remaining results, make another request with the returned `nextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to advance to the next page of license recommendations.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ARN that identifies the Amazon EC2 instance.
     *
     *  The following is the format of the ARN:
     *
     * `arn:aws:ec2:region:aws_account_id:instance/instance-id`
     */
    public val resourceArns: List<String>? = builder.resourceArns

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.GetLicenseRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetLicenseRecommendationsRequest(")
        append("accountIds=$accountIds,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceArns=$resourceArns")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetLicenseRecommendationsRequest

        if (accountIds != other.accountIds) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceArns != other.resourceArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.GetLicenseRecommendationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Web Services account for which to return license recommendations.
         *
         * If your account is the management account of an organization, use this parameter to specify the member account for which you want to return license recommendations.
         *
         * Only one account ID can be specified per request.
         */
        public var accountIds: List<String>? = null
        /**
         * An array of objects to specify a filter that returns a more specific list of license recommendations.
         */
        public var filters: List<LicenseRecommendationFilter>? = null
        /**
         * The maximum number of license recommendations to return with a single request.
         *
         *  To retrieve the remaining results, make another request with the returned `nextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to advance to the next page of license recommendations.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ARN that identifies the Amazon EC2 instance.
         *
         *  The following is the format of the ARN:
         *
         * `arn:aws:ec2:region:aws_account_id:instance/instance-id`
         */
        public var resourceArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.GetLicenseRecommendationsRequest) : this() {
            this.accountIds = x.accountIds
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceArns = x.resourceArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.GetLicenseRecommendationsRequest = GetLicenseRecommendationsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
