// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



public class GetEffectiveRecommendationPreferencesResponse private constructor(builder: Builder) {
    /**
     * The status of the enhanced infrastructure metrics recommendation preference. Considers all applicable preferences that you might have set at the resource, account, and organization level.
     *
     * A status of `Active` confirms that the preference is applied in the latest recommendation refresh, and a status of `Inactive` confirms that it's not yet applied to recommendations.
     *
     * To validate whether the preference is applied to your last generated set of recommendations, review the `effectiveRecommendationPreferences` value in the response of the GetAutoScalingGroupRecommendations and GetEC2InstanceRecommendations actions.
     *
     * For more information, see [Enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
     */
    public val enhancedInfrastructureMetrics: aws.sdk.kotlin.services.computeoptimizer.model.EnhancedInfrastructureMetrics? = builder.enhancedInfrastructureMetrics
    /**
     * The provider of the external metrics recommendation preference. Considers all applicable preferences that you might have set at the account and organization level.
     *
     * If the preference is applied in the latest recommendation refresh, an object with a valid `source` value appears in the response. If the preference isn't applied to the recommendations already, then this object doesn't appear in the response.
     *
     * To validate whether the preference is applied to your last generated set of recommendations, review the `effectiveRecommendationPreferences` value in the response of the GetEC2InstanceRecommendations actions.
     *
     * For more information, see [Enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html) in the *Compute Optimizer User Guide*.
     */
    public val externalMetricsPreference: aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference? = builder.externalMetricsPreference
    /**
     * The number of days the utilization metrics of the Amazon Web Services resource are analyzed.
     *
     * To validate that the preference is applied to your last generated set of recommendations, review the `effectiveRecommendationPreferences` value in the response of the GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
     */
    public val lookBackPeriod: aws.sdk.kotlin.services.computeoptimizer.model.LookBackPeriodPreference? = builder.lookBackPeriod
    /**
     * The resource type values that are considered as candidates when generating rightsizing recommendations. This object resolves any wildcard expressions and returns the effective list of candidate resource type values. It also considers all applicable preferences that you set at the resource, account, and organization level.
     *
     * To validate that the preference is applied to your last generated set of recommendations, review the `effectiveRecommendationPreferences` value in the response of the GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
     */
    public val preferredResources: List<EffectivePreferredResource>? = builder.preferredResources
    /**
     * The resource’s CPU utilization threshold preferences, such as threshold and headroom, that were used to generate rightsizing recommendations. It considers all applicable preferences that you set at the resource, account, and organization level.
     *
     * To validate that the preference is applied to your last generated set of recommendations, review the `effectiveRecommendationPreferences` value in the response of the GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
     */
    public val utilizationPreferences: List<UtilizationPreference>? = builder.utilizationPreferences

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetEffectiveRecommendationPreferencesResponse(")
        append("enhancedInfrastructureMetrics=$enhancedInfrastructureMetrics,")
        append("externalMetricsPreference=$externalMetricsPreference,")
        append("lookBackPeriod=$lookBackPeriod,")
        append("preferredResources=$preferredResources,")
        append("utilizationPreferences=$utilizationPreferences")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enhancedInfrastructureMetrics?.hashCode() ?: 0
        result = 31 * result + (externalMetricsPreference?.hashCode() ?: 0)
        result = 31 * result + (lookBackPeriod?.hashCode() ?: 0)
        result = 31 * result + (preferredResources?.hashCode() ?: 0)
        result = 31 * result + (utilizationPreferences?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetEffectiveRecommendationPreferencesResponse

        if (enhancedInfrastructureMetrics != other.enhancedInfrastructureMetrics) return false
        if (externalMetricsPreference != other.externalMetricsPreference) return false
        if (lookBackPeriod != other.lookBackPeriod) return false
        if (preferredResources != other.preferredResources) return false
        if (utilizationPreferences != other.utilizationPreferences) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The status of the enhanced infrastructure metrics recommendation preference. Considers all applicable preferences that you might have set at the resource, account, and organization level.
         *
         * A status of `Active` confirms that the preference is applied in the latest recommendation refresh, and a status of `Inactive` confirms that it's not yet applied to recommendations.
         *
         * To validate whether the preference is applied to your last generated set of recommendations, review the `effectiveRecommendationPreferences` value in the response of the GetAutoScalingGroupRecommendations and GetEC2InstanceRecommendations actions.
         *
         * For more information, see [Enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html) in the *Compute Optimizer User Guide*.
         */
        public var enhancedInfrastructureMetrics: aws.sdk.kotlin.services.computeoptimizer.model.EnhancedInfrastructureMetrics? = null
        /**
         * The provider of the external metrics recommendation preference. Considers all applicable preferences that you might have set at the account and organization level.
         *
         * If the preference is applied in the latest recommendation refresh, an object with a valid `source` value appears in the response. If the preference isn't applied to the recommendations already, then this object doesn't appear in the response.
         *
         * To validate whether the preference is applied to your last generated set of recommendations, review the `effectiveRecommendationPreferences` value in the response of the GetEC2InstanceRecommendations actions.
         *
         * For more information, see [Enhanced infrastructure metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html) in the *Compute Optimizer User Guide*.
         */
        public var externalMetricsPreference: aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference? = null
        /**
         * The number of days the utilization metrics of the Amazon Web Services resource are analyzed.
         *
         * To validate that the preference is applied to your last generated set of recommendations, review the `effectiveRecommendationPreferences` value in the response of the GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         */
        public var lookBackPeriod: aws.sdk.kotlin.services.computeoptimizer.model.LookBackPeriodPreference? = null
        /**
         * The resource type values that are considered as candidates when generating rightsizing recommendations. This object resolves any wildcard expressions and returns the effective list of candidate resource type values. It also considers all applicable preferences that you set at the resource, account, and organization level.
         *
         * To validate that the preference is applied to your last generated set of recommendations, review the `effectiveRecommendationPreferences` value in the response of the GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         */
        public var preferredResources: List<EffectivePreferredResource>? = null
        /**
         * The resource’s CPU utilization threshold preferences, such as threshold and headroom, that were used to generate rightsizing recommendations. It considers all applicable preferences that you set at the resource, account, and organization level.
         *
         * To validate that the preference is applied to your last generated set of recommendations, review the `effectiveRecommendationPreferences` value in the response of the GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         */
        public var utilizationPreferences: List<UtilizationPreference>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse) : this() {
            this.enhancedInfrastructureMetrics = x.enhancedInfrastructureMetrics
            this.externalMetricsPreference = x.externalMetricsPreference
            this.lookBackPeriod = x.lookBackPeriod
            this.preferredResources = x.preferredResources
            this.utilizationPreferences = x.utilizationPreferences
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse = GetEffectiveRecommendationPreferencesResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference] inside the given [block]
         */
        public fun externalMetricsPreference(block: aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference.Builder.() -> kotlin.Unit) {
            this.externalMetricsPreference = aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
