// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



public class GetEcsServiceRecommendationsRequest private constructor(builder: Builder) {
    /**
     * Return the Amazon ECS service recommendations to the specified Amazon Web Services account IDs.
     *
     * If your account is the management account or the delegated administrator of an organization, use this parameter to return the Amazon ECS service recommendations to specific member accounts.
     *
     * You can only specify one account ID per request.
     */
    public val accountIds: List<String>? = builder.accountIds
    /**
     * An array of objects to specify a filter that returns a more specific list of Amazon ECS service recommendations.
     */
    public val filters: List<EcsServiceRecommendationFilter>? = builder.filters
    /**
     * The maximum number of Amazon ECS service recommendations to return with a single request.
     *
     * To retrieve the remaining results, make another request with the returned `nextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to advance to the next page of Amazon ECS service recommendations.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ARN that identifies the Amazon ECS service.
     *
     *  The following is the format of the ARN:
     *
     * `arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name`
     */
    public val serviceArns: List<String>? = builder.serviceArns

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.GetEcsServiceRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetEcsServiceRecommendationsRequest(")
        append("accountIds=$accountIds,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("serviceArns=$serviceArns")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (serviceArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetEcsServiceRecommendationsRequest

        if (accountIds != other.accountIds) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (serviceArns != other.serviceArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.GetEcsServiceRecommendationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Return the Amazon ECS service recommendations to the specified Amazon Web Services account IDs.
         *
         * If your account is the management account or the delegated administrator of an organization, use this parameter to return the Amazon ECS service recommendations to specific member accounts.
         *
         * You can only specify one account ID per request.
         */
        public var accountIds: List<String>? = null
        /**
         * An array of objects to specify a filter that returns a more specific list of Amazon ECS service recommendations.
         */
        public var filters: List<EcsServiceRecommendationFilter>? = null
        /**
         * The maximum number of Amazon ECS service recommendations to return with a single request.
         *
         * To retrieve the remaining results, make another request with the returned `nextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to advance to the next page of Amazon ECS service recommendations.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ARN that identifies the Amazon ECS service.
         *
         *  The following is the format of the ARN:
         *
         * `arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name`
         */
        public var serviceArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.GetEcsServiceRecommendationsRequest) : this() {
            this.accountIds = x.accountIds
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.serviceArns = x.serviceArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.GetEcsServiceRecommendationsRequest = GetEcsServiceRecommendationsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
