// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



public class GetEc2InstanceRecommendationsRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account for which to return instance recommendations.
     *
     * If your account is the management account of an organization, use this parameter to specify the member account for which you want to return instance recommendations.
     *
     * Only one account ID can be specified per request.
     */
    public val accountIds: List<String>? = builder.accountIds
    /**
     * An array of objects to specify a filter that returns a more specific list of instance recommendations.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The Amazon Resource Name (ARN) of the instances for which to return recommendations.
     */
    public val instanceArns: List<String>? = builder.instanceArns
    /**
     * The maximum number of instance recommendations to return with a single request.
     *
     * To retrieve the remaining results, make another request with the returned `nextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to advance to the next page of instance recommendations.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * An object to specify the preferences for the Amazon EC2 instance recommendations to return in the response.
     */
    public val recommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences? = builder.recommendationPreferences

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetEc2InstanceRecommendationsRequest(")
        append("accountIds=$accountIds,")
        append("filters=$filters,")
        append("instanceArns=$instanceArns,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("recommendationPreferences=$recommendationPreferences")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (instanceArns?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (recommendationPreferences?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetEc2InstanceRecommendationsRequest

        if (accountIds != other.accountIds) return false
        if (filters != other.filters) return false
        if (instanceArns != other.instanceArns) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (recommendationPreferences != other.recommendationPreferences) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Web Services account for which to return instance recommendations.
         *
         * If your account is the management account of an organization, use this parameter to specify the member account for which you want to return instance recommendations.
         *
         * Only one account ID can be specified per request.
         */
        public var accountIds: List<String>? = null
        /**
         * An array of objects to specify a filter that returns a more specific list of instance recommendations.
         */
        public var filters: List<Filter>? = null
        /**
         * The Amazon Resource Name (ARN) of the instances for which to return recommendations.
         */
        public var instanceArns: List<String>? = null
        /**
         * The maximum number of instance recommendations to return with a single request.
         *
         * To retrieve the remaining results, make another request with the returned `nextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to advance to the next page of instance recommendations.
         */
        public var nextToken: kotlin.String? = null
        /**
         * An object to specify the preferences for the Amazon EC2 instance recommendations to return in the response.
         */
        public var recommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest) : this() {
            this.accountIds = x.accountIds
            this.filters = x.filters
            this.instanceArns = x.instanceArns
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.recommendationPreferences = x.recommendationPreferences
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest = GetEc2InstanceRecommendationsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences] inside the given [block]
         */
        public fun recommendationPreferences(block: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences.Builder.() -> kotlin.Unit) {
            this.recommendationPreferences = aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
