// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes the projected utilization metrics of an Amazon ECS service recommendation option.
 *
 * To determine the performance difference between your current Amazon ECS service and the recommended option, compare the utilization metric data of your service against its projected utilization metric data.
 */
public class EcsServiceProjectedUtilizationMetric private constructor(builder: Builder) {
    /**
     * The lower bound values for the projected utilization metrics.
     */
    public val lowerBoundValue: kotlin.Double = builder.lowerBoundValue
    /**
     * The name of the projected utilization metric.
     *
     * The following utilization metrics are available:
     * + `Cpu` — The percentage of allocated compute units that are currently in use on the service tasks.
     * + `Memory` — The percentage of memory that's currently in use on the service tasks.
     */
    public val name: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceMetricName? = builder.name
    /**
     * The statistic of the projected utilization metric.
     *
     * The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the `Maximum` statistic, which is the highest value observed during the specified period.
     *
     * The Compute Optimizer console displays graphs for some utilization metrics using the `Average` statistic, which is the value of `Sum` / `SampleCount` during the specified period. For more information, see [Viewing resource recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html) in the *Compute Optimizer User Guide*. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html).
     */
    public val statistic: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceMetricStatistic? = builder.statistic
    /**
     * The upper bound values for the projected utilization metrics.
     */
    public val upperBoundValue: kotlin.Double = builder.upperBoundValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceProjectedUtilizationMetric = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EcsServiceProjectedUtilizationMetric(")
        append("lowerBoundValue=$lowerBoundValue,")
        append("name=$name,")
        append("statistic=$statistic,")
        append("upperBoundValue=$upperBoundValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lowerBoundValue.hashCode()
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (statistic?.hashCode() ?: 0)
        result = 31 * result + (upperBoundValue.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EcsServiceProjectedUtilizationMetric

        if (lowerBoundValue != other.lowerBoundValue) return false
        if (name != other.name) return false
        if (statistic != other.statistic) return false
        if (upperBoundValue != other.upperBoundValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceProjectedUtilizationMetric = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The lower bound values for the projected utilization metrics.
         */
        public var lowerBoundValue: kotlin.Double = 0.0
        /**
         * The name of the projected utilization metric.
         *
         * The following utilization metrics are available:
         * + `Cpu` — The percentage of allocated compute units that are currently in use on the service tasks.
         * + `Memory` — The percentage of memory that's currently in use on the service tasks.
         */
        public var name: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceMetricName? = null
        /**
         * The statistic of the projected utilization metric.
         *
         * The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the `Maximum` statistic, which is the highest value observed during the specified period.
         *
         * The Compute Optimizer console displays graphs for some utilization metrics using the `Average` statistic, which is the value of `Sum` / `SampleCount` during the specified period. For more information, see [Viewing resource recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html) in the *Compute Optimizer User Guide*. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html).
         */
        public var statistic: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceMetricStatistic? = null
        /**
         * The upper bound values for the projected utilization metrics.
         */
        public var upperBoundValue: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceProjectedUtilizationMetric) : this() {
            this.lowerBoundValue = x.lowerBoundValue
            this.name = x.name
            this.statistic = x.statistic
            this.upperBoundValue = x.upperBoundValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.EcsServiceProjectedUtilizationMetric = EcsServiceProjectedUtilizationMetric(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
