// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.transform

import aws.sdk.kotlin.services.comprehend.model.ComprehendException
import aws.sdk.kotlin.services.comprehend.model.JobStatus
import aws.sdk.kotlin.services.comprehend.model.StartEntitiesDetectionJobResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartEntitiesDetectionJobOperationDeserializer: HttpDeserialize<StartEntitiesDetectionJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartEntitiesDetectionJobResponse {
        if (!response.status.isSuccess()) {
            throwStartEntitiesDetectionJobError(context, response)
        }
        val builder = StartEntitiesDetectionJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartEntitiesDetectionJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwStartEntitiesDetectionJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ComprehendException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "KmsKeyValidationException" -> KmsKeyValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceUnavailableException" -> ResourceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyTagsException" -> TooManyTagsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ComprehendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartEntitiesDetectionJobOperationBody(builder: StartEntitiesDetectionJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENTITYRECOGNIZERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EntityRecognizerArn"))
    val JOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobArn"))
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobId"))
    val JOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("JobStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENTITYRECOGNIZERARN_DESCRIPTOR)
        field(JOBARN_DESCRIPTOR)
        field(JOBID_DESCRIPTOR)
        field(JOBSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENTITYRECOGNIZERARN_DESCRIPTOR.index -> builder.entityRecognizerArn = deserializeString()
                JOBARN_DESCRIPTOR.index -> builder.jobArn = deserializeString()
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                JOBSTATUS_DESCRIPTOR.index -> builder.jobStatus = deserializeString().let { JobStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
