// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.transform

import aws.sdk.kotlin.services.comprehend.model.ComprehendException
import aws.sdk.kotlin.services.comprehend.model.DominantLanguageDetectionJobProperties
import aws.sdk.kotlin.services.comprehend.model.ListDominantLanguageDetectionJobsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListDominantLanguageDetectionJobsOperationDeserializer: HttpDeserialize<ListDominantLanguageDetectionJobsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListDominantLanguageDetectionJobsResponse {
        if (!response.status.isSuccess()) {
            throwListDominantLanguageDetectionJobsError(context, response)
        }
        val builder = ListDominantLanguageDetectionJobsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListDominantLanguageDetectionJobsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListDominantLanguageDetectionJobsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ComprehendException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidFilterException" -> InvalidFilterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ComprehendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListDominantLanguageDetectionJobsOperationBody(builder: ListDominantLanguageDetectionJobsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOMINANTLANGUAGEDETECTIONJOBPROPERTIESLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DominantLanguageDetectionJobPropertiesList"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOMINANTLANGUAGEDETECTIONJOBPROPERTIESLIST_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOMINANTLANGUAGEDETECTIONJOBPROPERTIESLIST_DESCRIPTOR.index -> builder.dominantLanguageDetectionJobPropertiesList =
                    deserializer.deserializeList(DOMINANTLANGUAGEDETECTIONJOBPROPERTIESLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<DominantLanguageDetectionJobProperties>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDominantLanguageDetectionJobPropertiesDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
