// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.transform

import aws.sdk.kotlin.services.comprehend.model.ComprehendException
import aws.sdk.kotlin.services.comprehend.model.DetectSyntaxResponse
import aws.sdk.kotlin.services.comprehend.model.SyntaxToken
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DetectSyntaxOperationDeserializer: HttpDeserialize<DetectSyntaxResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DetectSyntaxResponse {
        if (!response.status.isSuccess()) {
            throwDetectSyntaxError(context, response)
        }
        val builder = DetectSyntaxResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDetectSyntaxOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDetectSyntaxError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ComprehendException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "TextSizeLimitExceededException" -> TextSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedLanguageException" -> UnsupportedLanguageExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ComprehendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDetectSyntaxOperationBody(builder: DetectSyntaxResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SYNTAXTOKENS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SyntaxTokens"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SYNTAXTOKENS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SYNTAXTOKENS_DESCRIPTOR.index -> builder.syntaxTokens =
                    deserializer.deserializeList(SYNTAXTOKENS_DESCRIPTOR) {
                        val col0 = mutableListOf<SyntaxToken>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSyntaxTokenDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
