// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.transform

import aws.sdk.kotlin.services.comprehend.model.BatchDetectTargetedSentimentItemResult
import aws.sdk.kotlin.services.comprehend.model.BatchDetectTargetedSentimentResponse
import aws.sdk.kotlin.services.comprehend.model.BatchItemError
import aws.sdk.kotlin.services.comprehend.model.ComprehendException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchDetectTargetedSentimentOperationDeserializer: HttpDeserialize<BatchDetectTargetedSentimentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchDetectTargetedSentimentResponse {
        if (!response.status.isSuccess()) {
            throwBatchDetectTargetedSentimentError(context, response)
        }
        val builder = BatchDetectTargetedSentimentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchDetectTargetedSentimentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchDetectTargetedSentimentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ComprehendException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BatchSizeLimitExceededException" -> BatchSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "TextSizeLimitExceededException" -> TextSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedLanguageException" -> UnsupportedLanguageExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ComprehendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchDetectTargetedSentimentOperationBody(builder: BatchDetectTargetedSentimentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ErrorList"))
    val RESULTLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResultList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORLIST_DESCRIPTOR)
        field(RESULTLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORLIST_DESCRIPTOR.index -> builder.errorList =
                    deserializer.deserializeList(ERRORLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchItemError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchItemErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESULTLIST_DESCRIPTOR.index -> builder.resultList =
                    deserializer.deserializeList(RESULTLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchDetectTargetedSentimentItemResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchDetectTargetedSentimentItemResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
