// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



public class StartSentimentDetectionJobResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the sentiment detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:
     *
     * `arn:<partition>:comprehend:<region>:<account-id>:sentiment-detection-job/<job-id>`
     *
     * The following is an example job ARN:
     *
     * `arn:aws:comprehend:us-west-2:111122223333:sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab`
     */
    public val jobArn: kotlin.String? = builder.jobArn
    /**
     * The identifier generated for the job. To get the status of a job, use this identifier with the operation.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The status of the job.
     * + SUBMITTED - The job has been received and is queued for processing.
     * + IN_PROGRESS - Amazon Comprehend is processing the job.
     * + COMPLETED - The job was successfully completed and the output is available.
     * + FAILED - The job did not complete. To get details, use the operation.
     */
    public val jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = builder.jobStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.StartSentimentDetectionJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartSentimentDetectionJobResponse(")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("jobStatus=$jobStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = jobArn?.hashCode() ?: 0
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartSentimentDetectionJobResponse

        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (jobStatus != other.jobStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.StartSentimentDetectionJobResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the sentiment detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:
         *
         * `arn:<partition>:comprehend:<region>:<account-id>:sentiment-detection-job/<job-id>`
         *
         * The following is an example job ARN:
         *
         * `arn:aws:comprehend:us-west-2:111122223333:sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab`
         */
        public var jobArn: kotlin.String? = null
        /**
         * The identifier generated for the job. To get the status of a job, use this identifier with the operation.
         */
        public var jobId: kotlin.String? = null
        /**
         * The status of the job.
         * + SUBMITTED - The job has been received and is queued for processing.
         * + IN_PROGRESS - Amazon Comprehend is processing the job.
         * + COMPLETED - The job was successfully completed and the output is available.
         * + FAILED - The job did not complete. To get details, use the operation.
         */
        public var jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.StartSentimentDetectionJobResponse) : this() {
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.jobStatus = x.jobStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.StartSentimentDetectionJobResponse = StartSentimentDetectionJobResponse(this)
    }
}
