// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



public class StartDocumentClassificationJobRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
     */
    public val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * The Amazon Resource Name (ARN) of the document classifier to use to process the job.
     */
    public val documentClassifierArn: kotlin.String? = builder.documentClassifierArn
    /**
     * The Amazon Resource Number (ARN) of the flywheel associated with the model to use.
     */
    public val flywheelArn: kotlin.String? = builder.flywheelArn
    /**
     * Specifies the format and location of the input data for the job.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.comprehend.model.InputDataConfig? = builder.inputDataConfig
    /**
     * The identifier of the job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * Specifies where to send the output files.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig? = builder.outputDataConfig
    /**
     * Tags to associate with the document classification job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
     * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     */
    public val volumeKmsKeyId: kotlin.String? = builder.volumeKmsKeyId
    /**
     * Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your document classification job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.StartDocumentClassificationJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartDocumentClassificationJobRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("documentClassifierArn=$documentClassifierArn,")
        append("flywheelArn=$flywheelArn,")
        append("inputDataConfig=$inputDataConfig,")
        append("jobName=$jobName,")
        append("outputDataConfig=$outputDataConfig,")
        append("tags=$tags,")
        append("volumeKmsKeyId=$volumeKmsKeyId,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (dataAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (documentClassifierArn?.hashCode() ?: 0)
        result = 31 * result + (flywheelArn?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (volumeKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartDocumentClassificationJobRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (documentClassifierArn != other.documentClassifierArn) return false
        if (flywheelArn != other.flywheelArn) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (jobName != other.jobName) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (tags != other.tags) return false
        if (volumeKmsKeyId != other.volumeKmsKeyId) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.StartDocumentClassificationJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier for the request. If you do not set the client request token, Amazon Comprehend generates one.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the document classifier to use to process the job.
         */
        public var documentClassifierArn: kotlin.String? = null
        /**
         * The Amazon Resource Number (ARN) of the flywheel associated with the model to use.
         */
        public var flywheelArn: kotlin.String? = null
        /**
         * Specifies the format and location of the input data for the job.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.comprehend.model.InputDataConfig? = null
        /**
         * The identifier of the job.
         */
        public var jobName: kotlin.String? = null
        /**
         * Specifies where to send the output files.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig? = null
        /**
         * Tags to associate with the document classification job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
         */
        public var tags: List<Tag>? = null
        /**
         * ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
         * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         */
        public var volumeKmsKeyId: kotlin.String? = null
        /**
         * Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for your document classification job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.StartDocumentClassificationJobRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.documentClassifierArn = x.documentClassifierArn
            this.flywheelArn = x.flywheelArn
            this.inputDataConfig = x.inputDataConfig
            this.jobName = x.jobName
            this.outputDataConfig = x.outputDataConfig
            this.tags = x.tags
            this.volumeKmsKeyId = x.volumeKmsKeyId
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.StartDocumentClassificationJobRequest = StartDocumentClassificationJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.InputDataConfig] inside the given [block]
         */
        public fun inputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.InputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.comprehend.model.InputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.OutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.comprehend.model.OutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.comprehend.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.comprehend.model.VpcConfig.invoke(block)
        }
    }
}
