// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



/**
 * Specifies the format and location of the input data.
 */
public class EntityRecognizerInputDataConfig private constructor(builder: Builder) {
    /**
     * The S3 location of the CSV file that annotates your training documents.
     */
    public val annotations: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerAnnotations? = builder.annotations
    /**
     * A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
     *
     * This parameter is required if you set `DataFormat` to `AUGMENTED_MANIFEST`.
     */
    public val augmentedManifests: List<AugmentedManifestsListItem>? = builder.augmentedManifests
    /**
     * The format of your training data:
     * + `COMPREHEND_CSV`: A CSV file that supplements your training documents. The CSV file contains information about the custom entities that your trained model will detect. The required format of the file depends on whether you are providing annotations or an entity list.If you use this value, you must provide your CSV file by using either the `Annotations` or `EntityList` parameters. You must provide your training documents by using the `Documents` parameter.
     * + `AUGMENTED_MANIFEST`: A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its labels. Each label annotates a named entity in the training document. If you use this value, you must provide the `AugmentedManifests` parameter in your request.
     *
     * If you don't specify a value, Amazon Comprehend uses `COMPREHEND_CSV` as the default.
     */
    public val dataFormat: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerDataFormat? = builder.dataFormat
    /**
     * The S3 location of the folder that contains the training documents for your custom entity recognizer.
     *
     * This parameter is required if you set `DataFormat` to `COMPREHEND_CSV`.
     */
    public val documents: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerDocuments? = builder.documents
    /**
     * The S3 location of the CSV file that has the entity list for your custom entity recognizer.
     */
    public val entityList: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerEntityList? = builder.entityList
    /**
     * The entity types in the labeled training data that Amazon Comprehend uses to train the custom entity recognizer. Any entity types that you don't specify are ignored.
     *
     * A maximum of 25 entity types can be used at one time to train an entity recognizer. Entity types must not contain the following invalid characters: \n (line break), \\n (escaped line break), \r (carriage return), \\r (escaped carriage return), \t (tab), \\t (escaped tab), space, and , (comma).
     */
    public val entityTypes: List<EntityTypesListItem>? = builder.entityTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.EntityRecognizerInputDataConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EntityRecognizerInputDataConfig(")
        append("annotations=$annotations,")
        append("augmentedManifests=$augmentedManifests,")
        append("dataFormat=$dataFormat,")
        append("documents=$documents,")
        append("entityList=$entityList,")
        append("entityTypes=$entityTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = annotations?.hashCode() ?: 0
        result = 31 * result + (augmentedManifests?.hashCode() ?: 0)
        result = 31 * result + (dataFormat?.hashCode() ?: 0)
        result = 31 * result + (documents?.hashCode() ?: 0)
        result = 31 * result + (entityList?.hashCode() ?: 0)
        result = 31 * result + (entityTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EntityRecognizerInputDataConfig

        if (annotations != other.annotations) return false
        if (augmentedManifests != other.augmentedManifests) return false
        if (dataFormat != other.dataFormat) return false
        if (documents != other.documents) return false
        if (entityList != other.entityList) return false
        if (entityTypes != other.entityTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.EntityRecognizerInputDataConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The S3 location of the CSV file that annotates your training documents.
         */
        public var annotations: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerAnnotations? = null
        /**
         * A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
         *
         * This parameter is required if you set `DataFormat` to `AUGMENTED_MANIFEST`.
         */
        public var augmentedManifests: List<AugmentedManifestsListItem>? = null
        /**
         * The format of your training data:
         * + `COMPREHEND_CSV`: A CSV file that supplements your training documents. The CSV file contains information about the custom entities that your trained model will detect. The required format of the file depends on whether you are providing annotations or an entity list.If you use this value, you must provide your CSV file by using either the `Annotations` or `EntityList` parameters. You must provide your training documents by using the `Documents` parameter.
         * + `AUGMENTED_MANIFEST`: A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its labels. Each label annotates a named entity in the training document. If you use this value, you must provide the `AugmentedManifests` parameter in your request.
         *
         * If you don't specify a value, Amazon Comprehend uses `COMPREHEND_CSV` as the default.
         */
        public var dataFormat: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerDataFormat? = null
        /**
         * The S3 location of the folder that contains the training documents for your custom entity recognizer.
         *
         * This parameter is required if you set `DataFormat` to `COMPREHEND_CSV`.
         */
        public var documents: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerDocuments? = null
        /**
         * The S3 location of the CSV file that has the entity list for your custom entity recognizer.
         */
        public var entityList: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerEntityList? = null
        /**
         * The entity types in the labeled training data that Amazon Comprehend uses to train the custom entity recognizer. Any entity types that you don't specify are ignored.
         *
         * A maximum of 25 entity types can be used at one time to train an entity recognizer. Entity types must not contain the following invalid characters: \n (line break), \\n (escaped line break), \r (carriage return), \\r (escaped carriage return), \t (tab), \\t (escaped tab), space, and , (comma).
         */
        public var entityTypes: List<EntityTypesListItem>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerInputDataConfig) : this() {
            this.annotations = x.annotations
            this.augmentedManifests = x.augmentedManifests
            this.dataFormat = x.dataFormat
            this.documents = x.documents
            this.entityList = x.entityList
            this.entityTypes = x.entityTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.EntityRecognizerInputDataConfig = EntityRecognizerInputDataConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.EntityRecognizerAnnotations] inside the given [block]
         */
        public fun annotations(block: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerAnnotations.Builder.() -> kotlin.Unit) {
            this.annotations = aws.sdk.kotlin.services.comprehend.model.EntityRecognizerAnnotations.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.EntityRecognizerDocuments] inside the given [block]
         */
        public fun documents(block: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerDocuments.Builder.() -> kotlin.Unit) {
            this.documents = aws.sdk.kotlin.services.comprehend.model.EntityRecognizerDocuments.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.EntityRecognizerEntityList] inside the given [block]
         */
        public fun entityList(block: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerEntityList.Builder.() -> kotlin.Unit) {
            this.entityList = aws.sdk.kotlin.services.comprehend.model.EntityRecognizerEntityList.invoke(block)
        }
    }
}
