// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



/**
 * Data security configuration.
 */
public class DataSecurityConfig private constructor(builder: Builder) {
    /**
     * ID for the KMS key that Amazon Comprehend uses to encrypt the data in the data lake.
     */
    public val dataLakeKmsKeyId: kotlin.String? = builder.dataLakeKmsKeyId
    /**
     * ID for the KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:
     * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     */
    public val modelKmsKeyId: kotlin.String? = builder.modelKmsKeyId
    /**
     * ID for the KMS key that Amazon Comprehend uses to encrypt the volume.
     */
    public val volumeKmsKeyId: kotlin.String? = builder.volumeKmsKeyId
    /**
     * Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for the job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.DataSecurityConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSecurityConfig(")
        append("dataLakeKmsKeyId=$dataLakeKmsKeyId,")
        append("modelKmsKeyId=$modelKmsKeyId,")
        append("volumeKmsKeyId=$volumeKmsKeyId,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataLakeKmsKeyId?.hashCode() ?: 0
        result = 31 * result + (modelKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (volumeKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSecurityConfig

        if (dataLakeKmsKeyId != other.dataLakeKmsKeyId) return false
        if (modelKmsKeyId != other.modelKmsKeyId) return false
        if (volumeKmsKeyId != other.volumeKmsKeyId) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.DataSecurityConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * ID for the KMS key that Amazon Comprehend uses to encrypt the data in the data lake.
         */
        public var dataLakeKmsKeyId: kotlin.String? = null
        /**
         * ID for the KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:
         * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         */
        public var modelKmsKeyId: kotlin.String? = null
        /**
         * ID for the KMS key that Amazon Comprehend uses to encrypt the volume.
         */
        public var volumeKmsKeyId: kotlin.String? = null
        /**
         * Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for the job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.DataSecurityConfig) : this() {
            this.dataLakeKmsKeyId = x.dataLakeKmsKeyId
            this.modelKmsKeyId = x.modelKmsKeyId
            this.volumeKmsKeyId = x.volumeKmsKeyId
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.DataSecurityConfig = DataSecurityConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.comprehend.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.comprehend.model.VpcConfig.invoke(block)
        }
    }
}
