// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



public class ClassifyDocumentRequest private constructor(builder: Builder) {
    /**
     * Use the `Bytes` parameter to input a text, PDF, Word or image file. You can also use the `Bytes` parameter to input an Amazon Textract `DetectDocumentText` or `AnalyzeDocument` output file.
     *
     * Provide the input document as a sequence of base64-encoded bytes. If your code uses an Amazon Web Services SDK to classify documents, the SDK may encode the document file bytes for you.
     *
     * The maximum length of this field depends on the input document type. For details, see [ Inputs for real-time custom analysis](https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync.html) in the Comprehend Developer Guide.
     *
     * If you use the `Bytes` parameter, do not use the `Text` parameter.
     */
    public val bytes: kotlin.ByteArray? = builder.bytes
    /**
     * Provides configuration parameters to override the default actions for extracting text from PDF documents and image files.
     */
    public val documentReaderConfig: aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig? = builder.documentReaderConfig
    /**
     * The Amazon Resource Number (ARN) of the endpoint. For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
     */
    public val endpointArn: kotlin.String? = builder.endpointArn
    /**
     * The document text to be analyzed. If you enter text using this parameter, do not use the `Bytes` parameter.
     */
    public val text: kotlin.String? = builder.text

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.ClassifyDocumentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClassifyDocumentRequest(")
        append("bytes=$bytes,")
        append("documentReaderConfig=$documentReaderConfig,")
        append("endpointArn=$endpointArn,")
        append("text=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bytes?.contentHashCode() ?: 0
        result = 31 * result + (documentReaderConfig?.hashCode() ?: 0)
        result = 31 * result + (endpointArn?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClassifyDocumentRequest

        if (bytes != null) {
            if (other.bytes == null) return false
            if (!bytes.contentEquals(other.bytes)) return false
        } else if (other.bytes != null) return false
        if (documentReaderConfig != other.documentReaderConfig) return false
        if (endpointArn != other.endpointArn) return false
        if (text != other.text) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.ClassifyDocumentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Use the `Bytes` parameter to input a text, PDF, Word or image file. You can also use the `Bytes` parameter to input an Amazon Textract `DetectDocumentText` or `AnalyzeDocument` output file.
         *
         * Provide the input document as a sequence of base64-encoded bytes. If your code uses an Amazon Web Services SDK to classify documents, the SDK may encode the document file bytes for you.
         *
         * The maximum length of this field depends on the input document type. For details, see [ Inputs for real-time custom analysis](https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync.html) in the Comprehend Developer Guide.
         *
         * If you use the `Bytes` parameter, do not use the `Text` parameter.
         */
        public var bytes: kotlin.ByteArray? = null
        /**
         * Provides configuration parameters to override the default actions for extracting text from PDF documents and image files.
         */
        public var documentReaderConfig: aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig? = null
        /**
         * The Amazon Resource Number (ARN) of the endpoint. For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
         */
        public var endpointArn: kotlin.String? = null
        /**
         * The document text to be analyzed. If you enter text using this parameter, do not use the `Bytes` parameter.
         */
        public var text: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.ClassifyDocumentRequest) : this() {
            this.bytes = x.bytes
            this.documentReaderConfig = x.documentReaderConfig
            this.endpointArn = x.endpointArn
            this.text = x.text
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.ClassifyDocumentRequest = ClassifyDocumentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig] inside the given [block]
         */
        public fun documentReaderConfig(block: aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig.Builder.() -> kotlin.Unit) {
            this.documentReaderConfig = aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig.invoke(block)
        }
    }
}
