// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



/**
 * Information about each word or line of text in the input document.
 *
 * For additional information, see [Block](https://docs.aws.amazon.com/textract/latest/dg/API_Block.html) in the Amazon Textract API reference.
 */
public class Block private constructor(builder: Builder) {
    /**
     * The block represents a line of text or one word of text.
     * + WORD - A word that's detected on a document page. A word is one or more ISO basic Latin script characters that aren't separated by spaces.
     * + LINE - A string of tab-delimited, contiguous words that are detected on a document page
     */
    public val blockType: aws.sdk.kotlin.services.comprehend.model.BlockType? = builder.blockType
    /**
     * Co-ordinates of the rectangle or polygon that contains the text.
     */
    public val geometry: aws.sdk.kotlin.services.comprehend.model.Geometry? = builder.geometry
    /**
     * Unique identifier for the block.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Page number where the block appears.
     */
    public val page: kotlin.Int? = builder.page
    /**
     * A list of child blocks of the current block. For example, a LINE object has child blocks for each WORD block that's part of the line of text.
     */
    public val relationships: List<RelationshipsListItem>? = builder.relationships
    /**
     * The word or line of text extracted from the block.
     */
    public val text: kotlin.String? = builder.text

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.Block = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Block(")
        append("blockType=$blockType,")
        append("geometry=$geometry,")
        append("id=$id,")
        append("page=$page,")
        append("relationships=$relationships,")
        append("text=$text")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockType?.hashCode() ?: 0
        result = 31 * result + (geometry?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (page ?: 0)
        result = 31 * result + (relationships?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Block

        if (blockType != other.blockType) return false
        if (geometry != other.geometry) return false
        if (id != other.id) return false
        if (page != other.page) return false
        if (relationships != other.relationships) return false
        if (text != other.text) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.Block = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The block represents a line of text or one word of text.
         * + WORD - A word that's detected on a document page. A word is one or more ISO basic Latin script characters that aren't separated by spaces.
         * + LINE - A string of tab-delimited, contiguous words that are detected on a document page
         */
        public var blockType: aws.sdk.kotlin.services.comprehend.model.BlockType? = null
        /**
         * Co-ordinates of the rectangle or polygon that contains the text.
         */
        public var geometry: aws.sdk.kotlin.services.comprehend.model.Geometry? = null
        /**
         * Unique identifier for the block.
         */
        public var id: kotlin.String? = null
        /**
         * Page number where the block appears.
         */
        public var page: kotlin.Int? = null
        /**
         * A list of child blocks of the current block. For example, a LINE object has child blocks for each WORD block that's part of the line of text.
         */
        public var relationships: List<RelationshipsListItem>? = null
        /**
         * The word or line of text extracted from the block.
         */
        public var text: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.Block) : this() {
            this.blockType = x.blockType
            this.geometry = x.geometry
            this.id = x.id
            this.page = x.page
            this.relationships = x.relationships
            this.text = x.text
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.Block = Block(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.Geometry] inside the given [block]
         */
        public fun geometry(block: aws.sdk.kotlin.services.comprehend.model.Geometry.Builder.() -> kotlin.Unit) {
            this.geometry = aws.sdk.kotlin.services.comprehend.model.Geometry.invoke(block)
        }
    }
}
