// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.comprehend.auth.AuthSchemeProviderAdapter
import aws.sdk.kotlin.services.comprehend.auth.IdentityProviderConfigAdapter
import aws.sdk.kotlin.services.comprehend.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.comprehend.model.*
import aws.sdk.kotlin.services.comprehend.transform.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Comprehend"
public const val ServiceApiVersion: String = "2017-11-27"
public const val SdkVersion: String = "0.23.0-beta"

internal class DefaultComprehendClient(override val config: ComprehendClient.Config) : ComprehendClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)
    private val identityProviderConfig = IdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(HttpAuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "comprehend")
        }
        toMap()
    }

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon Comprehend can detect, see [Amazon Comprehend Supported Languages](https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
     */
    override suspend fun batchDetectDominantLanguage(input: BatchDetectDominantLanguageRequest): BatchDetectDominantLanguageResponse {
        val op = SdkHttpOperation.build<BatchDetectDominantLanguageRequest, BatchDetectDominantLanguageResponse> {
            serializer = BatchDetectDominantLanguageOperationSerializer()
            deserializer = BatchDetectDominantLanguageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "BatchDetectDominantLanguage"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("BatchDetectDominantLanguage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Inspects the text of a batch of documents for named entities and returns information about them. For more information about named entities, see [Entities](https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html) in the Comprehend Developer Guide.
     */
    override suspend fun batchDetectEntities(input: BatchDetectEntitiesRequest): BatchDetectEntitiesResponse {
        val op = SdkHttpOperation.build<BatchDetectEntitiesRequest, BatchDetectEntitiesResponse> {
            serializer = BatchDetectEntitiesOperationSerializer()
            deserializer = BatchDetectEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "BatchDetectEntities"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("BatchDetectEntities-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Detects the key noun phrases found in a batch of documents.
     */
    override suspend fun batchDetectKeyPhrases(input: BatchDetectKeyPhrasesRequest): BatchDetectKeyPhrasesResponse {
        val op = SdkHttpOperation.build<BatchDetectKeyPhrasesRequest, BatchDetectKeyPhrasesResponse> {
            serializer = BatchDetectKeyPhrasesOperationSerializer()
            deserializer = BatchDetectKeyPhrasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "BatchDetectKeyPhrases"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("BatchDetectKeyPhrases-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Inspects a batch of documents and returns an inference of the prevailing sentiment, `POSITIVE`, `NEUTRAL`, `MIXED`, or `NEGATIVE`, in each one.
     */
    override suspend fun batchDetectSentiment(input: BatchDetectSentimentRequest): BatchDetectSentimentResponse {
        val op = SdkHttpOperation.build<BatchDetectSentimentRequest, BatchDetectSentimentResponse> {
            serializer = BatchDetectSentimentOperationSerializer()
            deserializer = BatchDetectSentimentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "BatchDetectSentiment"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("BatchDetectSentiment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and returns information about them. For more information, see [Syntax](https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html) in the Comprehend Developer Guide.
     */
    override suspend fun batchDetectSyntax(input: BatchDetectSyntaxRequest): BatchDetectSyntaxResponse {
        val op = SdkHttpOperation.build<BatchDetectSyntaxRequest, BatchDetectSyntaxResponse> {
            serializer = BatchDetectSyntaxOperationSerializer()
            deserializer = BatchDetectSyntaxOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "BatchDetectSyntax"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("BatchDetectSyntax-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Inspects a batch of documents and returns a sentiment analysis for each entity identified in the documents.
     *
     * For more information about targeted sentiment, see [Targeted sentiment](https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html).
     */
    override suspend fun batchDetectTargetedSentiment(input: BatchDetectTargetedSentimentRequest): BatchDetectTargetedSentimentResponse {
        val op = SdkHttpOperation.build<BatchDetectTargetedSentimentRequest, BatchDetectTargetedSentimentResponse> {
            serializer = BatchDetectTargetedSentimentOperationSerializer()
            deserializer = BatchDetectTargetedSentimentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "BatchDetectTargetedSentiment"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("BatchDetectTargetedSentiment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new document classification request to analyze a single document in real-time, using a previously created and trained custom model and an endpoint.
     *
     * You can input plain text or you can upload a single-page input document (text, PDF, Word, or image).
     *
     * If the system detects errors while processing a page in the input document, the API response includes an entry in `Errors` that describes the errors.
     *
     * If the system detects a document-level error in your input document, the API returns an `InvalidRequestException` error response. For details about this exception, see [ Errors in semi-structured documents](https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html) in the Comprehend Developer Guide.
     */
    override suspend fun classifyDocument(input: ClassifyDocumentRequest): ClassifyDocumentResponse {
        val op = SdkHttpOperation.build<ClassifyDocumentRequest, ClassifyDocumentResponse> {
            serializer = ClassifyDocumentOperationSerializer()
            deserializer = ClassifyDocumentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ClassifyDocument"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ClassifyDocument-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of identified PII entity types such as name, address, bank account number, or phone number.
     */
    override suspend fun containsPiiEntities(input: ContainsPiiEntitiesRequest): ContainsPiiEntitiesResponse {
        val op = SdkHttpOperation.build<ContainsPiiEntitiesRequest, ContainsPiiEntitiesResponse> {
            serializer = ContainsPiiEntitiesOperationSerializer()
            deserializer = ContainsPiiEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ContainsPiiEntities"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ContainsPiiEntities-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a dataset to upload training or test data for a model associated with a flywheel. For more information about datasets, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    override suspend fun createDataset(input: CreateDatasetRequest): CreateDatasetResponse {
        val op = SdkHttpOperation.build<CreateDatasetRequest, CreateDatasetResponse> {
            serializer = CreateDatasetOperationSerializer()
            deserializer = CreateDatasetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateDataset"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateDataset-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a set of training documents that are labeled with the categories that you want to use. For more information, see [Training classifier models](https://docs.aws.amazon.com/comprehend/latest/dg/training-classifier-model.html) in the Comprehend Developer Guide.
     */
    override suspend fun createDocumentClassifier(input: CreateDocumentClassifierRequest): CreateDocumentClassifierResponse {
        val op = SdkHttpOperation.build<CreateDocumentClassifierRequest, CreateDocumentClassifierResponse> {
            serializer = CreateDocumentClassifierOperationSerializer()
            deserializer = CreateDocumentClassifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateDocumentClassifier"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateDocumentClassifier-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a model-specific endpoint for synchronous inference for a previously trained custom model For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
     */
    override suspend fun createEndpoint(input: CreateEndpointRequest): CreateEndpointResponse {
        val op = SdkHttpOperation.build<CreateEndpointRequest, CreateEndpointResponse> {
            serializer = CreateEndpointOperationSerializer()
            deserializer = CreateEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateEndpoint"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateEndpoint-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an entity recognizer using submitted files. After your `CreateEntityRecognizer` request is submitted, you can check job status using the `DescribeEntityRecognizer` API.
     */
    override suspend fun createEntityRecognizer(input: CreateEntityRecognizerRequest): CreateEntityRecognizerResponse {
        val op = SdkHttpOperation.build<CreateEntityRecognizerRequest, CreateEntityRecognizerResponse> {
            serializer = CreateEntityRecognizerOperationSerializer()
            deserializer = CreateEntityRecognizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateEntityRecognizer"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateEntityRecognizer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * A flywheel is an Amazon Web Services resource that orchestrates the ongoing training of a model for custom classification or custom entity recognition. You can create a flywheel to start with an existing trained model, or Comprehend can create and train a new model.
     *
     * When you create the flywheel, Comprehend creates a data lake in your account. The data lake holds the training data and test data for all versions of the model.
     *
     * To use a flywheel with an existing trained model, you specify the active model version. Comprehend copies the model's training data and test data into the flywheel's data lake.
     *
     * To use the flywheel with a new model, you need to provide a dataset for training data (and optional test data) when you create the flywheel.
     *
     * For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    override suspend fun createFlywheel(input: CreateFlywheelRequest): CreateFlywheelResponse {
        val op = SdkHttpOperation.build<CreateFlywheelRequest, CreateFlywheelResponse> {
            serializer = CreateFlywheelOperationSerializer()
            deserializer = CreateFlywheelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateFlywheel"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateFlywheel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a previously created document classifier
     *
     * Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a `ResourceInUseException` will be returned.
     *
     * This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a background job. Once removed, the classifier disappears from your account and is no longer available for use.
     */
    override suspend fun deleteDocumentClassifier(input: DeleteDocumentClassifierRequest): DeleteDocumentClassifierResponse {
        val op = SdkHttpOperation.build<DeleteDocumentClassifierRequest, DeleteDocumentClassifierResponse> {
            serializer = DeleteDocumentClassifierOperationSerializer()
            deserializer = DeleteDocumentClassifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteDocumentClassifier"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteDocumentClassifier-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order for the model to be deleted. For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
     */
    override suspend fun deleteEndpoint(input: DeleteEndpointRequest): DeleteEndpointResponse {
        val op = SdkHttpOperation.build<DeleteEndpointRequest, DeleteEndpointResponse> {
            serializer = DeleteEndpointOperationSerializer()
            deserializer = DeleteEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteEndpoint"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteEndpoint-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an entity recognizer.
     *
     * Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a `ResourceInUseException` will be returned.
     *
     * This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a background job. Once removed, the recognizer disappears from your account and is no longer available for use.
     */
    override suspend fun deleteEntityRecognizer(input: DeleteEntityRecognizerRequest): DeleteEntityRecognizerResponse {
        val op = SdkHttpOperation.build<DeleteEntityRecognizerRequest, DeleteEntityRecognizerResponse> {
            serializer = DeleteEntityRecognizerOperationSerializer()
            deserializer = DeleteEntityRecognizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteEntityRecognizer"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteEntityRecognizer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a flywheel. When you delete the flywheel, Amazon Comprehend does not delete the data lake or the model associated with the flywheel.
     *
     * For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    override suspend fun deleteFlywheel(input: DeleteFlywheelRequest): DeleteFlywheelResponse {
        val op = SdkHttpOperation.build<DeleteFlywheelRequest, DeleteFlywheelResponse> {
            serializer = DeleteFlywheelOperationSerializer()
            deserializer = DeleteFlywheelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteFlywheel"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteFlywheel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a resource-based policy that is attached to a custom model.
     */
    override suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse {
        val op = SdkHttpOperation.build<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse> {
            serializer = DeleteResourcePolicyOperationSerializer()
            deserializer = DeleteResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteResourcePolicy"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteResourcePolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about the dataset that you specify. For more information about datasets, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    override suspend fun describeDataset(input: DescribeDatasetRequest): DescribeDatasetResponse {
        val op = SdkHttpOperation.build<DescribeDatasetRequest, DescribeDatasetResponse> {
            serializer = DescribeDatasetOperationSerializer()
            deserializer = DescribeDatasetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeDataset"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeDataset-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the properties associated with a document classification job. Use this operation to get the status of a classification job.
     */
    override suspend fun describeDocumentClassificationJob(input: DescribeDocumentClassificationJobRequest): DescribeDocumentClassificationJobResponse {
        val op = SdkHttpOperation.build<DescribeDocumentClassificationJobRequest, DescribeDocumentClassificationJobResponse> {
            serializer = DescribeDocumentClassificationJobOperationSerializer()
            deserializer = DescribeDocumentClassificationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeDocumentClassificationJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeDocumentClassificationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the properties associated with a document classifier.
     */
    override suspend fun describeDocumentClassifier(input: DescribeDocumentClassifierRequest): DescribeDocumentClassifierResponse {
        val op = SdkHttpOperation.build<DescribeDocumentClassifierRequest, DescribeDocumentClassifierResponse> {
            serializer = DescribeDocumentClassifierOperationSerializer()
            deserializer = DescribeDocumentClassifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeDocumentClassifier"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeDocumentClassifier-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the properties associated with a dominant language detection job. Use this operation to get the status of a detection job.
     */
    override suspend fun describeDominantLanguageDetectionJob(input: DescribeDominantLanguageDetectionJobRequest): DescribeDominantLanguageDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribeDominantLanguageDetectionJobRequest, DescribeDominantLanguageDetectionJobResponse> {
            serializer = DescribeDominantLanguageDetectionJobOperationSerializer()
            deserializer = DescribeDominantLanguageDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeDominantLanguageDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeDominantLanguageDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint. For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
     */
    override suspend fun describeEndpoint(input: DescribeEndpointRequest): DescribeEndpointResponse {
        val op = SdkHttpOperation.build<DescribeEndpointRequest, DescribeEndpointResponse> {
            serializer = DescribeEndpointOperationSerializer()
            deserializer = DescribeEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeEndpoint"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeEndpoint-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the properties associated with an entities detection job. Use this operation to get the status of a detection job.
     */
    override suspend fun describeEntitiesDetectionJob(input: DescribeEntitiesDetectionJobRequest): DescribeEntitiesDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribeEntitiesDetectionJobRequest, DescribeEntitiesDetectionJobResponse> {
            serializer = DescribeEntitiesDetectionJobOperationSerializer()
            deserializer = DescribeEntitiesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeEntitiesDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeEntitiesDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer metadata, metrics, and so on.
     */
    override suspend fun describeEntityRecognizer(input: DescribeEntityRecognizerRequest): DescribeEntityRecognizerResponse {
        val op = SdkHttpOperation.build<DescribeEntityRecognizerRequest, DescribeEntityRecognizerResponse> {
            serializer = DescribeEntityRecognizerOperationSerializer()
            deserializer = DescribeEntityRecognizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeEntityRecognizer"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeEntityRecognizer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the status and details of an events detection job.
     */
    override suspend fun describeEventsDetectionJob(input: DescribeEventsDetectionJobRequest): DescribeEventsDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribeEventsDetectionJobRequest, DescribeEventsDetectionJobResponse> {
            serializer = DescribeEventsDetectionJobOperationSerializer()
            deserializer = DescribeEventsDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeEventsDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeEventsDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides configuration information about the flywheel. For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    override suspend fun describeFlywheel(input: DescribeFlywheelRequest): DescribeFlywheelResponse {
        val op = SdkHttpOperation.build<DescribeFlywheelRequest, DescribeFlywheelResponse> {
            serializer = DescribeFlywheelOperationSerializer()
            deserializer = DescribeFlywheelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeFlywheel"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeFlywheel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieve the configuration properties of a flywheel iteration. For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    override suspend fun describeFlywheelIteration(input: DescribeFlywheelIterationRequest): DescribeFlywheelIterationResponse {
        val op = SdkHttpOperation.build<DescribeFlywheelIterationRequest, DescribeFlywheelIterationResponse> {
            serializer = DescribeFlywheelIterationOperationSerializer()
            deserializer = DescribeFlywheelIterationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeFlywheelIteration"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeFlywheelIteration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the properties associated with a key phrases detection job. Use this operation to get the status of a detection job.
     */
    override suspend fun describeKeyPhrasesDetectionJob(input: DescribeKeyPhrasesDetectionJobRequest): DescribeKeyPhrasesDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribeKeyPhrasesDetectionJobRequest, DescribeKeyPhrasesDetectionJobResponse> {
            serializer = DescribeKeyPhrasesDetectionJobOperationSerializer()
            deserializer = DescribeKeyPhrasesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeKeyPhrasesDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeKeyPhrasesDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the properties associated with a PII entities detection job. For example, you can use this operation to get the job status.
     */
    override suspend fun describePiiEntitiesDetectionJob(input: DescribePiiEntitiesDetectionJobRequest): DescribePiiEntitiesDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribePiiEntitiesDetectionJobRequest, DescribePiiEntitiesDetectionJobResponse> {
            serializer = DescribePiiEntitiesDetectionJobOperationSerializer()
            deserializer = DescribePiiEntitiesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribePiiEntitiesDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribePiiEntitiesDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the details of a resource-based policy that is attached to a custom model, including the JSON body of the policy.
     */
    override suspend fun describeResourcePolicy(input: DescribeResourcePolicyRequest): DescribeResourcePolicyResponse {
        val op = SdkHttpOperation.build<DescribeResourcePolicyRequest, DescribeResourcePolicyResponse> {
            serializer = DescribeResourcePolicyOperationSerializer()
            deserializer = DescribeResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeResourcePolicy"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeResourcePolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the properties associated with a sentiment detection job. Use this operation to get the status of a detection job.
     */
    override suspend fun describeSentimentDetectionJob(input: DescribeSentimentDetectionJobRequest): DescribeSentimentDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribeSentimentDetectionJobRequest, DescribeSentimentDetectionJobResponse> {
            serializer = DescribeSentimentDetectionJobOperationSerializer()
            deserializer = DescribeSentimentDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeSentimentDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeSentimentDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the properties associated with a targeted sentiment detection job. Use this operation to get the status of the job.
     */
    override suspend fun describeTargetedSentimentDetectionJob(input: DescribeTargetedSentimentDetectionJobRequest): DescribeTargetedSentimentDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribeTargetedSentimentDetectionJobRequest, DescribeTargetedSentimentDetectionJobResponse> {
            serializer = DescribeTargetedSentimentDetectionJobOperationSerializer()
            deserializer = DescribeTargetedSentimentDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeTargetedSentimentDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeTargetedSentimentDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the properties associated with a topic detection job. Use this operation to get the status of a detection job.
     */
    override suspend fun describeTopicsDetectionJob(input: DescribeTopicsDetectionJobRequest): DescribeTopicsDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribeTopicsDetectionJobRequest, DescribeTopicsDetectionJobResponse> {
            serializer = DescribeTopicsDetectionJobOperationSerializer()
            deserializer = DescribeTopicsDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeTopicsDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeTopicsDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect, see [Amazon Comprehend Supported Languages](https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
     */
    override suspend fun detectDominantLanguage(input: DetectDominantLanguageRequest): DetectDominantLanguageResponse {
        val op = SdkHttpOperation.build<DetectDominantLanguageRequest, DetectDominantLanguageResponse> {
            serializer = DetectDominantLanguageOperationSerializer()
            deserializer = DetectDominantLanguageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DetectDominantLanguage"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DetectDominantLanguage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Detects named entities in input text when you use the pre-trained model. Detects custom entities if you have a custom entity recognition model.
     *
     *  When detecting named entities using the pre-trained model, use plain text as the input. For more information about named entities, see [Entities](https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html) in the Comprehend Developer Guide.
     *
     * When you use a custom entity recognition model, you can input plain text or you can upload a single-page input document (text, PDF, Word, or image).
     *
     * If the system detects errors while processing a page in the input document, the API response includes an entry in `Errors` for each error.
     *
     * If the system detects a document-level error in your input document, the API returns an `InvalidRequestException` error response. For details about this exception, see [ Errors in semi-structured documents](https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html) in the Comprehend Developer Guide.
     */
    override suspend fun detectEntities(input: DetectEntitiesRequest): DetectEntitiesResponse {
        val op = SdkHttpOperation.build<DetectEntitiesRequest, DetectEntitiesResponse> {
            serializer = DetectEntitiesOperationSerializer()
            deserializer = DetectEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DetectEntities"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DetectEntities-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Detects the key noun phrases found in the text.
     */
    override suspend fun detectKeyPhrases(input: DetectKeyPhrasesRequest): DetectKeyPhrasesResponse {
        val op = SdkHttpOperation.build<DetectKeyPhrasesRequest, DetectKeyPhrasesResponse> {
            serializer = DetectKeyPhrasesOperationSerializer()
            deserializer = DetectKeyPhrasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DetectKeyPhrases"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DetectKeyPhrases-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Inspects the input text for entities that contain personally identifiable information (PII) and returns information about them.
     */
    override suspend fun detectPiiEntities(input: DetectPiiEntitiesRequest): DetectPiiEntitiesResponse {
        val op = SdkHttpOperation.build<DetectPiiEntitiesRequest, DetectPiiEntitiesResponse> {
            serializer = DetectPiiEntitiesOperationSerializer()
            deserializer = DetectPiiEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DetectPiiEntities"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DetectPiiEntities-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Inspects text and returns an inference of the prevailing sentiment (`POSITIVE`, `NEUTRAL`, `MIXED`, or `NEGATIVE`).
     */
    override suspend fun detectSentiment(input: DetectSentimentRequest): DetectSentimentResponse {
        val op = SdkHttpOperation.build<DetectSentimentRequest, DetectSentimentResponse> {
            serializer = DetectSentimentOperationSerializer()
            deserializer = DetectSentimentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DetectSentiment"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DetectSentiment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Inspects text for syntax and the part of speech of words in the document. For more information, see [Syntax](https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html) in the Comprehend Developer Guide.
     */
    override suspend fun detectSyntax(input: DetectSyntaxRequest): DetectSyntaxResponse {
        val op = SdkHttpOperation.build<DetectSyntaxRequest, DetectSyntaxResponse> {
            serializer = DetectSyntaxOperationSerializer()
            deserializer = DetectSyntaxOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DetectSyntax"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DetectSyntax-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Inspects the input text and returns a sentiment analysis for each entity identified in the text.
     *
     * For more information about targeted sentiment, see [Targeted sentiment](https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html).
     */
    override suspend fun detectTargetedSentiment(input: DetectTargetedSentimentRequest): DetectTargetedSentimentResponse {
        val op = SdkHttpOperation.build<DetectTargetedSentimentRequest, DetectTargetedSentimentResponse> {
            serializer = DetectTargetedSentimentOperationSerializer()
            deserializer = DetectTargetedSentimentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DetectTargetedSentiment"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DetectTargetedSentiment-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new custom model that replicates a source custom model that you import. The source model can be in your Amazon Web Services account or another one.
     *
     * If the source model is in another Amazon Web Services account, then it must have a resource-based policy that authorizes you to import it.
     *
     * The source model must be in the same Amazon Web Services Region that you're using when you import. You can't import a model that's in a different Region.
     */
    override suspend fun importModel(input: ImportModelRequest): ImportModelResponse {
        val op = SdkHttpOperation.build<ImportModelRequest, ImportModelResponse> {
            serializer = ImportModelOperationSerializer()
            deserializer = ImportModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ImportModel"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ImportModel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the datasets that you have configured in this Region. For more information about datasets, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    override suspend fun listDatasets(input: ListDatasetsRequest): ListDatasetsResponse {
        val op = SdkHttpOperation.build<ListDatasetsRequest, ListDatasetsResponse> {
            serializer = ListDatasetsOperationSerializer()
            deserializer = ListDatasetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListDatasets"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListDatasets-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a list of the documentation classification jobs that you have submitted.
     */
    override suspend fun listDocumentClassificationJobs(input: ListDocumentClassificationJobsRequest): ListDocumentClassificationJobsResponse {
        val op = SdkHttpOperation.build<ListDocumentClassificationJobsRequest, ListDocumentClassificationJobsResponse> {
            serializer = ListDocumentClassificationJobsOperationSerializer()
            deserializer = ListDocumentClassificationJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListDocumentClassificationJobs"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListDocumentClassificationJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a list of summaries of the document classifiers that you have created
     */
    override suspend fun listDocumentClassifierSummaries(input: ListDocumentClassifierSummariesRequest): ListDocumentClassifierSummariesResponse {
        val op = SdkHttpOperation.build<ListDocumentClassifierSummariesRequest, ListDocumentClassifierSummariesResponse> {
            serializer = ListDocumentClassifierSummariesOperationSerializer()
            deserializer = ListDocumentClassifierSummariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListDocumentClassifierSummaries"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListDocumentClassifierSummaries-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a list of the document classifiers that you have created.
     */
    override suspend fun listDocumentClassifiers(input: ListDocumentClassifiersRequest): ListDocumentClassifiersResponse {
        val op = SdkHttpOperation.build<ListDocumentClassifiersRequest, ListDocumentClassifiersResponse> {
            serializer = ListDocumentClassifiersOperationSerializer()
            deserializer = ListDocumentClassifiersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListDocumentClassifiers"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListDocumentClassifiers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a list of the dominant language detection jobs that you have submitted.
     */
    override suspend fun listDominantLanguageDetectionJobs(input: ListDominantLanguageDetectionJobsRequest): ListDominantLanguageDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListDominantLanguageDetectionJobsRequest, ListDominantLanguageDetectionJobsResponse> {
            serializer = ListDominantLanguageDetectionJobsOperationSerializer()
            deserializer = ListDominantLanguageDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListDominantLanguageDetectionJobs"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListDominantLanguageDetectionJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a list of all existing endpoints that you've created. For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
     */
    override suspend fun listEndpoints(input: ListEndpointsRequest): ListEndpointsResponse {
        val op = SdkHttpOperation.build<ListEndpointsRequest, ListEndpointsResponse> {
            serializer = ListEndpointsOperationSerializer()
            deserializer = ListEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListEndpoints"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListEndpoints-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a list of the entity detection jobs that you have submitted.
     */
    override suspend fun listEntitiesDetectionJobs(input: ListEntitiesDetectionJobsRequest): ListEntitiesDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListEntitiesDetectionJobsRequest, ListEntitiesDetectionJobsResponse> {
            serializer = ListEntitiesDetectionJobsOperationSerializer()
            deserializer = ListEntitiesDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListEntitiesDetectionJobs"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListEntitiesDetectionJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a list of summaries for the entity recognizers that you have created.
     */
    override suspend fun listEntityRecognizerSummaries(input: ListEntityRecognizerSummariesRequest): ListEntityRecognizerSummariesResponse {
        val op = SdkHttpOperation.build<ListEntityRecognizerSummariesRequest, ListEntityRecognizerSummariesResponse> {
            serializer = ListEntityRecognizerSummariesOperationSerializer()
            deserializer = ListEntityRecognizerSummariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListEntityRecognizerSummaries"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListEntityRecognizerSummaries-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     *
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     */
    override suspend fun listEntityRecognizers(input: ListEntityRecognizersRequest): ListEntityRecognizersResponse {
        val op = SdkHttpOperation.build<ListEntityRecognizersRequest, ListEntityRecognizersResponse> {
            serializer = ListEntityRecognizersOperationSerializer()
            deserializer = ListEntityRecognizersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListEntityRecognizers"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListEntityRecognizers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a list of the events detection jobs that you have submitted.
     */
    override suspend fun listEventsDetectionJobs(input: ListEventsDetectionJobsRequest): ListEventsDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListEventsDetectionJobsRequest, ListEventsDetectionJobsResponse> {
            serializer = ListEventsDetectionJobsOperationSerializer()
            deserializer = ListEventsDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListEventsDetectionJobs"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListEventsDetectionJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Information about the history of a flywheel iteration. For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    override suspend fun listFlywheelIterationHistory(input: ListFlywheelIterationHistoryRequest): ListFlywheelIterationHistoryResponse {
        val op = SdkHttpOperation.build<ListFlywheelIterationHistoryRequest, ListFlywheelIterationHistoryResponse> {
            serializer = ListFlywheelIterationHistoryOperationSerializer()
            deserializer = ListFlywheelIterationHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListFlywheelIterationHistory"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListFlywheelIterationHistory-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a list of the flywheels that you have created.
     */
    override suspend fun listFlywheels(input: ListFlywheelsRequest): ListFlywheelsResponse {
        val op = SdkHttpOperation.build<ListFlywheelsRequest, ListFlywheelsResponse> {
            serializer = ListFlywheelsOperationSerializer()
            deserializer = ListFlywheelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListFlywheels"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListFlywheels-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get a list of key phrase detection jobs that you have submitted.
     */
    override suspend fun listKeyPhrasesDetectionJobs(input: ListKeyPhrasesDetectionJobsRequest): ListKeyPhrasesDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListKeyPhrasesDetectionJobsRequest, ListKeyPhrasesDetectionJobsResponse> {
            serializer = ListKeyPhrasesDetectionJobsOperationSerializer()
            deserializer = ListKeyPhrasesDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListKeyPhrasesDetectionJobs"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListKeyPhrasesDetectionJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a list of the PII entity detection jobs that you have submitted.
     */
    override suspend fun listPiiEntitiesDetectionJobs(input: ListPiiEntitiesDetectionJobsRequest): ListPiiEntitiesDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListPiiEntitiesDetectionJobsRequest, ListPiiEntitiesDetectionJobsResponse> {
            serializer = ListPiiEntitiesDetectionJobsOperationSerializer()
            deserializer = ListPiiEntitiesDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListPiiEntitiesDetectionJobs"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListPiiEntitiesDetectionJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a list of sentiment detection jobs that you have submitted.
     */
    override suspend fun listSentimentDetectionJobs(input: ListSentimentDetectionJobsRequest): ListSentimentDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListSentimentDetectionJobsRequest, ListSentimentDetectionJobsResponse> {
            serializer = ListSentimentDetectionJobsOperationSerializer()
            deserializer = ListSentimentDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListSentimentDetectionJobs"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListSentimentDetectionJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all tags associated with a given Amazon Comprehend resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListTagsForResource"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a list of targeted sentiment detection jobs that you have submitted.
     */
    override suspend fun listTargetedSentimentDetectionJobs(input: ListTargetedSentimentDetectionJobsRequest): ListTargetedSentimentDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListTargetedSentimentDetectionJobsRequest, ListTargetedSentimentDetectionJobsResponse> {
            serializer = ListTargetedSentimentDetectionJobsOperationSerializer()
            deserializer = ListTargetedSentimentDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListTargetedSentimentDetectionJobs"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTargetedSentimentDetectionJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a list of the topic detection jobs that you have submitted.
     */
    override suspend fun listTopicsDetectionJobs(input: ListTopicsDetectionJobsRequest): ListTopicsDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListTopicsDetectionJobsRequest, ListTopicsDetectionJobsResponse> {
            serializer = ListTopicsDetectionJobsOperationSerializer()
            deserializer = ListTopicsDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListTopicsDetectionJobs"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTopicsDetectionJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Attaches a resource-based policy to a custom model. You can use this policy to authorize an entity in another Amazon Web Services account to import the custom model, which replicates it in Amazon Comprehend in their account.
     */
    override suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse {
        val op = SdkHttpOperation.build<PutResourcePolicyRequest, PutResourcePolicyResponse> {
            serializer = PutResourcePolicyOperationSerializer()
            deserializer = PutResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "PutResourcePolicy"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PutResourcePolicy-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts an asynchronous document classification job. Use the `DescribeDocumentClassificationJob` operation to track the progress of the job.
     */
    override suspend fun startDocumentClassificationJob(input: StartDocumentClassificationJobRequest): StartDocumentClassificationJobResponse {
        val op = SdkHttpOperation.build<StartDocumentClassificationJobRequest, StartDocumentClassificationJobResponse> {
            serializer = StartDocumentClassificationJobOperationSerializer()
            deserializer = StartDocumentClassificationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartDocumentClassificationJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartDocumentClassificationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track the status of a job.
     */
    override suspend fun startDominantLanguageDetectionJob(input: StartDominantLanguageDetectionJobRequest): StartDominantLanguageDetectionJobResponse {
        val op = SdkHttpOperation.build<StartDominantLanguageDetectionJobRequest, StartDominantLanguageDetectionJobResponse> {
            serializer = StartDominantLanguageDetectionJobOperationSerializer()
            deserializer = StartDominantLanguageDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartDominantLanguageDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartDominantLanguageDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status of a job.
     *
     * This API can be used for either standard entity detection or custom entity recognition. In order to be used for custom entity recognition, the optional `EntityRecognizerArn` must be used in order to provide access to the recognizer being used to detect the custom entity.
     */
    override suspend fun startEntitiesDetectionJob(input: StartEntitiesDetectionJobRequest): StartEntitiesDetectionJobResponse {
        val op = SdkHttpOperation.build<StartEntitiesDetectionJobRequest, StartEntitiesDetectionJobResponse> {
            serializer = StartEntitiesDetectionJobOperationSerializer()
            deserializer = StartEntitiesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartEntitiesDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartEntitiesDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts an asynchronous event detection job for a collection of documents.
     */
    override suspend fun startEventsDetectionJob(input: StartEventsDetectionJobRequest): StartEventsDetectionJobResponse {
        val op = SdkHttpOperation.build<StartEventsDetectionJobRequest, StartEventsDetectionJobResponse> {
            serializer = StartEventsDetectionJobOperationSerializer()
            deserializer = StartEventsDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartEventsDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartEventsDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Start the flywheel iteration.This operation uses any new datasets to train a new model version. For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    override suspend fun startFlywheelIteration(input: StartFlywheelIterationRequest): StartFlywheelIterationResponse {
        val op = SdkHttpOperation.build<StartFlywheelIterationRequest, StartFlywheelIterationResponse> {
            serializer = StartFlywheelIterationOperationSerializer()
            deserializer = StartFlywheelIterationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartFlywheelIteration"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartFlywheelIteration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the status of a job.
     */
    override suspend fun startKeyPhrasesDetectionJob(input: StartKeyPhrasesDetectionJobRequest): StartKeyPhrasesDetectionJobResponse {
        val op = SdkHttpOperation.build<StartKeyPhrasesDetectionJobRequest, StartKeyPhrasesDetectionJobResponse> {
            serializer = StartKeyPhrasesDetectionJobOperationSerializer()
            deserializer = StartKeyPhrasesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartKeyPhrasesDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartKeyPhrasesDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts an asynchronous PII entity detection job for a collection of documents.
     */
    override suspend fun startPiiEntitiesDetectionJob(input: StartPiiEntitiesDetectionJobRequest): StartPiiEntitiesDetectionJobResponse {
        val op = SdkHttpOperation.build<StartPiiEntitiesDetectionJobRequest, StartPiiEntitiesDetectionJobResponse> {
            serializer = StartPiiEntitiesDetectionJobOperationSerializer()
            deserializer = StartPiiEntitiesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartPiiEntitiesDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartPiiEntitiesDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts an asynchronous sentiment detection job for a collection of documents. Use the operation to track the status of a job.
     */
    override suspend fun startSentimentDetectionJob(input: StartSentimentDetectionJobRequest): StartSentimentDetectionJobResponse {
        val op = SdkHttpOperation.build<StartSentimentDetectionJobRequest, StartSentimentDetectionJobResponse> {
            serializer = StartSentimentDetectionJobOperationSerializer()
            deserializer = StartSentimentDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartSentimentDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartSentimentDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts an asynchronous targeted sentiment detection job for a collection of documents. Use the `DescribeTargetedSentimentDetectionJob` operation to track the status of a job.
     */
    override suspend fun startTargetedSentimentDetectionJob(input: StartTargetedSentimentDetectionJobRequest): StartTargetedSentimentDetectionJobResponse {
        val op = SdkHttpOperation.build<StartTargetedSentimentDetectionJobRequest, StartTargetedSentimentDetectionJobResponse> {
            serializer = StartTargetedSentimentDetectionJobOperationSerializer()
            deserializer = StartTargetedSentimentDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartTargetedSentimentDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartTargetedSentimentDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts an asynchronous topic detection job. Use the `DescribeTopicDetectionJob` operation to track the status of a job.
     */
    override suspend fun startTopicsDetectionJob(input: StartTopicsDetectionJobRequest): StartTopicsDetectionJobResponse {
        val op = SdkHttpOperation.build<StartTopicsDetectionJobRequest, StartTopicsDetectionJobResponse> {
            serializer = StartTopicsDetectionJobOperationSerializer()
            deserializer = StartTopicsDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartTopicsDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartTopicsDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops a dominant language detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    override suspend fun stopDominantLanguageDetectionJob(input: StopDominantLanguageDetectionJobRequest): StopDominantLanguageDetectionJobResponse {
        val op = SdkHttpOperation.build<StopDominantLanguageDetectionJobRequest, StopDominantLanguageDetectionJobResponse> {
            serializer = StopDominantLanguageDetectionJobOperationSerializer()
            deserializer = StopDominantLanguageDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopDominantLanguageDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopDominantLanguageDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops an entities detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    override suspend fun stopEntitiesDetectionJob(input: StopEntitiesDetectionJobRequest): StopEntitiesDetectionJobResponse {
        val op = SdkHttpOperation.build<StopEntitiesDetectionJobRequest, StopEntitiesDetectionJobResponse> {
            serializer = StopEntitiesDetectionJobOperationSerializer()
            deserializer = StopEntitiesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopEntitiesDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopEntitiesDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops an events detection job in progress.
     */
    override suspend fun stopEventsDetectionJob(input: StopEventsDetectionJobRequest): StopEventsDetectionJobResponse {
        val op = SdkHttpOperation.build<StopEventsDetectionJobRequest, StopEventsDetectionJobResponse> {
            serializer = StopEventsDetectionJobOperationSerializer()
            deserializer = StopEventsDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopEventsDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopEventsDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops a key phrases detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    override suspend fun stopKeyPhrasesDetectionJob(input: StopKeyPhrasesDetectionJobRequest): StopKeyPhrasesDetectionJobResponse {
        val op = SdkHttpOperation.build<StopKeyPhrasesDetectionJobRequest, StopKeyPhrasesDetectionJobResponse> {
            serializer = StopKeyPhrasesDetectionJobOperationSerializer()
            deserializer = StopKeyPhrasesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopKeyPhrasesDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopKeyPhrasesDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops a PII entities detection job in progress.
     */
    override suspend fun stopPiiEntitiesDetectionJob(input: StopPiiEntitiesDetectionJobRequest): StopPiiEntitiesDetectionJobResponse {
        val op = SdkHttpOperation.build<StopPiiEntitiesDetectionJobRequest, StopPiiEntitiesDetectionJobResponse> {
            serializer = StopPiiEntitiesDetectionJobOperationSerializer()
            deserializer = StopPiiEntitiesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopPiiEntitiesDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopPiiEntitiesDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops a sentiment detection job in progress.
     *
     * If the job state is `IN_PROGRESS`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is be stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    override suspend fun stopSentimentDetectionJob(input: StopSentimentDetectionJobRequest): StopSentimentDetectionJobResponse {
        val op = SdkHttpOperation.build<StopSentimentDetectionJobRequest, StopSentimentDetectionJobResponse> {
            serializer = StopSentimentDetectionJobOperationSerializer()
            deserializer = StopSentimentDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopSentimentDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopSentimentDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops a targeted sentiment detection job in progress.
     *
     * If the job state is `IN_PROGRESS`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is be stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    override suspend fun stopTargetedSentimentDetectionJob(input: StopTargetedSentimentDetectionJobRequest): StopTargetedSentimentDetectionJobResponse {
        val op = SdkHttpOperation.build<StopTargetedSentimentDetectionJobRequest, StopTargetedSentimentDetectionJobResponse> {
            serializer = StopTargetedSentimentDetectionJobOperationSerializer()
            deserializer = StopTargetedSentimentDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopTargetedSentimentDetectionJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopTargetedSentimentDetectionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops a document classifier training job while in progress.
     *
     * If the training job state is `TRAINING`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the training job completes before it can be stopped, it is put into the `TRAINED`; otherwise the training job is stopped and put into the `STOPPED` state and the service sends back an HTTP 200 response with an empty HTTP body.
     */
    override suspend fun stopTrainingDocumentClassifier(input: StopTrainingDocumentClassifierRequest): StopTrainingDocumentClassifierResponse {
        val op = SdkHttpOperation.build<StopTrainingDocumentClassifierRequest, StopTrainingDocumentClassifierResponse> {
            serializer = StopTrainingDocumentClassifierOperationSerializer()
            deserializer = StopTrainingDocumentClassifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopTrainingDocumentClassifier"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopTrainingDocumentClassifier-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops an entity recognizer training job while in progress.
     *
     * If the training job state is `TRAINING`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the training job completes before it can be stopped, it is put into the `TRAINED`; otherwise the training job is stopped and putted into the `STOPPED` state and the service sends back an HTTP 200 response with an empty HTTP body.
     */
    override suspend fun stopTrainingEntityRecognizer(input: StopTrainingEntityRecognizerRequest): StopTrainingEntityRecognizerResponse {
        val op = SdkHttpOperation.build<StopTrainingEntityRecognizerRequest, StopTrainingEntityRecognizerResponse> {
            serializer = StopTrainingEntityRecognizerOperationSerializer()
            deserializer = StopTrainingEntityRecognizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopTrainingEntityRecognizer"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopTrainingEntityRecognizer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "TagResource"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes a specific tag associated with an Amazon Comprehend resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UntagResource"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates information about the specified endpoint. For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
     */
    override suspend fun updateEndpoint(input: UpdateEndpointRequest): UpdateEndpointResponse {
        val op = SdkHttpOperation.build<UpdateEndpointRequest, UpdateEndpointResponse> {
            serializer = UpdateEndpointOperationSerializer()
            deserializer = UpdateEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateEndpoint"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateEndpoint-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update the configuration information for an existing flywheel.
     */
    override suspend fun updateFlywheel(input: UpdateFlywheelRequest): UpdateFlywheelResponse {
        val op = SdkHttpOperation.build<UpdateFlywheelRequest, UpdateFlywheelResponse> {
            serializer = UpdateFlywheelOperationSerializer()
            deserializer = UpdateFlywheelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateFlywheel"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateFlywheel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "comprehend")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
