// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



/**
 * Detailed information about the accuracy of an entity recognizer for a specific entity type.
 */
public class EntityTypesEvaluationMetrics private constructor(builder: Builder) {
    /**
     * A measure of how accurate the recognizer results are for a specific entity type in the test data. It is derived from the `Precision` and `Recall` values. The `F1Score` is the harmonic average of the two scores. The highest score is 1, and the worst score is 0.
     */
    public val f1Score: kotlin.Double? = builder.f1Score
    /**
     * A measure of the usefulness of the recognizer results for a specific entity type in the test data. High precision means that the recognizer returned substantially more relevant results than irrelevant ones.
     */
    public val precision: kotlin.Double? = builder.precision
    /**
     * A measure of how complete the recognizer results are for a specific entity type in the test data. High recall means that the recognizer returned most of the relevant results.
     */
    public val recall: kotlin.Double? = builder.recall

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.EntityTypesEvaluationMetrics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EntityTypesEvaluationMetrics(")
        append("f1Score=$f1Score,")
        append("precision=$precision,")
        append("recall=$recall)")
    }

    override fun hashCode(): kotlin.Int {
        var result = f1Score?.hashCode() ?: 0
        result = 31 * result + (precision?.hashCode() ?: 0)
        result = 31 * result + (recall?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EntityTypesEvaluationMetrics

        if (f1Score != other.f1Score) return false
        if (precision != other.precision) return false
        if (recall != other.recall) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.EntityTypesEvaluationMetrics = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A measure of how accurate the recognizer results are for a specific entity type in the test data. It is derived from the `Precision` and `Recall` values. The `F1Score` is the harmonic average of the two scores. The highest score is 1, and the worst score is 0.
         */
        public var f1Score: kotlin.Double? = null
        /**
         * A measure of the usefulness of the recognizer results for a specific entity type in the test data. High precision means that the recognizer returned substantially more relevant results than irrelevant ones.
         */
        public var precision: kotlin.Double? = null
        /**
         * A measure of how complete the recognizer results are for a specific entity type in the test data. High recall means that the recognizer returned most of the relevant results.
         */
        public var recall: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.EntityTypesEvaluationMetrics) : this() {
            this.f1Score = x.f1Score
            this.precision = x.precision
            this.recall = x.recall
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.EntityTypesEvaluationMetrics = EntityTypesEvaluationMetrics(this)
    }
}
