// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



/**
 * The input properties for training a document classifier.
 *
 * For more information on how the input file is formatted, see [Preparing training data](https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html) in the Comprehend Developer Guide.
 */
public class DocumentClassifierInputDataConfig private constructor(builder: Builder) {
    /**
     * A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
     *
     * This parameter is required if you set `DataFormat` to `AUGMENTED_MANIFEST`.
     */
    public val augmentedManifests: List<AugmentedManifestsListItem>? = builder.augmentedManifests
    /**
     * The format of your training data:
     * + `COMPREHEND_CSV`: A two-column CSV file, where labels are provided in the first column, and documents are provided in the second. If you use this value, you must provide the `S3Uri` parameter in your request.
     * + `AUGMENTED_MANIFEST`: A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its associated labels. If you use this value, you must provide the `AugmentedManifests` parameter in your request.
     *
     * If you don't specify a value, Amazon Comprehend uses `COMPREHEND_CSV` as the default.
     */
    public val dataFormat: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDataFormat? = builder.dataFormat
    /**
     * Indicates the delimiter used to separate each label for training a multi-label classifier. The default delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the delimiter you specify, the labels on that line will be combined to make a single unique label, such as LABELLABELLABEL.
     */
    public val labelDelimiter: kotlin.String? = builder.labelDelimiter
    /**
     * The Amazon S3 URI for the input data. The S3 bucket must be in the same region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.
     *
     * For example, if you use the URI `S3://bucketName/prefix`, if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.
     *
     * This parameter is required if you set `DataFormat` to `COMPREHEND_CSV`.
     */
    public val s3Uri: kotlin.String? = builder.s3Uri
    /**
     * This specifies the Amazon S3 location where the test annotations for an entity recognizer are located. The URI must be in the same AWS Region as the API endpoint that you are calling.
     */
    public val testS3Uri: kotlin.String? = builder.testS3Uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentClassifierInputDataConfig(")
        append("augmentedManifests=$augmentedManifests,")
        append("dataFormat=$dataFormat,")
        append("labelDelimiter=$labelDelimiter,")
        append("s3Uri=$s3Uri,")
        append("testS3Uri=$testS3Uri)")
    }

    override fun hashCode(): kotlin.Int {
        var result = augmentedManifests?.hashCode() ?: 0
        result = 31 * result + (dataFormat?.hashCode() ?: 0)
        result = 31 * result + (labelDelimiter?.hashCode() ?: 0)
        result = 31 * result + (s3Uri?.hashCode() ?: 0)
        result = 31 * result + (testS3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentClassifierInputDataConfig

        if (augmentedManifests != other.augmentedManifests) return false
        if (dataFormat != other.dataFormat) return false
        if (labelDelimiter != other.labelDelimiter) return false
        if (s3Uri != other.s3Uri) return false
        if (testS3Uri != other.testS3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
         *
         * This parameter is required if you set `DataFormat` to `AUGMENTED_MANIFEST`.
         */
        public var augmentedManifests: List<AugmentedManifestsListItem>? = null
        /**
         * The format of your training data:
         * + `COMPREHEND_CSV`: A two-column CSV file, where labels are provided in the first column, and documents are provided in the second. If you use this value, you must provide the `S3Uri` parameter in your request.
         * + `AUGMENTED_MANIFEST`: A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its associated labels. If you use this value, you must provide the `AugmentedManifests` parameter in your request.
         *
         * If you don't specify a value, Amazon Comprehend uses `COMPREHEND_CSV` as the default.
         */
        public var dataFormat: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDataFormat? = null
        /**
         * Indicates the delimiter used to separate each label for training a multi-label classifier. The default delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the delimiter you specify, the labels on that line will be combined to make a single unique label, such as LABELLABELLABEL.
         */
        public var labelDelimiter: kotlin.String? = null
        /**
         * The Amazon S3 URI for the input data. The S3 bucket must be in the same region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.
         *
         * For example, if you use the URI `S3://bucketName/prefix`, if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.
         *
         * This parameter is required if you set `DataFormat` to `COMPREHEND_CSV`.
         */
        public var s3Uri: kotlin.String? = null
        /**
         * This specifies the Amazon S3 location where the test annotations for an entity recognizer are located. The URI must be in the same AWS Region as the API endpoint that you are calling.
         */
        public var testS3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig) : this() {
            this.augmentedManifests = x.augmentedManifests
            this.dataFormat = x.dataFormat
            this.labelDelimiter = x.labelDelimiter
            this.s3Uri = x.s3Uri
            this.testS3Uri = x.testS3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig = DocumentClassifierInputDataConfig(this)
    }
}
