// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



public class DetectEntitiesRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an endpoint if you want to detect entities by using your own custom model instead of the default model that is used by Amazon Comprehend.
     *
     * If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you provide in your request.
     *
     * For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
     */
    public val endpointArn: kotlin.String? = builder.endpointArn
    /**
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.
     *
     * If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you specify here.
     */
    public val languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = builder.languageCode
    /**
     * A UTF-8 text string. The maximum string size is 100 KB.
     */
    public val text: kotlin.String? = builder.text

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.DetectEntitiesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DetectEntitiesRequest(")
        append("endpointArn=$endpointArn,")
        append("languageCode=$languageCode,")
        append("text=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpointArn?.hashCode() ?: 0
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DetectEntitiesRequest

        if (endpointArn != other.endpointArn) return false
        if (languageCode != other.languageCode) return false
        if (text != other.text) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.DetectEntitiesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an endpoint if you want to detect entities by using your own custom model instead of the default model that is used by Amazon Comprehend.
         *
         * If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you provide in your request.
         *
         * For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
         */
        public var endpointArn: kotlin.String? = null
        /**
         * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. All documents must be in the same language.
         *
         * If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you specify here.
         */
        public var languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = null
        /**
         * A UTF-8 text string. The maximum string size is 100 KB.
         */
        public var text: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.DetectEntitiesRequest) : this() {
            this.endpointArn = x.endpointArn
            this.languageCode = x.languageCode
            this.text = x.text
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.DetectEntitiesRequest = DetectEntitiesRequest(this)
    }
}
