// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.serde

import aws.sdk.kotlin.services.comprehend.model.ComprehendException
import aws.sdk.kotlin.services.comprehend.model.DetectSentimentResponse
import aws.sdk.kotlin.services.comprehend.model.SentimentScore
import aws.sdk.kotlin.services.comprehend.model.SentimentType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DetectSentimentOperationDeserializer: HttpDeserializer.NonStreaming<DetectSentimentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DetectSentimentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDetectSentimentError(context, call, payload)
        }
        val builder = DetectSentimentResponse.Builder()

        if (payload != null) {
            deserializeDetectSentimentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDetectSentimentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ComprehendException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TextSizeLimitExceededException" -> TextSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedLanguageException" -> UnsupportedLanguageExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ComprehendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDetectSentimentOperationBody(builder: DetectSentimentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SENTIMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Sentiment"))
    val SENTIMENTSCORE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SentimentScore"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SENTIMENT_DESCRIPTOR)
        field(SENTIMENTSCORE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SENTIMENT_DESCRIPTOR.index -> builder.sentiment = deserializeString().let { SentimentType.fromValue(it) }
                SENTIMENTSCORE_DESCRIPTOR.index -> builder.sentimentScore = deserializeSentimentScoreDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
