// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.serde

import aws.sdk.kotlin.services.comprehend.model.ComprehendException
import aws.sdk.kotlin.services.comprehend.model.DetectDominantLanguageResponse
import aws.sdk.kotlin.services.comprehend.model.DominantLanguage
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DetectDominantLanguageOperationDeserializer: HttpDeserializer.NonStreaming<DetectDominantLanguageResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DetectDominantLanguageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDetectDominantLanguageError(context, call, payload)
        }
        val builder = DetectDominantLanguageResponse.Builder()

        if (payload != null) {
            deserializeDetectDominantLanguageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDetectDominantLanguageError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ComprehendException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TextSizeLimitExceededException" -> TextSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ComprehendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDetectDominantLanguageOperationBody(builder: DetectDominantLanguageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LANGUAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Languages"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LANGUAGES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LANGUAGES_DESCRIPTOR.index -> builder.languages =
                    deserializer.deserializeList(LANGUAGES_DESCRIPTOR) {
                        val col0 = mutableListOf<DominantLanguage>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDominantLanguageDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
