// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartEntitiesDetectionJobResponse private constructor(builder: Builder) {
    /**
     * The ARN of the custom entity recognition model.
     */
    public val entityRecognizerArn: kotlin.String? = builder.entityRecognizerArn
    /**
     * The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:
     *
     * `arn:<partition>:comprehend:<region>:<account-id>:entities-detection-job/<job-id>`
     *
     * The following is an example job ARN:
     *
     * `arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab`
     */
    public val jobArn: kotlin.String? = builder.jobArn
    /**
     * The identifier generated for the job. To get the status of job, use this identifier with the operation.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The status of the job.
     * + SUBMITTED - The job has been received and is queued for processing.
     * + IN_PROGRESS - Amazon Comprehend is processing the job.
     * + COMPLETED - The job was successfully completed and the output is available.
     * + FAILED - The job did not complete. To get details, use the operation.
     * + STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     * + STOPPED - The job was successfully stopped without completing.
     */
    public val jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = builder.jobStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.StartEntitiesDetectionJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartEntitiesDetectionJobResponse(")
        append("entityRecognizerArn=$entityRecognizerArn,")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("jobStatus=$jobStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = entityRecognizerArn?.hashCode() ?: 0
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartEntitiesDetectionJobResponse

        if (entityRecognizerArn != other.entityRecognizerArn) return false
        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (jobStatus != other.jobStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.StartEntitiesDetectionJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the custom entity recognition model.
         */
        public var entityRecognizerArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:
         *
         * `arn:<partition>:comprehend:<region>:<account-id>:entities-detection-job/<job-id>`
         *
         * The following is an example job ARN:
         *
         * `arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab`
         */
        public var jobArn: kotlin.String? = null
        /**
         * The identifier generated for the job. To get the status of job, use this identifier with the operation.
         */
        public var jobId: kotlin.String? = null
        /**
         * The status of the job.
         * + SUBMITTED - The job has been received and is queued for processing.
         * + IN_PROGRESS - Amazon Comprehend is processing the job.
         * + COMPLETED - The job was successfully completed and the output is available.
         * + FAILED - The job did not complete. To get details, use the operation.
         * + STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
         * + STOPPED - The job was successfully stopped without completing.
         */
        public var jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.StartEntitiesDetectionJobResponse) : this() {
            this.entityRecognizerArn = x.entityRecognizerArn
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.jobStatus = x.jobStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.StartEntitiesDetectionJobResponse = StartEntitiesDetectionJobResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
