// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about an events detection job.
 */
public class EventsDetectionJobProperties private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
     */
    public val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * The time that the events detection job completed.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The input data configuration that you supplied when you created the events detection job.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.comprehend.model.InputDataConfig? = builder.inputDataConfig
    /**
     * The Amazon Resource Name (ARN) of the events detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:
     *
     * `arn:<partition>:comprehend:<region>:<account-id>:events-detection-job/<job-id>`
     *
     * The following is an example job ARN:
     *
     * `arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab`
     */
    public val jobArn: kotlin.String? = builder.jobArn
    /**
     * The identifier assigned to the events detection job.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The name you assigned the events detection job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The current status of the events detection job.
     */
    public val jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = builder.jobStatus
    /**
     * The language code of the input documents.
     */
    public val languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = builder.languageCode
    /**
     * A description of the status of the events detection job.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The output data configuration that you supplied when you created the events detection job.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig? = builder.outputDataConfig
    /**
     * The time that the events detection job was submitted for processing.
     */
    public val submitTime: aws.smithy.kotlin.runtime.time.Instant? = builder.submitTime
    /**
     * The types of events that are detected by the job.
     */
    public val targetEventTypes: List<String>? = builder.targetEventTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.EventsDetectionJobProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventsDetectionJobProperties(")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("endTime=$endTime,")
        append("inputDataConfig=$inputDataConfig,")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("jobName=$jobName,")
        append("jobStatus=$jobStatus,")
        append("languageCode=$languageCode,")
        append("message=$message,")
        append("outputDataConfig=$outputDataConfig,")
        append("submitTime=$submitTime,")
        append("targetEventTypes=$targetEventTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataAccessRoleArn?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (submitTime?.hashCode() ?: 0)
        result = 31 * result + (targetEventTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventsDetectionJobProperties

        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (endTime != other.endTime) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (jobName != other.jobName) return false
        if (jobStatus != other.jobStatus) return false
        if (languageCode != other.languageCode) return false
        if (message != other.message) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (submitTime != other.submitTime) return false
        if (targetEventTypes != other.targetEventTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.EventsDetectionJobProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * The time that the events detection job completed.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The input data configuration that you supplied when you created the events detection job.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.comprehend.model.InputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the events detection job. It is a unique, fully qualified identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the ARN is as follows:
         *
         * `arn:<partition>:comprehend:<region>:<account-id>:events-detection-job/<job-id>`
         *
         * The following is an example job ARN:
         *
         * `arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab`
         */
        public var jobArn: kotlin.String? = null
        /**
         * The identifier assigned to the events detection job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The name you assigned the events detection job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The current status of the events detection job.
         */
        public var jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = null
        /**
         * The language code of the input documents.
         */
        public var languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = null
        /**
         * A description of the status of the events detection job.
         */
        public var message: kotlin.String? = null
        /**
         * The output data configuration that you supplied when you created the events detection job.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig? = null
        /**
         * The time that the events detection job was submitted for processing.
         */
        public var submitTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The types of events that are detected by the job.
         */
        public var targetEventTypes: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.EventsDetectionJobProperties) : this() {
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.endTime = x.endTime
            this.inputDataConfig = x.inputDataConfig
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.jobName = x.jobName
            this.jobStatus = x.jobStatus
            this.languageCode = x.languageCode
            this.message = x.message
            this.outputDataConfig = x.outputDataConfig
            this.submitTime = x.submitTime
            this.targetEventTypes = x.targetEventTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.EventsDetectionJobProperties = EventsDetectionJobProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.InputDataConfig] inside the given [block]
         */
        public fun inputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.InputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.comprehend.model.InputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.OutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.comprehend.model.OutputDataConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
