// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Text extraction encountered one or more page-level errors in the input document.
 *
 * The `ErrorCode` contains one of the following values:
 * + TEXTRACT_BAD_PAGE - Amazon Textract cannot read the page. For more information about page limits in Amazon Textract, see [ Page Quotas in Amazon Textract](https://docs.aws.amazon.com/textract/latest/dg/limits-document.html).
 * + TEXTRACT_PROVISIONED_THROUGHPUT_EXCEEDED - The number of requests exceeded your throughput limit. For more information about throughput quotas in Amazon Textract, see [ Default quotas in Amazon Textract](https://docs.aws.amazon.com/textract/latest/dg/limits-quotas-explained.html).
 * + PAGE_CHARACTERS_EXCEEDED - Too many text characters on the page (10,000 characters maximum).
 * + PAGE_SIZE_EXCEEDED - The maximum page size is 10 MB.
 * + INTERNAL_SERVER_ERROR - The request encountered a service issue. Try the API request again.
 */
public class ErrorsListItem private constructor(builder: Builder) {
    /**
     * Error code for the cause of the error.
     */
    public val errorCode: aws.sdk.kotlin.services.comprehend.model.PageBasedErrorCode? = builder.errorCode
    /**
     * Text message explaining the reason for the error.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * Page number where the error occurred.
     */
    public val page: kotlin.Int? = builder.page

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.ErrorsListItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ErrorsListItem(")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("page=$page")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (page ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ErrorsListItem

        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (page != other.page) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.ErrorsListItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Error code for the cause of the error.
         */
        public var errorCode: aws.sdk.kotlin.services.comprehend.model.PageBasedErrorCode? = null
        /**
         * Text message explaining the reason for the error.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * Page number where the error occurred.
         */
        public var page: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.ErrorsListItem) : this() {
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.page = x.page
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.ErrorsListItem = ErrorsListItem(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
