// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Detailed information about the accuracy of an entity recognizer.
 */
public class EntityRecognizerEvaluationMetrics private constructor(builder: Builder) {
    /**
     * A measure of how accurate the recognizer results are for the test data. It is derived from the `Precision` and `Recall` values. The `F1Score` is the harmonic average of the two scores. For plain text entity recognizer models, the range is 0 to 100, where 100 is the best score. For PDF/Word entity recognizer models, the range is 0 to 1, where 1 is the best score.
     */
    public val f1Score: kotlin.Double? = builder.f1Score
    /**
     * A measure of the usefulness of the recognizer results in the test data. High precision means that the recognizer returned substantially more relevant results than irrelevant ones.
     */
    public val precision: kotlin.Double? = builder.precision
    /**
     * A measure of how complete the recognizer results are for the test data. High recall means that the recognizer returned most of the relevant results.
     */
    public val recall: kotlin.Double? = builder.recall

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.EntityRecognizerEvaluationMetrics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EntityRecognizerEvaluationMetrics(")
        append("f1Score=$f1Score,")
        append("precision=$precision,")
        append("recall=$recall")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = f1Score?.hashCode() ?: 0
        result = 31 * result + (precision?.hashCode() ?: 0)
        result = 31 * result + (recall?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EntityRecognizerEvaluationMetrics

        if (!(f1Score?.equals(other.f1Score) ?: (other.f1Score == null))) return false
        if (!(precision?.equals(other.precision) ?: (other.precision == null))) return false
        if (!(recall?.equals(other.recall) ?: (other.recall == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.EntityRecognizerEvaluationMetrics = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A measure of how accurate the recognizer results are for the test data. It is derived from the `Precision` and `Recall` values. The `F1Score` is the harmonic average of the two scores. For plain text entity recognizer models, the range is 0 to 100, where 100 is the best score. For PDF/Word entity recognizer models, the range is 0 to 1, where 1 is the best score.
         */
        public var f1Score: kotlin.Double? = null
        /**
         * A measure of the usefulness of the recognizer results in the test data. High precision means that the recognizer returned substantially more relevant results than irrelevant ones.
         */
        public var precision: kotlin.Double? = null
        /**
         * A measure of how complete the recognizer results are for the test data. High recall means that the recognizer returned most of the relevant results.
         */
        public var recall: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerEvaluationMetrics) : this() {
            this.f1Score = x.f1Score
            this.precision = x.precision
            this.recall = x.recall
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.EntityRecognizerEvaluationMetrics = EntityRecognizerEvaluationMetrics(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
