// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.paginators

import aws.sdk.kotlin.services.comprehend.ComprehendClient
import aws.sdk.kotlin.services.comprehend.model.EndpointProperties
import aws.sdk.kotlin.services.comprehend.model.ListDatasetsRequest
import aws.sdk.kotlin.services.comprehend.model.ListDatasetsResponse
import aws.sdk.kotlin.services.comprehend.model.ListDocumentClassificationJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListDocumentClassificationJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListDocumentClassifierSummariesRequest
import aws.sdk.kotlin.services.comprehend.model.ListDocumentClassifierSummariesResponse
import aws.sdk.kotlin.services.comprehend.model.ListDocumentClassifiersRequest
import aws.sdk.kotlin.services.comprehend.model.ListDocumentClassifiersResponse
import aws.sdk.kotlin.services.comprehend.model.ListDominantLanguageDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListDominantLanguageDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListEndpointsRequest
import aws.sdk.kotlin.services.comprehend.model.ListEndpointsResponse
import aws.sdk.kotlin.services.comprehend.model.ListEntitiesDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListEntitiesDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListEntityRecognizerSummariesRequest
import aws.sdk.kotlin.services.comprehend.model.ListEntityRecognizerSummariesResponse
import aws.sdk.kotlin.services.comprehend.model.ListEntityRecognizersRequest
import aws.sdk.kotlin.services.comprehend.model.ListEntityRecognizersResponse
import aws.sdk.kotlin.services.comprehend.model.ListEventsDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListEventsDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListFlywheelIterationHistoryRequest
import aws.sdk.kotlin.services.comprehend.model.ListFlywheelIterationHistoryResponse
import aws.sdk.kotlin.services.comprehend.model.ListFlywheelsRequest
import aws.sdk.kotlin.services.comprehend.model.ListFlywheelsResponse
import aws.sdk.kotlin.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListSentimentDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListSentimentDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListTargetedSentimentDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListTargetedSentimentDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListTopicsDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListTopicsDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.PiiEntitiesDetectionJobProperties
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListDatasetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetsResponse]
 */
public fun ComprehendClient.listDatasetsPaginated(initialRequest: ListDatasetsRequest = ListDatasetsRequest { }): Flow<ListDatasetsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetsPaginated.listDatasets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetsResponse]
 */
public fun ComprehendClient.listDatasetsPaginated(block: ListDatasetsRequest.Builder.() -> Unit): Flow<ListDatasetsResponse> =
    listDatasetsPaginated(ListDatasetsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDocumentClassificationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDocumentClassificationJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDocumentClassificationJobsResponse]
 */
public fun ComprehendClient.listDocumentClassificationJobsPaginated(initialRequest: ListDocumentClassificationJobsRequest = ListDocumentClassificationJobsRequest { }): Flow<ListDocumentClassificationJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDocumentClassificationJobsPaginated.listDocumentClassificationJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDocumentClassificationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDocumentClassificationJobsResponse]
 */
public fun ComprehendClient.listDocumentClassificationJobsPaginated(block: ListDocumentClassificationJobsRequest.Builder.() -> Unit): Flow<ListDocumentClassificationJobsResponse> =
    listDocumentClassificationJobsPaginated(ListDocumentClassificationJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDocumentClassifiersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDocumentClassifiersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDocumentClassifiersResponse]
 */
public fun ComprehendClient.listDocumentClassifiersPaginated(initialRequest: ListDocumentClassifiersRequest = ListDocumentClassifiersRequest { }): Flow<ListDocumentClassifiersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDocumentClassifiersPaginated.listDocumentClassifiers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDocumentClassifiersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDocumentClassifiersResponse]
 */
public fun ComprehendClient.listDocumentClassifiersPaginated(block: ListDocumentClassifiersRequest.Builder.() -> Unit): Flow<ListDocumentClassifiersResponse> =
    listDocumentClassifiersPaginated(ListDocumentClassifiersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDocumentClassifierSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDocumentClassifierSummariesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDocumentClassifierSummariesResponse]
 */
public fun ComprehendClient.listDocumentClassifierSummariesPaginated(initialRequest: ListDocumentClassifierSummariesRequest = ListDocumentClassifierSummariesRequest { }): Flow<ListDocumentClassifierSummariesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDocumentClassifierSummariesPaginated.listDocumentClassifierSummaries(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDocumentClassifierSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDocumentClassifierSummariesResponse]
 */
public fun ComprehendClient.listDocumentClassifierSummariesPaginated(block: ListDocumentClassifierSummariesRequest.Builder.() -> Unit): Flow<ListDocumentClassifierSummariesResponse> =
    listDocumentClassifierSummariesPaginated(ListDocumentClassifierSummariesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDominantLanguageDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDominantLanguageDetectionJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDominantLanguageDetectionJobsResponse]
 */
public fun ComprehendClient.listDominantLanguageDetectionJobsPaginated(initialRequest: ListDominantLanguageDetectionJobsRequest = ListDominantLanguageDetectionJobsRequest { }): Flow<ListDominantLanguageDetectionJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDominantLanguageDetectionJobsPaginated.listDominantLanguageDetectionJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDominantLanguageDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDominantLanguageDetectionJobsResponse]
 */
public fun ComprehendClient.listDominantLanguageDetectionJobsPaginated(block: ListDominantLanguageDetectionJobsRequest.Builder.() -> Unit): Flow<ListDominantLanguageDetectionJobsResponse> =
    listDominantLanguageDetectionJobsPaginated(ListDominantLanguageDetectionJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEndpointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEndpointsResponse]
 */
public fun ComprehendClient.listEndpointsPaginated(initialRequest: ListEndpointsRequest = ListEndpointsRequest { }): Flow<ListEndpointsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEndpointsPaginated.listEndpoints(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEndpointsResponse]
 */
public fun ComprehendClient.listEndpointsPaginated(block: ListEndpointsRequest.Builder.() -> Unit): Flow<ListEndpointsResponse> =
    listEndpointsPaginated(ListEndpointsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEndpointsPaginated]
 * to access the nested member [EndpointProperties]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EndpointProperties]
 */
@JvmName("listEndpointsResponseEndpointProperties")
public fun Flow<ListEndpointsResponse>.endpointPropertiesList(): Flow<EndpointProperties> =
    transform() { response ->
        response.endpointPropertiesList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEntitiesDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEntitiesDetectionJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntitiesDetectionJobsResponse]
 */
public fun ComprehendClient.listEntitiesDetectionJobsPaginated(initialRequest: ListEntitiesDetectionJobsRequest = ListEntitiesDetectionJobsRequest { }): Flow<ListEntitiesDetectionJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEntitiesDetectionJobsPaginated.listEntitiesDetectionJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEntitiesDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntitiesDetectionJobsResponse]
 */
public fun ComprehendClient.listEntitiesDetectionJobsPaginated(block: ListEntitiesDetectionJobsRequest.Builder.() -> Unit): Flow<ListEntitiesDetectionJobsResponse> =
    listEntitiesDetectionJobsPaginated(ListEntitiesDetectionJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEntityRecognizersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEntityRecognizersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntityRecognizersResponse]
 */
public fun ComprehendClient.listEntityRecognizersPaginated(initialRequest: ListEntityRecognizersRequest = ListEntityRecognizersRequest { }): Flow<ListEntityRecognizersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEntityRecognizersPaginated.listEntityRecognizers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEntityRecognizersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntityRecognizersResponse]
 */
public fun ComprehendClient.listEntityRecognizersPaginated(block: ListEntityRecognizersRequest.Builder.() -> Unit): Flow<ListEntityRecognizersResponse> =
    listEntityRecognizersPaginated(ListEntityRecognizersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEntityRecognizerSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEntityRecognizerSummariesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntityRecognizerSummariesResponse]
 */
public fun ComprehendClient.listEntityRecognizerSummariesPaginated(initialRequest: ListEntityRecognizerSummariesRequest = ListEntityRecognizerSummariesRequest { }): Flow<ListEntityRecognizerSummariesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEntityRecognizerSummariesPaginated.listEntityRecognizerSummaries(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEntityRecognizerSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntityRecognizerSummariesResponse]
 */
public fun ComprehendClient.listEntityRecognizerSummariesPaginated(block: ListEntityRecognizerSummariesRequest.Builder.() -> Unit): Flow<ListEntityRecognizerSummariesResponse> =
    listEntityRecognizerSummariesPaginated(ListEntityRecognizerSummariesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEventsDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventsDetectionJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventsDetectionJobsResponse]
 */
public fun ComprehendClient.listEventsDetectionJobsPaginated(initialRequest: ListEventsDetectionJobsRequest = ListEventsDetectionJobsRequest { }): Flow<ListEventsDetectionJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEventsDetectionJobsPaginated.listEventsDetectionJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEventsDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventsDetectionJobsResponse]
 */
public fun ComprehendClient.listEventsDetectionJobsPaginated(block: ListEventsDetectionJobsRequest.Builder.() -> Unit): Flow<ListEventsDetectionJobsResponse> =
    listEventsDetectionJobsPaginated(ListEventsDetectionJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFlywheelIterationHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFlywheelIterationHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFlywheelIterationHistoryResponse]
 */
public fun ComprehendClient.listFlywheelIterationHistoryPaginated(initialRequest: ListFlywheelIterationHistoryRequest): Flow<ListFlywheelIterationHistoryResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFlywheelIterationHistoryPaginated.listFlywheelIterationHistory(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFlywheelIterationHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFlywheelIterationHistoryResponse]
 */
public fun ComprehendClient.listFlywheelIterationHistoryPaginated(block: ListFlywheelIterationHistoryRequest.Builder.() -> Unit): Flow<ListFlywheelIterationHistoryResponse> =
    listFlywheelIterationHistoryPaginated(ListFlywheelIterationHistoryRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFlywheelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFlywheelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFlywheelsResponse]
 */
public fun ComprehendClient.listFlywheelsPaginated(initialRequest: ListFlywheelsRequest = ListFlywheelsRequest { }): Flow<ListFlywheelsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFlywheelsPaginated.listFlywheels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFlywheelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFlywheelsResponse]
 */
public fun ComprehendClient.listFlywheelsPaginated(block: ListFlywheelsRequest.Builder.() -> Unit): Flow<ListFlywheelsResponse> =
    listFlywheelsPaginated(ListFlywheelsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListKeyPhrasesDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKeyPhrasesDetectionJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeyPhrasesDetectionJobsResponse]
 */
public fun ComprehendClient.listKeyPhrasesDetectionJobsPaginated(initialRequest: ListKeyPhrasesDetectionJobsRequest = ListKeyPhrasesDetectionJobsRequest { }): Flow<ListKeyPhrasesDetectionJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listKeyPhrasesDetectionJobsPaginated.listKeyPhrasesDetectionJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListKeyPhrasesDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeyPhrasesDetectionJobsResponse]
 */
public fun ComprehendClient.listKeyPhrasesDetectionJobsPaginated(block: ListKeyPhrasesDetectionJobsRequest.Builder.() -> Unit): Flow<ListKeyPhrasesDetectionJobsResponse> =
    listKeyPhrasesDetectionJobsPaginated(ListKeyPhrasesDetectionJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPiiEntitiesDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPiiEntitiesDetectionJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPiiEntitiesDetectionJobsResponse]
 */
public fun ComprehendClient.listPiiEntitiesDetectionJobsPaginated(initialRequest: ListPiiEntitiesDetectionJobsRequest = ListPiiEntitiesDetectionJobsRequest { }): Flow<ListPiiEntitiesDetectionJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPiiEntitiesDetectionJobsPaginated.listPiiEntitiesDetectionJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPiiEntitiesDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPiiEntitiesDetectionJobsResponse]
 */
public fun ComprehendClient.listPiiEntitiesDetectionJobsPaginated(block: ListPiiEntitiesDetectionJobsRequest.Builder.() -> Unit): Flow<ListPiiEntitiesDetectionJobsResponse> =
    listPiiEntitiesDetectionJobsPaginated(ListPiiEntitiesDetectionJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPiiEntitiesDetectionJobsPaginated]
 * to access the nested member [PiiEntitiesDetectionJobProperties]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PiiEntitiesDetectionJobProperties]
 */
@JvmName("listPiiEntitiesDetectionJobsResponsePiiEntitiesDetectionJobProperties")
public fun Flow<ListPiiEntitiesDetectionJobsResponse>.piiEntitiesDetectionJobPropertiesList(): Flow<PiiEntitiesDetectionJobProperties> =
    transform() { response ->
        response.piiEntitiesDetectionJobPropertiesList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSentimentDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSentimentDetectionJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSentimentDetectionJobsResponse]
 */
public fun ComprehendClient.listSentimentDetectionJobsPaginated(initialRequest: ListSentimentDetectionJobsRequest = ListSentimentDetectionJobsRequest { }): Flow<ListSentimentDetectionJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSentimentDetectionJobsPaginated.listSentimentDetectionJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSentimentDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSentimentDetectionJobsResponse]
 */
public fun ComprehendClient.listSentimentDetectionJobsPaginated(block: ListSentimentDetectionJobsRequest.Builder.() -> Unit): Flow<ListSentimentDetectionJobsResponse> =
    listSentimentDetectionJobsPaginated(ListSentimentDetectionJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTargetedSentimentDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTargetedSentimentDetectionJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTargetedSentimentDetectionJobsResponse]
 */
public fun ComprehendClient.listTargetedSentimentDetectionJobsPaginated(initialRequest: ListTargetedSentimentDetectionJobsRequest = ListTargetedSentimentDetectionJobsRequest { }): Flow<ListTargetedSentimentDetectionJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTargetedSentimentDetectionJobsPaginated.listTargetedSentimentDetectionJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTargetedSentimentDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTargetedSentimentDetectionJobsResponse]
 */
public fun ComprehendClient.listTargetedSentimentDetectionJobsPaginated(block: ListTargetedSentimentDetectionJobsRequest.Builder.() -> Unit): Flow<ListTargetedSentimentDetectionJobsResponse> =
    listTargetedSentimentDetectionJobsPaginated(ListTargetedSentimentDetectionJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTopicsDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTopicsDetectionJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTopicsDetectionJobsResponse]
 */
public fun ComprehendClient.listTopicsDetectionJobsPaginated(initialRequest: ListTopicsDetectionJobsRequest = ListTopicsDetectionJobsRequest { }): Flow<ListTopicsDetectionJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTopicsDetectionJobsPaginated.listTopicsDetectionJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTopicsDetectionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTopicsDetectionJobsResponse]
 */
public fun ComprehendClient.listTopicsDetectionJobsPaginated(block: ListTopicsDetectionJobsRequest.Builder.() -> Unit): Flow<ListTopicsDetectionJobsResponse> =
    listTopicsDetectionJobsPaginated(ListTopicsDetectionJobsRequest.Builder().apply(block).build())
