// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The filter used to determine which endpoints are returned. You can filter jobs on their name, model, status, or the date and time that they were created. You can only set one filter at a time.
 */
public class EndpointFilter private constructor(builder: Builder) {
    /**
     * Specifies a date after which the returned endpoint or endpoints were created.
     */
    public val creationTimeAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimeAfter
    /**
     * Specifies a date before which the returned endpoint or endpoints were created.
     */
    public val creationTimeBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimeBefore
    /**
     * The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
     */
    public val modelArn: kotlin.String? = builder.modelArn
    /**
     * Specifies the status of the endpoint being returned. Possible values are: Creating, Ready, Updating, Deleting, Failed.
     */
    public val status: aws.sdk.kotlin.services.comprehend.model.EndpointStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.EndpointFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointFilter(")
        append("creationTimeAfter=$creationTimeAfter,")
        append("creationTimeBefore=$creationTimeBefore,")
        append("modelArn=$modelArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimeAfter?.hashCode() ?: 0
        result = 31 * result + (creationTimeBefore?.hashCode() ?: 0)
        result = 31 * result + (modelArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointFilter

        if (creationTimeAfter != other.creationTimeAfter) return false
        if (creationTimeBefore != other.creationTimeBefore) return false
        if (modelArn != other.modelArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.EndpointFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies a date after which the returned endpoint or endpoints were created.
         */
        public var creationTimeAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies a date before which the returned endpoint or endpoints were created.
         */
        public var creationTimeBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
         */
        public var modelArn: kotlin.String? = null
        /**
         * Specifies the status of the endpoint being returned. Possible values are: Creating, Ready, Updating, Deleting, Failed.
         */
        public var status: aws.sdk.kotlin.services.comprehend.model.EndpointStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.EndpointFilter) : this() {
            this.creationTimeAfter = x.creationTimeAfter
            this.creationTimeBefore = x.creationTimeBefore
            this.modelArn = x.modelArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.EndpointFilter = EndpointFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
