// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The input properties for training a document classifier.
 *
 * For more information on how the input file is formatted, see [Preparing training data](https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html) in the Comprehend Developer Guide.
 */
public class DocumentClassifierInputDataConfig private constructor(builder: Builder) {
    /**
     * A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
     *
     * This parameter is required if you set `DataFormat` to `AUGMENTED_MANIFEST`.
     */
    public val augmentedManifests: List<AugmentedManifestsListItem>? = builder.augmentedManifests
    /**
     * The format of your training data:
     * + `COMPREHEND_CSV`: A two-column CSV file, where labels are provided in the first column, and documents are provided in the second. If you use this value, you must provide the `S3Uri` parameter in your request.
     * + `AUGMENTED_MANIFEST`: A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its associated labels. If you use this value, you must provide the `AugmentedManifests` parameter in your request.
     *
     * If you don't specify a value, Amazon Comprehend uses `COMPREHEND_CSV` as the default.
     */
    public val dataFormat: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDataFormat? = builder.dataFormat
    /**
     * Provides configuration parameters to override the default actions for extracting text from PDF documents and image files.
     *
     *  By default, Amazon Comprehend performs the following actions to extract text from files, based on the input file type:
     * + **Word files** - Amazon Comprehend parser extracts the text.
     * + **Digital PDF files** - Amazon Comprehend parser extracts the text.
     * + **Image files and scanned PDF files** - Amazon Comprehend uses the Amazon Textract `DetectDocumentText` API to extract the text.
     *
     * `DocumentReaderConfig` does not apply to plain text files or Word files.
     *
     *  For image files and PDF documents, you can override these default actions using the fields listed below. For more information, see [ Setting text extraction options](https://docs.aws.amazon.com/comprehend/latest/dg/idp-set-textract-options.html) in the Comprehend Developer Guide.
     */
    public val documentReaderConfig: aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig? = builder.documentReaderConfig
    /**
     * The type of input documents for training the model. Provide plain-text documents to create a plain-text model, and provide semi-structured documents to create a native document model.
     */
    public val documentType: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDocumentTypeFormat? = builder.documentType
    /**
     * The S3 location of the training documents. This parameter is required in a request to create a native document model.
     */
    public val documents: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDocuments? = builder.documents
    /**
     * Indicates the delimiter used to separate each label for training a multi-label classifier. The default delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the delimiter you specify, the labels on that line will be combined to make a single unique label, such as LABELLABELLABEL.
     */
    public val labelDelimiter: kotlin.String? = builder.labelDelimiter
    /**
     * The Amazon S3 URI for the input data. The S3 bucket must be in the same Region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.
     *
     * For example, if you use the URI `S3://bucketName/prefix`, if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.
     *
     * This parameter is required if you set `DataFormat` to `COMPREHEND_CSV`.
     */
    public val s3Uri: kotlin.String? = builder.s3Uri
    /**
     * This specifies the Amazon S3 location that contains the test annotations for the document classifier. The URI must be in the same Amazon Web Services Region as the API endpoint that you are calling.
     */
    public val testS3Uri: kotlin.String? = builder.testS3Uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentClassifierInputDataConfig(")
        append("augmentedManifests=$augmentedManifests,")
        append("dataFormat=$dataFormat,")
        append("documentReaderConfig=$documentReaderConfig,")
        append("documentType=$documentType,")
        append("documents=$documents,")
        append("labelDelimiter=$labelDelimiter,")
        append("s3Uri=$s3Uri,")
        append("testS3Uri=$testS3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = augmentedManifests?.hashCode() ?: 0
        result = 31 * result + (dataFormat?.hashCode() ?: 0)
        result = 31 * result + (documentReaderConfig?.hashCode() ?: 0)
        result = 31 * result + (documentType?.hashCode() ?: 0)
        result = 31 * result + (documents?.hashCode() ?: 0)
        result = 31 * result + (labelDelimiter?.hashCode() ?: 0)
        result = 31 * result + (s3Uri?.hashCode() ?: 0)
        result = 31 * result + (testS3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentClassifierInputDataConfig

        if (augmentedManifests != other.augmentedManifests) return false
        if (dataFormat != other.dataFormat) return false
        if (documentReaderConfig != other.documentReaderConfig) return false
        if (documentType != other.documentType) return false
        if (documents != other.documents) return false
        if (labelDelimiter != other.labelDelimiter) return false
        if (s3Uri != other.s3Uri) return false
        if (testS3Uri != other.testS3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
         *
         * This parameter is required if you set `DataFormat` to `AUGMENTED_MANIFEST`.
         */
        public var augmentedManifests: List<AugmentedManifestsListItem>? = null
        /**
         * The format of your training data:
         * + `COMPREHEND_CSV`: A two-column CSV file, where labels are provided in the first column, and documents are provided in the second. If you use this value, you must provide the `S3Uri` parameter in your request.
         * + `AUGMENTED_MANIFEST`: A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its associated labels. If you use this value, you must provide the `AugmentedManifests` parameter in your request.
         *
         * If you don't specify a value, Amazon Comprehend uses `COMPREHEND_CSV` as the default.
         */
        public var dataFormat: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDataFormat? = null
        /**
         * Provides configuration parameters to override the default actions for extracting text from PDF documents and image files.
         *
         *  By default, Amazon Comprehend performs the following actions to extract text from files, based on the input file type:
         * + **Word files** - Amazon Comprehend parser extracts the text.
         * + **Digital PDF files** - Amazon Comprehend parser extracts the text.
         * + **Image files and scanned PDF files** - Amazon Comprehend uses the Amazon Textract `DetectDocumentText` API to extract the text.
         *
         * `DocumentReaderConfig` does not apply to plain text files or Word files.
         *
         *  For image files and PDF documents, you can override these default actions using the fields listed below. For more information, see [ Setting text extraction options](https://docs.aws.amazon.com/comprehend/latest/dg/idp-set-textract-options.html) in the Comprehend Developer Guide.
         */
        public var documentReaderConfig: aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig? = null
        /**
         * The type of input documents for training the model. Provide plain-text documents to create a plain-text model, and provide semi-structured documents to create a native document model.
         */
        public var documentType: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDocumentTypeFormat? = null
        /**
         * The S3 location of the training documents. This parameter is required in a request to create a native document model.
         */
        public var documents: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDocuments? = null
        /**
         * Indicates the delimiter used to separate each label for training a multi-label classifier. The default delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the delimiter you specify, the labels on that line will be combined to make a single unique label, such as LABELLABELLABEL.
         */
        public var labelDelimiter: kotlin.String? = null
        /**
         * The Amazon S3 URI for the input data. The S3 bucket must be in the same Region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.
         *
         * For example, if you use the URI `S3://bucketName/prefix`, if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.
         *
         * This parameter is required if you set `DataFormat` to `COMPREHEND_CSV`.
         */
        public var s3Uri: kotlin.String? = null
        /**
         * This specifies the Amazon S3 location that contains the test annotations for the document classifier. The URI must be in the same Amazon Web Services Region as the API endpoint that you are calling.
         */
        public var testS3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig) : this() {
            this.augmentedManifests = x.augmentedManifests
            this.dataFormat = x.dataFormat
            this.documentReaderConfig = x.documentReaderConfig
            this.documentType = x.documentType
            this.documents = x.documents
            this.labelDelimiter = x.labelDelimiter
            this.s3Uri = x.s3Uri
            this.testS3Uri = x.testS3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig = DocumentClassifierInputDataConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig] inside the given [block]
         */
        public fun documentReaderConfig(block: aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig.Builder.() -> kotlin.Unit) {
            this.documentReaderConfig = aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDocuments] inside the given [block]
         */
        public fun documents(block: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDocuments.Builder.() -> kotlin.Unit) {
            this.documents = aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDocuments.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
