// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.comprehend.auth.ComprehendAuthSchemeProvider
import aws.sdk.kotlin.services.comprehend.auth.DefaultComprehendAuthSchemeProvider
import aws.sdk.kotlin.services.comprehend.endpoints.ComprehendEndpointParameters
import aws.sdk.kotlin.services.comprehend.endpoints.ComprehendEndpointProvider
import aws.sdk.kotlin.services.comprehend.endpoints.DefaultComprehendEndpointProvider
import aws.sdk.kotlin.services.comprehend.model.BatchDetectDominantLanguageRequest
import aws.sdk.kotlin.services.comprehend.model.BatchDetectDominantLanguageResponse
import aws.sdk.kotlin.services.comprehend.model.BatchDetectEntitiesRequest
import aws.sdk.kotlin.services.comprehend.model.BatchDetectEntitiesResponse
import aws.sdk.kotlin.services.comprehend.model.BatchDetectKeyPhrasesRequest
import aws.sdk.kotlin.services.comprehend.model.BatchDetectKeyPhrasesResponse
import aws.sdk.kotlin.services.comprehend.model.BatchDetectSentimentRequest
import aws.sdk.kotlin.services.comprehend.model.BatchDetectSentimentResponse
import aws.sdk.kotlin.services.comprehend.model.BatchDetectSyntaxRequest
import aws.sdk.kotlin.services.comprehend.model.BatchDetectSyntaxResponse
import aws.sdk.kotlin.services.comprehend.model.BatchDetectTargetedSentimentRequest
import aws.sdk.kotlin.services.comprehend.model.BatchDetectTargetedSentimentResponse
import aws.sdk.kotlin.services.comprehend.model.ClassifyDocumentRequest
import aws.sdk.kotlin.services.comprehend.model.ClassifyDocumentResponse
import aws.sdk.kotlin.services.comprehend.model.ContainsPiiEntitiesRequest
import aws.sdk.kotlin.services.comprehend.model.ContainsPiiEntitiesResponse
import aws.sdk.kotlin.services.comprehend.model.CreateDatasetRequest
import aws.sdk.kotlin.services.comprehend.model.CreateDatasetResponse
import aws.sdk.kotlin.services.comprehend.model.CreateDocumentClassifierRequest
import aws.sdk.kotlin.services.comprehend.model.CreateDocumentClassifierResponse
import aws.sdk.kotlin.services.comprehend.model.CreateEndpointRequest
import aws.sdk.kotlin.services.comprehend.model.CreateEndpointResponse
import aws.sdk.kotlin.services.comprehend.model.CreateEntityRecognizerRequest
import aws.sdk.kotlin.services.comprehend.model.CreateEntityRecognizerResponse
import aws.sdk.kotlin.services.comprehend.model.CreateFlywheelRequest
import aws.sdk.kotlin.services.comprehend.model.CreateFlywheelResponse
import aws.sdk.kotlin.services.comprehend.model.DeleteDocumentClassifierRequest
import aws.sdk.kotlin.services.comprehend.model.DeleteDocumentClassifierResponse
import aws.sdk.kotlin.services.comprehend.model.DeleteEndpointRequest
import aws.sdk.kotlin.services.comprehend.model.DeleteEndpointResponse
import aws.sdk.kotlin.services.comprehend.model.DeleteEntityRecognizerRequest
import aws.sdk.kotlin.services.comprehend.model.DeleteEntityRecognizerResponse
import aws.sdk.kotlin.services.comprehend.model.DeleteFlywheelRequest
import aws.sdk.kotlin.services.comprehend.model.DeleteFlywheelResponse
import aws.sdk.kotlin.services.comprehend.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.comprehend.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeDatasetRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeDatasetResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeDocumentClassificationJobRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeDocumentClassificationJobResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeDocumentClassifierRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeDocumentClassifierResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeDominantLanguageDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeEndpointRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeEndpointResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeEntitiesDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeEntitiesDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeEntityRecognizerRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeEntityRecognizerResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeEventsDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeEventsDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeFlywheelIterationRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeFlywheelIterationResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeFlywheelRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeFlywheelResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.DescribePiiEntitiesDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeResourcePolicyRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeResourcePolicyResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeSentimentDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeSentimentDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeTargetedSentimentDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeTargetedSentimentDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.DescribeTopicsDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.DescribeTopicsDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.DetectDominantLanguageRequest
import aws.sdk.kotlin.services.comprehend.model.DetectDominantLanguageResponse
import aws.sdk.kotlin.services.comprehend.model.DetectEntitiesRequest
import aws.sdk.kotlin.services.comprehend.model.DetectEntitiesResponse
import aws.sdk.kotlin.services.comprehend.model.DetectKeyPhrasesRequest
import aws.sdk.kotlin.services.comprehend.model.DetectKeyPhrasesResponse
import aws.sdk.kotlin.services.comprehend.model.DetectPiiEntitiesRequest
import aws.sdk.kotlin.services.comprehend.model.DetectPiiEntitiesResponse
import aws.sdk.kotlin.services.comprehend.model.DetectSentimentRequest
import aws.sdk.kotlin.services.comprehend.model.DetectSentimentResponse
import aws.sdk.kotlin.services.comprehend.model.DetectSyntaxRequest
import aws.sdk.kotlin.services.comprehend.model.DetectSyntaxResponse
import aws.sdk.kotlin.services.comprehend.model.DetectTargetedSentimentRequest
import aws.sdk.kotlin.services.comprehend.model.DetectTargetedSentimentResponse
import aws.sdk.kotlin.services.comprehend.model.DetectToxicContentRequest
import aws.sdk.kotlin.services.comprehend.model.DetectToxicContentResponse
import aws.sdk.kotlin.services.comprehend.model.ImportModelRequest
import aws.sdk.kotlin.services.comprehend.model.ImportModelResponse
import aws.sdk.kotlin.services.comprehend.model.ListDatasetsRequest
import aws.sdk.kotlin.services.comprehend.model.ListDatasetsResponse
import aws.sdk.kotlin.services.comprehend.model.ListDocumentClassificationJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListDocumentClassificationJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListDocumentClassifierSummariesRequest
import aws.sdk.kotlin.services.comprehend.model.ListDocumentClassifierSummariesResponse
import aws.sdk.kotlin.services.comprehend.model.ListDocumentClassifiersRequest
import aws.sdk.kotlin.services.comprehend.model.ListDocumentClassifiersResponse
import aws.sdk.kotlin.services.comprehend.model.ListDominantLanguageDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListDominantLanguageDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListEndpointsRequest
import aws.sdk.kotlin.services.comprehend.model.ListEndpointsResponse
import aws.sdk.kotlin.services.comprehend.model.ListEntitiesDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListEntitiesDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListEntityRecognizerSummariesRequest
import aws.sdk.kotlin.services.comprehend.model.ListEntityRecognizerSummariesResponse
import aws.sdk.kotlin.services.comprehend.model.ListEntityRecognizersRequest
import aws.sdk.kotlin.services.comprehend.model.ListEntityRecognizersResponse
import aws.sdk.kotlin.services.comprehend.model.ListEventsDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListEventsDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListFlywheelIterationHistoryRequest
import aws.sdk.kotlin.services.comprehend.model.ListFlywheelIterationHistoryResponse
import aws.sdk.kotlin.services.comprehend.model.ListFlywheelsRequest
import aws.sdk.kotlin.services.comprehend.model.ListFlywheelsResponse
import aws.sdk.kotlin.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListSentimentDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListSentimentDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.comprehend.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.comprehend.model.ListTargetedSentimentDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListTargetedSentimentDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.ListTopicsDetectionJobsRequest
import aws.sdk.kotlin.services.comprehend.model.ListTopicsDetectionJobsResponse
import aws.sdk.kotlin.services.comprehend.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.comprehend.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.comprehend.model.StartDocumentClassificationJobRequest
import aws.sdk.kotlin.services.comprehend.model.StartDocumentClassificationJobResponse
import aws.sdk.kotlin.services.comprehend.model.StartDominantLanguageDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StartDominantLanguageDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StartEntitiesDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StartEntitiesDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StartEventsDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StartEventsDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StartFlywheelIterationRequest
import aws.sdk.kotlin.services.comprehend.model.StartFlywheelIterationResponse
import aws.sdk.kotlin.services.comprehend.model.StartKeyPhrasesDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StartKeyPhrasesDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StartPiiEntitiesDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StartPiiEntitiesDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StartSentimentDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StartSentimentDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StartTargetedSentimentDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StartTargetedSentimentDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StartTopicsDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StartTopicsDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StopDominantLanguageDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StopDominantLanguageDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StopEntitiesDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StopEntitiesDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StopEventsDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StopEventsDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StopKeyPhrasesDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StopKeyPhrasesDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StopPiiEntitiesDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StopPiiEntitiesDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StopSentimentDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StopSentimentDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StopTargetedSentimentDetectionJobRequest
import aws.sdk.kotlin.services.comprehend.model.StopTargetedSentimentDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.StopTrainingDocumentClassifierRequest
import aws.sdk.kotlin.services.comprehend.model.StopTrainingDocumentClassifierResponse
import aws.sdk.kotlin.services.comprehend.model.StopTrainingEntityRecognizerRequest
import aws.sdk.kotlin.services.comprehend.model.StopTrainingEntityRecognizerResponse
import aws.sdk.kotlin.services.comprehend.model.TagResourceRequest
import aws.sdk.kotlin.services.comprehend.model.TagResourceResponse
import aws.sdk.kotlin.services.comprehend.model.UntagResourceRequest
import aws.sdk.kotlin.services.comprehend.model.UntagResourceResponse
import aws.sdk.kotlin.services.comprehend.model.UpdateEndpointRequest
import aws.sdk.kotlin.services.comprehend.model.UpdateEndpointResponse
import aws.sdk.kotlin.services.comprehend.model.UpdateFlywheelRequest
import aws.sdk.kotlin.services.comprehend.model.UpdateFlywheelResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Comprehend"
public const val SdkVersion: String = "1.4.7"
public const val ServiceApiVersion: String = "2017-11-27"

/**
 * Amazon Comprehend is an Amazon Web Services service for gaining insight into the content of documents. Use these actions to determine the topics contained in your documents, the topics they discuss, the predominant sentiment expressed in them, the predominant language used, and more.
 */
public interface ComprehendClient : SdkClient {
    /**
     * ComprehendClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ComprehendClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Comprehend",
                "COMPREHEND",
                "comprehend",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ComprehendClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ComprehendClient = DefaultComprehendClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ComprehendEndpointProvider = builder.endpointProvider ?: DefaultComprehendEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ComprehendAuthSchemeProvider = builder.authSchemeProvider ?: DefaultComprehendAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Comprehend"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ComprehendEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ComprehendAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon Comprehend can detect, see [Amazon Comprehend Supported Languages](https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
     */
    public suspend fun batchDetectDominantLanguage(input: BatchDetectDominantLanguageRequest): BatchDetectDominantLanguageResponse

    /**
     * Inspects the text of a batch of documents for named entities and returns information about them. For more information about named entities, see [Entities](https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html) in the Comprehend Developer Guide.
     */
    public suspend fun batchDetectEntities(input: BatchDetectEntitiesRequest): BatchDetectEntitiesResponse

    /**
     * Detects the key noun phrases found in a batch of documents.
     */
    public suspend fun batchDetectKeyPhrases(input: BatchDetectKeyPhrasesRequest): BatchDetectKeyPhrasesResponse

    /**
     * Inspects a batch of documents and returns an inference of the prevailing sentiment, `POSITIVE`, `NEUTRAL`, `MIXED`, or `NEGATIVE`, in each one.
     */
    public suspend fun batchDetectSentiment(input: BatchDetectSentimentRequest): BatchDetectSentimentResponse

    /**
     * Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and returns information about them. For more information, see [Syntax](https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html) in the Comprehend Developer Guide.
     */
    public suspend fun batchDetectSyntax(input: BatchDetectSyntaxRequest): BatchDetectSyntaxResponse

    /**
     * Inspects a batch of documents and returns a sentiment analysis for each entity identified in the documents.
     *
     * For more information about targeted sentiment, see [Targeted sentiment](https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html) in the *Amazon Comprehend Developer Guide*.
     */
    public suspend fun batchDetectTargetedSentiment(input: BatchDetectTargetedSentimentRequest): BatchDetectTargetedSentimentResponse

    /**
     * Creates a classification request to analyze a single document in real-time. `ClassifyDocument` supports the following model types:
     * + Custom classifier - a custom model that you have created and trained. For input, you can provide plain text, a single-page document (PDF, Word, or image), or Amazon Textract API output. For more information, see [Custom classification](https://docs.aws.amazon.com/comprehend/latest/dg/how-document-classification.html) in the *Amazon Comprehend Developer Guide*.
     * + Prompt safety classifier - Amazon Comprehend provides a pre-trained model for classifying input prompts for generative AI applications. For input, you provide English plain text input. For prompt safety classification, the response includes only the `Classes` field. For more information about prompt safety classifiers, see [Prompt safety classification](https://docs.aws.amazon.com/comprehend/latest/dg/trust-safety.html#prompt-classification) in the *Amazon Comprehend Developer Guide*.
     *
     * If the system detects errors while processing a page in the input document, the API response includes an `Errors` field that describes the errors.
     *
     * If the system detects a document-level error in your input document, the API returns an `InvalidRequestException` error response. For details about this exception, see [ Errors in semi-structured documents](https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html) in the Comprehend Developer Guide.
     */
    public suspend fun classifyDocument(input: ClassifyDocumentRequest): ClassifyDocumentResponse

    /**
     * Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of identified PII entity types such as name, address, bank account number, or phone number.
     */
    public suspend fun containsPiiEntities(input: ContainsPiiEntitiesRequest): ContainsPiiEntitiesResponse

    /**
     * Creates a dataset to upload training or test data for a model associated with a flywheel. For more information about datasets, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    public suspend fun createDataset(input: CreateDatasetRequest): CreateDatasetResponse

    /**
     * Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a set of training documents that are labeled with the categories that you want to use. For more information, see [Training classifier models](https://docs.aws.amazon.com/comprehend/latest/dg/training-classifier-model.html) in the Comprehend Developer Guide.
     */
    public suspend fun createDocumentClassifier(input: CreateDocumentClassifierRequest): CreateDocumentClassifierResponse

    /**
     * Creates a model-specific endpoint for synchronous inference for a previously trained custom model For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
     */
    public suspend fun createEndpoint(input: CreateEndpointRequest): CreateEndpointResponse

    /**
     * Creates an entity recognizer using submitted files. After your `CreateEntityRecognizer` request is submitted, you can check job status using the `DescribeEntityRecognizer` API.
     */
    public suspend fun createEntityRecognizer(input: CreateEntityRecognizerRequest): CreateEntityRecognizerResponse

    /**
     * A flywheel is an Amazon Web Services resource that orchestrates the ongoing training of a model for custom classification or custom entity recognition. You can create a flywheel to start with an existing trained model, or Comprehend can create and train a new model.
     *
     * When you create the flywheel, Comprehend creates a data lake in your account. The data lake holds the training data and test data for all versions of the model.
     *
     * To use a flywheel with an existing trained model, you specify the active model version. Comprehend copies the model's training data and test data into the flywheel's data lake.
     *
     * To use the flywheel with a new model, you need to provide a dataset for training data (and optional test data) when you create the flywheel.
     *
     * For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    public suspend fun createFlywheel(input: CreateFlywheelRequest): CreateFlywheelResponse

    /**
     * Deletes a previously created document classifier
     *
     * Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a `ResourceInUseException` will be returned.
     *
     * This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a background job. Once removed, the classifier disappears from your account and is no longer available for use.
     */
    public suspend fun deleteDocumentClassifier(input: DeleteDocumentClassifierRequest): DeleteDocumentClassifierResponse

    /**
     * Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order for the model to be deleted. For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
     */
    public suspend fun deleteEndpoint(input: DeleteEndpointRequest): DeleteEndpointResponse

    /**
     * Deletes an entity recognizer.
     *
     * Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a `ResourceInUseException` will be returned.
     *
     * This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a background job. Once removed, the recognizer disappears from your account and is no longer available for use.
     */
    public suspend fun deleteEntityRecognizer(input: DeleteEntityRecognizerRequest): DeleteEntityRecognizerResponse

    /**
     * Deletes a flywheel. When you delete the flywheel, Amazon Comprehend does not delete the data lake or the model associated with the flywheel.
     *
     * For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    public suspend fun deleteFlywheel(input: DeleteFlywheelRequest): DeleteFlywheelResponse

    /**
     * Deletes a resource-based policy that is attached to a custom model.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Returns information about the dataset that you specify. For more information about datasets, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    public suspend fun describeDataset(input: DescribeDatasetRequest): DescribeDatasetResponse

    /**
     * Gets the properties associated with a document classification job. Use this operation to get the status of a classification job.
     */
    public suspend fun describeDocumentClassificationJob(input: DescribeDocumentClassificationJobRequest): DescribeDocumentClassificationJobResponse

    /**
     * Gets the properties associated with a document classifier.
     */
    public suspend fun describeDocumentClassifier(input: DescribeDocumentClassifierRequest): DescribeDocumentClassifierResponse

    /**
     * Gets the properties associated with a dominant language detection job. Use this operation to get the status of a detection job.
     */
    public suspend fun describeDominantLanguageDetectionJob(input: DescribeDominantLanguageDetectionJobRequest): DescribeDominantLanguageDetectionJobResponse

    /**
     * Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint. For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
     */
    public suspend fun describeEndpoint(input: DescribeEndpointRequest): DescribeEndpointResponse

    /**
     * Gets the properties associated with an entities detection job. Use this operation to get the status of a detection job.
     */
    public suspend fun describeEntitiesDetectionJob(input: DescribeEntitiesDetectionJobRequest): DescribeEntitiesDetectionJobResponse

    /**
     * Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer metadata, metrics, and so on.
     */
    public suspend fun describeEntityRecognizer(input: DescribeEntityRecognizerRequest): DescribeEntityRecognizerResponse

    /**
     * Gets the status and details of an events detection job.
     */
    public suspend fun describeEventsDetectionJob(input: DescribeEventsDetectionJobRequest): DescribeEventsDetectionJobResponse

    /**
     * Provides configuration information about the flywheel. For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    public suspend fun describeFlywheel(input: DescribeFlywheelRequest): DescribeFlywheelResponse

    /**
     * Retrieve the configuration properties of a flywheel iteration. For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    public suspend fun describeFlywheelIteration(input: DescribeFlywheelIterationRequest): DescribeFlywheelIterationResponse

    /**
     * Gets the properties associated with a key phrases detection job. Use this operation to get the status of a detection job.
     */
    public suspend fun describeKeyPhrasesDetectionJob(input: DescribeKeyPhrasesDetectionJobRequest): DescribeKeyPhrasesDetectionJobResponse

    /**
     * Gets the properties associated with a PII entities detection job. For example, you can use this operation to get the job status.
     */
    public suspend fun describePiiEntitiesDetectionJob(input: DescribePiiEntitiesDetectionJobRequest): DescribePiiEntitiesDetectionJobResponse

    /**
     * Gets the details of a resource-based policy that is attached to a custom model, including the JSON body of the policy.
     */
    public suspend fun describeResourcePolicy(input: DescribeResourcePolicyRequest): DescribeResourcePolicyResponse

    /**
     * Gets the properties associated with a sentiment detection job. Use this operation to get the status of a detection job.
     */
    public suspend fun describeSentimentDetectionJob(input: DescribeSentimentDetectionJobRequest): DescribeSentimentDetectionJobResponse

    /**
     * Gets the properties associated with a targeted sentiment detection job. Use this operation to get the status of the job.
     */
    public suspend fun describeTargetedSentimentDetectionJob(input: DescribeTargetedSentimentDetectionJobRequest): DescribeTargetedSentimentDetectionJobResponse

    /**
     * Gets the properties associated with a topic detection job. Use this operation to get the status of a detection job.
     */
    public suspend fun describeTopicsDetectionJob(input: DescribeTopicsDetectionJobRequest): DescribeTopicsDetectionJobResponse

    /**
     * Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect, see [Amazon Comprehend Supported Languages](https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
     */
    public suspend fun detectDominantLanguage(input: DetectDominantLanguageRequest): DetectDominantLanguageResponse

    /**
     * Detects named entities in input text when you use the pre-trained model. Detects custom entities if you have a custom entity recognition model.
     *
     *  When detecting named entities using the pre-trained model, use plain text as the input. For more information about named entities, see [Entities](https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html) in the Comprehend Developer Guide.
     *
     * When you use a custom entity recognition model, you can input plain text or you can upload a single-page input document (text, PDF, Word, or image).
     *
     * If the system detects errors while processing a page in the input document, the API response includes an entry in `Errors` for each error.
     *
     * If the system detects a document-level error in your input document, the API returns an `InvalidRequestException` error response. For details about this exception, see [ Errors in semi-structured documents](https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html) in the Comprehend Developer Guide.
     */
    public suspend fun detectEntities(input: DetectEntitiesRequest = DetectEntitiesRequest { }): DetectEntitiesResponse

    /**
     * Detects the key noun phrases found in the text.
     */
    public suspend fun detectKeyPhrases(input: DetectKeyPhrasesRequest): DetectKeyPhrasesResponse

    /**
     * Inspects the input text for entities that contain personally identifiable information (PII) and returns information about them.
     */
    public suspend fun detectPiiEntities(input: DetectPiiEntitiesRequest): DetectPiiEntitiesResponse

    /**
     * Inspects text and returns an inference of the prevailing sentiment (`POSITIVE`, `NEUTRAL`, `MIXED`, or `NEGATIVE`).
     */
    public suspend fun detectSentiment(input: DetectSentimentRequest): DetectSentimentResponse

    /**
     * Inspects text for syntax and the part of speech of words in the document. For more information, see [Syntax](https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html) in the Comprehend Developer Guide.
     */
    public suspend fun detectSyntax(input: DetectSyntaxRequest): DetectSyntaxResponse

    /**
     * Inspects the input text and returns a sentiment analysis for each entity identified in the text.
     *
     * For more information about targeted sentiment, see [Targeted sentiment](https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html) in the *Amazon Comprehend Developer Guide*.
     */
    public suspend fun detectTargetedSentiment(input: DetectTargetedSentimentRequest): DetectTargetedSentimentResponse

    /**
     * Performs toxicity analysis on the list of text strings that you provide as input. The API response contains a results list that matches the size of the input list. For more information about toxicity detection, see [Toxicity detection](https://docs.aws.amazon.com/comprehend/latest/dg/toxicity-detection.html) in the *Amazon Comprehend Developer Guide*.
     */
    public suspend fun detectToxicContent(input: DetectToxicContentRequest): DetectToxicContentResponse

    /**
     * Creates a new custom model that replicates a source custom model that you import. The source model can be in your Amazon Web Services account or another one.
     *
     * If the source model is in another Amazon Web Services account, then it must have a resource-based policy that authorizes you to import it.
     *
     * The source model must be in the same Amazon Web Services Region that you're using when you import. You can't import a model that's in a different Region.
     */
    public suspend fun importModel(input: ImportModelRequest): ImportModelResponse

    /**
     * List the datasets that you have configured in this Region. For more information about datasets, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    public suspend fun listDatasets(input: ListDatasetsRequest = ListDatasetsRequest { }): ListDatasetsResponse

    /**
     * Gets a list of the documentation classification jobs that you have submitted.
     */
    public suspend fun listDocumentClassificationJobs(input: ListDocumentClassificationJobsRequest = ListDocumentClassificationJobsRequest { }): ListDocumentClassificationJobsResponse

    /**
     * Gets a list of summaries of the document classifiers that you have created
     */
    public suspend fun listDocumentClassifierSummaries(input: ListDocumentClassifierSummariesRequest = ListDocumentClassifierSummariesRequest { }): ListDocumentClassifierSummariesResponse

    /**
     * Gets a list of the document classifiers that you have created.
     */
    public suspend fun listDocumentClassifiers(input: ListDocumentClassifiersRequest = ListDocumentClassifiersRequest { }): ListDocumentClassifiersResponse

    /**
     * Gets a list of the dominant language detection jobs that you have submitted.
     */
    public suspend fun listDominantLanguageDetectionJobs(input: ListDominantLanguageDetectionJobsRequest = ListDominantLanguageDetectionJobsRequest { }): ListDominantLanguageDetectionJobsResponse

    /**
     * Gets a list of all existing endpoints that you've created. For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
     */
    public suspend fun listEndpoints(input: ListEndpointsRequest = ListEndpointsRequest { }): ListEndpointsResponse

    /**
     * Gets a list of the entity detection jobs that you have submitted.
     */
    public suspend fun listEntitiesDetectionJobs(input: ListEntitiesDetectionJobsRequest = ListEntitiesDetectionJobsRequest { }): ListEntitiesDetectionJobsResponse

    /**
     * Gets a list of summaries for the entity recognizers that you have created.
     */
    public suspend fun listEntityRecognizerSummaries(input: ListEntityRecognizerSummariesRequest = ListEntityRecognizerSummariesRequest { }): ListEntityRecognizerSummariesResponse

    /**
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     *
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     */
    public suspend fun listEntityRecognizers(input: ListEntityRecognizersRequest = ListEntityRecognizersRequest { }): ListEntityRecognizersResponse

    /**
     * Gets a list of the events detection jobs that you have submitted.
     */
    public suspend fun listEventsDetectionJobs(input: ListEventsDetectionJobsRequest = ListEventsDetectionJobsRequest { }): ListEventsDetectionJobsResponse

    /**
     * Information about the history of a flywheel iteration. For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    public suspend fun listFlywheelIterationHistory(input: ListFlywheelIterationHistoryRequest): ListFlywheelIterationHistoryResponse

    /**
     * Gets a list of the flywheels that you have created.
     */
    public suspend fun listFlywheels(input: ListFlywheelsRequest = ListFlywheelsRequest { }): ListFlywheelsResponse

    /**
     * Get a list of key phrase detection jobs that you have submitted.
     */
    public suspend fun listKeyPhrasesDetectionJobs(input: ListKeyPhrasesDetectionJobsRequest = ListKeyPhrasesDetectionJobsRequest { }): ListKeyPhrasesDetectionJobsResponse

    /**
     * Gets a list of the PII entity detection jobs that you have submitted.
     */
    public suspend fun listPiiEntitiesDetectionJobs(input: ListPiiEntitiesDetectionJobsRequest = ListPiiEntitiesDetectionJobsRequest { }): ListPiiEntitiesDetectionJobsResponse

    /**
     * Gets a list of sentiment detection jobs that you have submitted.
     */
    public suspend fun listSentimentDetectionJobs(input: ListSentimentDetectionJobsRequest = ListSentimentDetectionJobsRequest { }): ListSentimentDetectionJobsResponse

    /**
     * Lists all tags associated with a given Amazon Comprehend resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Gets a list of targeted sentiment detection jobs that you have submitted.
     */
    public suspend fun listTargetedSentimentDetectionJobs(input: ListTargetedSentimentDetectionJobsRequest = ListTargetedSentimentDetectionJobsRequest { }): ListTargetedSentimentDetectionJobsResponse

    /**
     * Gets a list of the topic detection jobs that you have submitted.
     */
    public suspend fun listTopicsDetectionJobs(input: ListTopicsDetectionJobsRequest = ListTopicsDetectionJobsRequest { }): ListTopicsDetectionJobsResponse

    /**
     * Attaches a resource-based policy to a custom model. You can use this policy to authorize an entity in another Amazon Web Services account to import the custom model, which replicates it in Amazon Comprehend in their account.
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Starts an asynchronous document classification job using a custom classification model. Use the `DescribeDocumentClassificationJob` operation to track the progress of the job.
     */
    public suspend fun startDocumentClassificationJob(input: StartDocumentClassificationJobRequest): StartDocumentClassificationJobResponse

    /**
     * Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track the status of a job.
     */
    public suspend fun startDominantLanguageDetectionJob(input: StartDominantLanguageDetectionJobRequest): StartDominantLanguageDetectionJobResponse

    /**
     * Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status of a job.
     *
     * This API can be used for either standard entity detection or custom entity recognition. In order to be used for custom entity recognition, the optional `EntityRecognizerArn` must be used in order to provide access to the recognizer being used to detect the custom entity.
     */
    public suspend fun startEntitiesDetectionJob(input: StartEntitiesDetectionJobRequest): StartEntitiesDetectionJobResponse

    /**
     * Starts an asynchronous event detection job for a collection of documents.
     */
    public suspend fun startEventsDetectionJob(input: StartEventsDetectionJobRequest): StartEventsDetectionJobResponse

    /**
     * Start the flywheel iteration.This operation uses any new datasets to train a new model version. For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
     */
    public suspend fun startFlywheelIteration(input: StartFlywheelIterationRequest): StartFlywheelIterationResponse

    /**
     * Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the status of a job.
     */
    public suspend fun startKeyPhrasesDetectionJob(input: StartKeyPhrasesDetectionJobRequest): StartKeyPhrasesDetectionJobResponse

    /**
     * Starts an asynchronous PII entity detection job for a collection of documents.
     */
    public suspend fun startPiiEntitiesDetectionJob(input: StartPiiEntitiesDetectionJobRequest): StartPiiEntitiesDetectionJobResponse

    /**
     * Starts an asynchronous sentiment detection job for a collection of documents. Use the operation to track the status of a job.
     */
    public suspend fun startSentimentDetectionJob(input: StartSentimentDetectionJobRequest): StartSentimentDetectionJobResponse

    /**
     * Starts an asynchronous targeted sentiment detection job for a collection of documents. Use the `DescribeTargetedSentimentDetectionJob` operation to track the status of a job.
     */
    public suspend fun startTargetedSentimentDetectionJob(input: StartTargetedSentimentDetectionJobRequest): StartTargetedSentimentDetectionJobResponse

    /**
     * Starts an asynchronous topic detection job. Use the `DescribeTopicDetectionJob` operation to track the status of a job.
     */
    public suspend fun startTopicsDetectionJob(input: StartTopicsDetectionJobRequest): StartTopicsDetectionJobResponse

    /**
     * Stops a dominant language detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    public suspend fun stopDominantLanguageDetectionJob(input: StopDominantLanguageDetectionJobRequest): StopDominantLanguageDetectionJobResponse

    /**
     * Stops an entities detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    public suspend fun stopEntitiesDetectionJob(input: StopEntitiesDetectionJobRequest): StopEntitiesDetectionJobResponse

    /**
     * Stops an events detection job in progress.
     */
    public suspend fun stopEventsDetectionJob(input: StopEventsDetectionJobRequest): StopEventsDetectionJobResponse

    /**
     * Stops a key phrases detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    public suspend fun stopKeyPhrasesDetectionJob(input: StopKeyPhrasesDetectionJobRequest): StopKeyPhrasesDetectionJobResponse

    /**
     * Stops a PII entities detection job in progress.
     */
    public suspend fun stopPiiEntitiesDetectionJob(input: StopPiiEntitiesDetectionJobRequest): StopPiiEntitiesDetectionJobResponse

    /**
     * Stops a sentiment detection job in progress.
     *
     * If the job state is `IN_PROGRESS`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is be stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    public suspend fun stopSentimentDetectionJob(input: StopSentimentDetectionJobRequest): StopSentimentDetectionJobResponse

    /**
     * Stops a targeted sentiment detection job in progress.
     *
     * If the job state is `IN_PROGRESS`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is be stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    public suspend fun stopTargetedSentimentDetectionJob(input: StopTargetedSentimentDetectionJobRequest): StopTargetedSentimentDetectionJobResponse

    /**
     * Stops a document classifier training job while in progress.
     *
     * If the training job state is `TRAINING`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the training job completes before it can be stopped, it is put into the `TRAINED`; otherwise the training job is stopped and put into the `STOPPED` state and the service sends back an HTTP 200 response with an empty HTTP body.
     */
    public suspend fun stopTrainingDocumentClassifier(input: StopTrainingDocumentClassifierRequest): StopTrainingDocumentClassifierResponse

    /**
     * Stops an entity recognizer training job while in progress.
     *
     * If the training job state is `TRAINING`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the training job completes before it can be stopped, it is put into the `TRAINED`; otherwise the training job is stopped and putted into the `STOPPED` state and the service sends back an HTTP 200 response with an empty HTTP body.
     */
    public suspend fun stopTrainingEntityRecognizer(input: StopTrainingEntityRecognizerRequest): StopTrainingEntityRecognizerResponse

    /**
     * Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a specific tag associated with an Amazon Comprehend resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates information about the specified endpoint. For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
     */
    public suspend fun updateEndpoint(input: UpdateEndpointRequest): UpdateEndpointResponse

    /**
     * Update the configuration information for an existing flywheel.
     */
    public suspend fun updateFlywheel(input: UpdateFlywheelRequest): UpdateFlywheelResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ComprehendClient.withConfig(block: ComprehendClient.Config.Builder.() -> Unit): ComprehendClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultComprehendClient(newConfig)
}

/**
 * Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon Comprehend can detect, see [Amazon Comprehend Supported Languages](https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
 */
public suspend inline fun ComprehendClient.batchDetectDominantLanguage(crossinline block: BatchDetectDominantLanguageRequest.Builder.() -> Unit): BatchDetectDominantLanguageResponse = batchDetectDominantLanguage(BatchDetectDominantLanguageRequest.Builder().apply(block).build())

/**
 * Inspects the text of a batch of documents for named entities and returns information about them. For more information about named entities, see [Entities](https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html) in the Comprehend Developer Guide.
 */
public suspend inline fun ComprehendClient.batchDetectEntities(crossinline block: BatchDetectEntitiesRequest.Builder.() -> Unit): BatchDetectEntitiesResponse = batchDetectEntities(BatchDetectEntitiesRequest.Builder().apply(block).build())

/**
 * Detects the key noun phrases found in a batch of documents.
 */
public suspend inline fun ComprehendClient.batchDetectKeyPhrases(crossinline block: BatchDetectKeyPhrasesRequest.Builder.() -> Unit): BatchDetectKeyPhrasesResponse = batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest.Builder().apply(block).build())

/**
 * Inspects a batch of documents and returns an inference of the prevailing sentiment, `POSITIVE`, `NEUTRAL`, `MIXED`, or `NEGATIVE`, in each one.
 */
public suspend inline fun ComprehendClient.batchDetectSentiment(crossinline block: BatchDetectSentimentRequest.Builder.() -> Unit): BatchDetectSentimentResponse = batchDetectSentiment(BatchDetectSentimentRequest.Builder().apply(block).build())

/**
 * Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and returns information about them. For more information, see [Syntax](https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html) in the Comprehend Developer Guide.
 */
public suspend inline fun ComprehendClient.batchDetectSyntax(crossinline block: BatchDetectSyntaxRequest.Builder.() -> Unit): BatchDetectSyntaxResponse = batchDetectSyntax(BatchDetectSyntaxRequest.Builder().apply(block).build())

/**
 * Inspects a batch of documents and returns a sentiment analysis for each entity identified in the documents.
 *
 * For more information about targeted sentiment, see [Targeted sentiment](https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html) in the *Amazon Comprehend Developer Guide*.
 */
public suspend inline fun ComprehendClient.batchDetectTargetedSentiment(crossinline block: BatchDetectTargetedSentimentRequest.Builder.() -> Unit): BatchDetectTargetedSentimentResponse = batchDetectTargetedSentiment(BatchDetectTargetedSentimentRequest.Builder().apply(block).build())

/**
 * Creates a classification request to analyze a single document in real-time. `ClassifyDocument` supports the following model types:
 * + Custom classifier - a custom model that you have created and trained. For input, you can provide plain text, a single-page document (PDF, Word, or image), or Amazon Textract API output. For more information, see [Custom classification](https://docs.aws.amazon.com/comprehend/latest/dg/how-document-classification.html) in the *Amazon Comprehend Developer Guide*.
 * + Prompt safety classifier - Amazon Comprehend provides a pre-trained model for classifying input prompts for generative AI applications. For input, you provide English plain text input. For prompt safety classification, the response includes only the `Classes` field. For more information about prompt safety classifiers, see [Prompt safety classification](https://docs.aws.amazon.com/comprehend/latest/dg/trust-safety.html#prompt-classification) in the *Amazon Comprehend Developer Guide*.
 *
 * If the system detects errors while processing a page in the input document, the API response includes an `Errors` field that describes the errors.
 *
 * If the system detects a document-level error in your input document, the API returns an `InvalidRequestException` error response. For details about this exception, see [ Errors in semi-structured documents](https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html) in the Comprehend Developer Guide.
 */
public suspend inline fun ComprehendClient.classifyDocument(crossinline block: ClassifyDocumentRequest.Builder.() -> Unit): ClassifyDocumentResponse = classifyDocument(ClassifyDocumentRequest.Builder().apply(block).build())

/**
 * Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of identified PII entity types such as name, address, bank account number, or phone number.
 */
public suspend inline fun ComprehendClient.containsPiiEntities(crossinline block: ContainsPiiEntitiesRequest.Builder.() -> Unit): ContainsPiiEntitiesResponse = containsPiiEntities(ContainsPiiEntitiesRequest.Builder().apply(block).build())

/**
 * Creates a dataset to upload training or test data for a model associated with a flywheel. For more information about datasets, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
 */
public suspend inline fun ComprehendClient.createDataset(crossinline block: CreateDatasetRequest.Builder.() -> Unit): CreateDatasetResponse = createDataset(CreateDatasetRequest.Builder().apply(block).build())

/**
 * Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a set of training documents that are labeled with the categories that you want to use. For more information, see [Training classifier models](https://docs.aws.amazon.com/comprehend/latest/dg/training-classifier-model.html) in the Comprehend Developer Guide.
 */
public suspend inline fun ComprehendClient.createDocumentClassifier(crossinline block: CreateDocumentClassifierRequest.Builder.() -> Unit): CreateDocumentClassifierResponse = createDocumentClassifier(CreateDocumentClassifierRequest.Builder().apply(block).build())

/**
 * Creates a model-specific endpoint for synchronous inference for a previously trained custom model For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
 */
public suspend inline fun ComprehendClient.createEndpoint(crossinline block: CreateEndpointRequest.Builder.() -> Unit): CreateEndpointResponse = createEndpoint(CreateEndpointRequest.Builder().apply(block).build())

/**
 * Creates an entity recognizer using submitted files. After your `CreateEntityRecognizer` request is submitted, you can check job status using the `DescribeEntityRecognizer` API.
 */
public suspend inline fun ComprehendClient.createEntityRecognizer(crossinline block: CreateEntityRecognizerRequest.Builder.() -> Unit): CreateEntityRecognizerResponse = createEntityRecognizer(CreateEntityRecognizerRequest.Builder().apply(block).build())

/**
 * A flywheel is an Amazon Web Services resource that orchestrates the ongoing training of a model for custom classification or custom entity recognition. You can create a flywheel to start with an existing trained model, or Comprehend can create and train a new model.
 *
 * When you create the flywheel, Comprehend creates a data lake in your account. The data lake holds the training data and test data for all versions of the model.
 *
 * To use a flywheel with an existing trained model, you specify the active model version. Comprehend copies the model's training data and test data into the flywheel's data lake.
 *
 * To use the flywheel with a new model, you need to provide a dataset for training data (and optional test data) when you create the flywheel.
 *
 * For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
 */
public suspend inline fun ComprehendClient.createFlywheel(crossinline block: CreateFlywheelRequest.Builder.() -> Unit): CreateFlywheelResponse = createFlywheel(CreateFlywheelRequest.Builder().apply(block).build())

/**
 * Deletes a previously created document classifier
 *
 * Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a `ResourceInUseException` will be returned.
 *
 * This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a background job. Once removed, the classifier disappears from your account and is no longer available for use.
 */
public suspend inline fun ComprehendClient.deleteDocumentClassifier(crossinline block: DeleteDocumentClassifierRequest.Builder.() -> Unit): DeleteDocumentClassifierResponse = deleteDocumentClassifier(DeleteDocumentClassifierRequest.Builder().apply(block).build())

/**
 * Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order for the model to be deleted. For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
 */
public suspend inline fun ComprehendClient.deleteEndpoint(crossinline block: DeleteEndpointRequest.Builder.() -> Unit): DeleteEndpointResponse = deleteEndpoint(DeleteEndpointRequest.Builder().apply(block).build())

/**
 * Deletes an entity recognizer.
 *
 * Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a `ResourceInUseException` will be returned.
 *
 * This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a background job. Once removed, the recognizer disappears from your account and is no longer available for use.
 */
public suspend inline fun ComprehendClient.deleteEntityRecognizer(crossinline block: DeleteEntityRecognizerRequest.Builder.() -> Unit): DeleteEntityRecognizerResponse = deleteEntityRecognizer(DeleteEntityRecognizerRequest.Builder().apply(block).build())

/**
 * Deletes a flywheel. When you delete the flywheel, Amazon Comprehend does not delete the data lake or the model associated with the flywheel.
 *
 * For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
 */
public suspend inline fun ComprehendClient.deleteFlywheel(crossinline block: DeleteFlywheelRequest.Builder.() -> Unit): DeleteFlywheelResponse = deleteFlywheel(DeleteFlywheelRequest.Builder().apply(block).build())

/**
 * Deletes a resource-based policy that is attached to a custom model.
 */
public suspend inline fun ComprehendClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Returns information about the dataset that you specify. For more information about datasets, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
 */
public suspend inline fun ComprehendClient.describeDataset(crossinline block: DescribeDatasetRequest.Builder.() -> Unit): DescribeDatasetResponse = describeDataset(DescribeDatasetRequest.Builder().apply(block).build())

/**
 * Gets the properties associated with a document classification job. Use this operation to get the status of a classification job.
 */
public suspend inline fun ComprehendClient.describeDocumentClassificationJob(crossinline block: DescribeDocumentClassificationJobRequest.Builder.() -> Unit): DescribeDocumentClassificationJobResponse = describeDocumentClassificationJob(DescribeDocumentClassificationJobRequest.Builder().apply(block).build())

/**
 * Gets the properties associated with a document classifier.
 */
public suspend inline fun ComprehendClient.describeDocumentClassifier(crossinline block: DescribeDocumentClassifierRequest.Builder.() -> Unit): DescribeDocumentClassifierResponse = describeDocumentClassifier(DescribeDocumentClassifierRequest.Builder().apply(block).build())

/**
 * Gets the properties associated with a dominant language detection job. Use this operation to get the status of a detection job.
 */
public suspend inline fun ComprehendClient.describeDominantLanguageDetectionJob(crossinline block: DescribeDominantLanguageDetectionJobRequest.Builder.() -> Unit): DescribeDominantLanguageDetectionJobResponse = describeDominantLanguageDetectionJob(DescribeDominantLanguageDetectionJobRequest.Builder().apply(block).build())

/**
 * Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint. For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
 */
public suspend inline fun ComprehendClient.describeEndpoint(crossinline block: DescribeEndpointRequest.Builder.() -> Unit): DescribeEndpointResponse = describeEndpoint(DescribeEndpointRequest.Builder().apply(block).build())

/**
 * Gets the properties associated with an entities detection job. Use this operation to get the status of a detection job.
 */
public suspend inline fun ComprehendClient.describeEntitiesDetectionJob(crossinline block: DescribeEntitiesDetectionJobRequest.Builder.() -> Unit): DescribeEntitiesDetectionJobResponse = describeEntitiesDetectionJob(DescribeEntitiesDetectionJobRequest.Builder().apply(block).build())

/**
 * Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer metadata, metrics, and so on.
 */
public suspend inline fun ComprehendClient.describeEntityRecognizer(crossinline block: DescribeEntityRecognizerRequest.Builder.() -> Unit): DescribeEntityRecognizerResponse = describeEntityRecognizer(DescribeEntityRecognizerRequest.Builder().apply(block).build())

/**
 * Gets the status and details of an events detection job.
 */
public suspend inline fun ComprehendClient.describeEventsDetectionJob(crossinline block: DescribeEventsDetectionJobRequest.Builder.() -> Unit): DescribeEventsDetectionJobResponse = describeEventsDetectionJob(DescribeEventsDetectionJobRequest.Builder().apply(block).build())

/**
 * Provides configuration information about the flywheel. For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
 */
public suspend inline fun ComprehendClient.describeFlywheel(crossinline block: DescribeFlywheelRequest.Builder.() -> Unit): DescribeFlywheelResponse = describeFlywheel(DescribeFlywheelRequest.Builder().apply(block).build())

/**
 * Retrieve the configuration properties of a flywheel iteration. For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
 */
public suspend inline fun ComprehendClient.describeFlywheelIteration(crossinline block: DescribeFlywheelIterationRequest.Builder.() -> Unit): DescribeFlywheelIterationResponse = describeFlywheelIteration(DescribeFlywheelIterationRequest.Builder().apply(block).build())

/**
 * Gets the properties associated with a key phrases detection job. Use this operation to get the status of a detection job.
 */
public suspend inline fun ComprehendClient.describeKeyPhrasesDetectionJob(crossinline block: DescribeKeyPhrasesDetectionJobRequest.Builder.() -> Unit): DescribeKeyPhrasesDetectionJobResponse = describeKeyPhrasesDetectionJob(DescribeKeyPhrasesDetectionJobRequest.Builder().apply(block).build())

/**
 * Gets the properties associated with a PII entities detection job. For example, you can use this operation to get the job status.
 */
public suspend inline fun ComprehendClient.describePiiEntitiesDetectionJob(crossinline block: DescribePiiEntitiesDetectionJobRequest.Builder.() -> Unit): DescribePiiEntitiesDetectionJobResponse = describePiiEntitiesDetectionJob(DescribePiiEntitiesDetectionJobRequest.Builder().apply(block).build())

/**
 * Gets the details of a resource-based policy that is attached to a custom model, including the JSON body of the policy.
 */
public suspend inline fun ComprehendClient.describeResourcePolicy(crossinline block: DescribeResourcePolicyRequest.Builder.() -> Unit): DescribeResourcePolicyResponse = describeResourcePolicy(DescribeResourcePolicyRequest.Builder().apply(block).build())

/**
 * Gets the properties associated with a sentiment detection job. Use this operation to get the status of a detection job.
 */
public suspend inline fun ComprehendClient.describeSentimentDetectionJob(crossinline block: DescribeSentimentDetectionJobRequest.Builder.() -> Unit): DescribeSentimentDetectionJobResponse = describeSentimentDetectionJob(DescribeSentimentDetectionJobRequest.Builder().apply(block).build())

/**
 * Gets the properties associated with a targeted sentiment detection job. Use this operation to get the status of the job.
 */
public suspend inline fun ComprehendClient.describeTargetedSentimentDetectionJob(crossinline block: DescribeTargetedSentimentDetectionJobRequest.Builder.() -> Unit): DescribeTargetedSentimentDetectionJobResponse = describeTargetedSentimentDetectionJob(DescribeTargetedSentimentDetectionJobRequest.Builder().apply(block).build())

/**
 * Gets the properties associated with a topic detection job. Use this operation to get the status of a detection job.
 */
public suspend inline fun ComprehendClient.describeTopicsDetectionJob(crossinline block: DescribeTopicsDetectionJobRequest.Builder.() -> Unit): DescribeTopicsDetectionJobResponse = describeTopicsDetectionJob(DescribeTopicsDetectionJobRequest.Builder().apply(block).build())

/**
 * Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect, see [Amazon Comprehend Supported Languages](https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
 */
public suspend inline fun ComprehendClient.detectDominantLanguage(crossinline block: DetectDominantLanguageRequest.Builder.() -> Unit): DetectDominantLanguageResponse = detectDominantLanguage(DetectDominantLanguageRequest.Builder().apply(block).build())

/**
 * Detects named entities in input text when you use the pre-trained model. Detects custom entities if you have a custom entity recognition model.
 *
 *  When detecting named entities using the pre-trained model, use plain text as the input. For more information about named entities, see [Entities](https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html) in the Comprehend Developer Guide.
 *
 * When you use a custom entity recognition model, you can input plain text or you can upload a single-page input document (text, PDF, Word, or image).
 *
 * If the system detects errors while processing a page in the input document, the API response includes an entry in `Errors` for each error.
 *
 * If the system detects a document-level error in your input document, the API returns an `InvalidRequestException` error response. For details about this exception, see [ Errors in semi-structured documents](https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html) in the Comprehend Developer Guide.
 */
public suspend inline fun ComprehendClient.detectEntities(crossinline block: DetectEntitiesRequest.Builder.() -> Unit): DetectEntitiesResponse = detectEntities(DetectEntitiesRequest.Builder().apply(block).build())

/**
 * Detects the key noun phrases found in the text.
 */
public suspend inline fun ComprehendClient.detectKeyPhrases(crossinline block: DetectKeyPhrasesRequest.Builder.() -> Unit): DetectKeyPhrasesResponse = detectKeyPhrases(DetectKeyPhrasesRequest.Builder().apply(block).build())

/**
 * Inspects the input text for entities that contain personally identifiable information (PII) and returns information about them.
 */
public suspend inline fun ComprehendClient.detectPiiEntities(crossinline block: DetectPiiEntitiesRequest.Builder.() -> Unit): DetectPiiEntitiesResponse = detectPiiEntities(DetectPiiEntitiesRequest.Builder().apply(block).build())

/**
 * Inspects text and returns an inference of the prevailing sentiment (`POSITIVE`, `NEUTRAL`, `MIXED`, or `NEGATIVE`).
 */
public suspend inline fun ComprehendClient.detectSentiment(crossinline block: DetectSentimentRequest.Builder.() -> Unit): DetectSentimentResponse = detectSentiment(DetectSentimentRequest.Builder().apply(block).build())

/**
 * Inspects text for syntax and the part of speech of words in the document. For more information, see [Syntax](https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html) in the Comprehend Developer Guide.
 */
public suspend inline fun ComprehendClient.detectSyntax(crossinline block: DetectSyntaxRequest.Builder.() -> Unit): DetectSyntaxResponse = detectSyntax(DetectSyntaxRequest.Builder().apply(block).build())

/**
 * Inspects the input text and returns a sentiment analysis for each entity identified in the text.
 *
 * For more information about targeted sentiment, see [Targeted sentiment](https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html) in the *Amazon Comprehend Developer Guide*.
 */
public suspend inline fun ComprehendClient.detectTargetedSentiment(crossinline block: DetectTargetedSentimentRequest.Builder.() -> Unit): DetectTargetedSentimentResponse = detectTargetedSentiment(DetectTargetedSentimentRequest.Builder().apply(block).build())

/**
 * Performs toxicity analysis on the list of text strings that you provide as input. The API response contains a results list that matches the size of the input list. For more information about toxicity detection, see [Toxicity detection](https://docs.aws.amazon.com/comprehend/latest/dg/toxicity-detection.html) in the *Amazon Comprehend Developer Guide*.
 */
public suspend inline fun ComprehendClient.detectToxicContent(crossinline block: DetectToxicContentRequest.Builder.() -> Unit): DetectToxicContentResponse = detectToxicContent(DetectToxicContentRequest.Builder().apply(block).build())

/**
 * Creates a new custom model that replicates a source custom model that you import. The source model can be in your Amazon Web Services account or another one.
 *
 * If the source model is in another Amazon Web Services account, then it must have a resource-based policy that authorizes you to import it.
 *
 * The source model must be in the same Amazon Web Services Region that you're using when you import. You can't import a model that's in a different Region.
 */
public suspend inline fun ComprehendClient.importModel(crossinline block: ImportModelRequest.Builder.() -> Unit): ImportModelResponse = importModel(ImportModelRequest.Builder().apply(block).build())

/**
 * List the datasets that you have configured in this Region. For more information about datasets, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
 */
public suspend inline fun ComprehendClient.listDatasets(crossinline block: ListDatasetsRequest.Builder.() -> Unit): ListDatasetsResponse = listDatasets(ListDatasetsRequest.Builder().apply(block).build())

/**
 * Gets a list of the documentation classification jobs that you have submitted.
 */
public suspend inline fun ComprehendClient.listDocumentClassificationJobs(crossinline block: ListDocumentClassificationJobsRequest.Builder.() -> Unit): ListDocumentClassificationJobsResponse = listDocumentClassificationJobs(ListDocumentClassificationJobsRequest.Builder().apply(block).build())

/**
 * Gets a list of summaries of the document classifiers that you have created
 */
public suspend inline fun ComprehendClient.listDocumentClassifierSummaries(crossinline block: ListDocumentClassifierSummariesRequest.Builder.() -> Unit): ListDocumentClassifierSummariesResponse = listDocumentClassifierSummaries(ListDocumentClassifierSummariesRequest.Builder().apply(block).build())

/**
 * Gets a list of the document classifiers that you have created.
 */
public suspend inline fun ComprehendClient.listDocumentClassifiers(crossinline block: ListDocumentClassifiersRequest.Builder.() -> Unit): ListDocumentClassifiersResponse = listDocumentClassifiers(ListDocumentClassifiersRequest.Builder().apply(block).build())

/**
 * Gets a list of the dominant language detection jobs that you have submitted.
 */
public suspend inline fun ComprehendClient.listDominantLanguageDetectionJobs(crossinline block: ListDominantLanguageDetectionJobsRequest.Builder.() -> Unit): ListDominantLanguageDetectionJobsResponse = listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest.Builder().apply(block).build())

/**
 * Gets a list of all existing endpoints that you've created. For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
 */
public suspend inline fun ComprehendClient.listEndpoints(crossinline block: ListEndpointsRequest.Builder.() -> Unit): ListEndpointsResponse = listEndpoints(ListEndpointsRequest.Builder().apply(block).build())

/**
 * Gets a list of the entity detection jobs that you have submitted.
 */
public suspend inline fun ComprehendClient.listEntitiesDetectionJobs(crossinline block: ListEntitiesDetectionJobsRequest.Builder.() -> Unit): ListEntitiesDetectionJobsResponse = listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest.Builder().apply(block).build())

/**
 * Gets a list of summaries for the entity recognizers that you have created.
 */
public suspend inline fun ComprehendClient.listEntityRecognizerSummaries(crossinline block: ListEntityRecognizerSummariesRequest.Builder.() -> Unit): ListEntityRecognizerSummariesResponse = listEntityRecognizerSummaries(ListEntityRecognizerSummariesRequest.Builder().apply(block).build())

/**
 * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
 *
 * The results of this list are not in any particular order. Please get the list and sort locally if needed.
 */
public suspend inline fun ComprehendClient.listEntityRecognizers(crossinline block: ListEntityRecognizersRequest.Builder.() -> Unit): ListEntityRecognizersResponse = listEntityRecognizers(ListEntityRecognizersRequest.Builder().apply(block).build())

/**
 * Gets a list of the events detection jobs that you have submitted.
 */
public suspend inline fun ComprehendClient.listEventsDetectionJobs(crossinline block: ListEventsDetectionJobsRequest.Builder.() -> Unit): ListEventsDetectionJobsResponse = listEventsDetectionJobs(ListEventsDetectionJobsRequest.Builder().apply(block).build())

/**
 * Information about the history of a flywheel iteration. For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
 */
public suspend inline fun ComprehendClient.listFlywheelIterationHistory(crossinline block: ListFlywheelIterationHistoryRequest.Builder.() -> Unit): ListFlywheelIterationHistoryResponse = listFlywheelIterationHistory(ListFlywheelIterationHistoryRequest.Builder().apply(block).build())

/**
 * Gets a list of the flywheels that you have created.
 */
public suspend inline fun ComprehendClient.listFlywheels(crossinline block: ListFlywheelsRequest.Builder.() -> Unit): ListFlywheelsResponse = listFlywheels(ListFlywheelsRequest.Builder().apply(block).build())

/**
 * Get a list of key phrase detection jobs that you have submitted.
 */
public suspend inline fun ComprehendClient.listKeyPhrasesDetectionJobs(crossinline block: ListKeyPhrasesDetectionJobsRequest.Builder.() -> Unit): ListKeyPhrasesDetectionJobsResponse = listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest.Builder().apply(block).build())

/**
 * Gets a list of the PII entity detection jobs that you have submitted.
 */
public suspend inline fun ComprehendClient.listPiiEntitiesDetectionJobs(crossinline block: ListPiiEntitiesDetectionJobsRequest.Builder.() -> Unit): ListPiiEntitiesDetectionJobsResponse = listPiiEntitiesDetectionJobs(ListPiiEntitiesDetectionJobsRequest.Builder().apply(block).build())

/**
 * Gets a list of sentiment detection jobs that you have submitted.
 */
public suspend inline fun ComprehendClient.listSentimentDetectionJobs(crossinline block: ListSentimentDetectionJobsRequest.Builder.() -> Unit): ListSentimentDetectionJobsResponse = listSentimentDetectionJobs(ListSentimentDetectionJobsRequest.Builder().apply(block).build())

/**
 * Lists all tags associated with a given Amazon Comprehend resource.
 */
public suspend inline fun ComprehendClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Gets a list of targeted sentiment detection jobs that you have submitted.
 */
public suspend inline fun ComprehendClient.listTargetedSentimentDetectionJobs(crossinline block: ListTargetedSentimentDetectionJobsRequest.Builder.() -> Unit): ListTargetedSentimentDetectionJobsResponse = listTargetedSentimentDetectionJobs(ListTargetedSentimentDetectionJobsRequest.Builder().apply(block).build())

/**
 * Gets a list of the topic detection jobs that you have submitted.
 */
public suspend inline fun ComprehendClient.listTopicsDetectionJobs(crossinline block: ListTopicsDetectionJobsRequest.Builder.() -> Unit): ListTopicsDetectionJobsResponse = listTopicsDetectionJobs(ListTopicsDetectionJobsRequest.Builder().apply(block).build())

/**
 * Attaches a resource-based policy to a custom model. You can use this policy to authorize an entity in another Amazon Web Services account to import the custom model, which replicates it in Amazon Comprehend in their account.
 */
public suspend inline fun ComprehendClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Starts an asynchronous document classification job using a custom classification model. Use the `DescribeDocumentClassificationJob` operation to track the progress of the job.
 */
public suspend inline fun ComprehendClient.startDocumentClassificationJob(crossinline block: StartDocumentClassificationJobRequest.Builder.() -> Unit): StartDocumentClassificationJobResponse = startDocumentClassificationJob(StartDocumentClassificationJobRequest.Builder().apply(block).build())

/**
 * Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track the status of a job.
 */
public suspend inline fun ComprehendClient.startDominantLanguageDetectionJob(crossinline block: StartDominantLanguageDetectionJobRequest.Builder.() -> Unit): StartDominantLanguageDetectionJobResponse = startDominantLanguageDetectionJob(StartDominantLanguageDetectionJobRequest.Builder().apply(block).build())

/**
 * Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status of a job.
 *
 * This API can be used for either standard entity detection or custom entity recognition. In order to be used for custom entity recognition, the optional `EntityRecognizerArn` must be used in order to provide access to the recognizer being used to detect the custom entity.
 */
public suspend inline fun ComprehendClient.startEntitiesDetectionJob(crossinline block: StartEntitiesDetectionJobRequest.Builder.() -> Unit): StartEntitiesDetectionJobResponse = startEntitiesDetectionJob(StartEntitiesDetectionJobRequest.Builder().apply(block).build())

/**
 * Starts an asynchronous event detection job for a collection of documents.
 */
public suspend inline fun ComprehendClient.startEventsDetectionJob(crossinline block: StartEventsDetectionJobRequest.Builder.() -> Unit): StartEventsDetectionJobResponse = startEventsDetectionJob(StartEventsDetectionJobRequest.Builder().apply(block).build())

/**
 * Start the flywheel iteration.This operation uses any new datasets to train a new model version. For more information about flywheels, see [ Flywheel overview](https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in the *Amazon Comprehend Developer Guide*.
 */
public suspend inline fun ComprehendClient.startFlywheelIteration(crossinline block: StartFlywheelIterationRequest.Builder.() -> Unit): StartFlywheelIterationResponse = startFlywheelIteration(StartFlywheelIterationRequest.Builder().apply(block).build())

/**
 * Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the status of a job.
 */
public suspend inline fun ComprehendClient.startKeyPhrasesDetectionJob(crossinline block: StartKeyPhrasesDetectionJobRequest.Builder.() -> Unit): StartKeyPhrasesDetectionJobResponse = startKeyPhrasesDetectionJob(StartKeyPhrasesDetectionJobRequest.Builder().apply(block).build())

/**
 * Starts an asynchronous PII entity detection job for a collection of documents.
 */
public suspend inline fun ComprehendClient.startPiiEntitiesDetectionJob(crossinline block: StartPiiEntitiesDetectionJobRequest.Builder.() -> Unit): StartPiiEntitiesDetectionJobResponse = startPiiEntitiesDetectionJob(StartPiiEntitiesDetectionJobRequest.Builder().apply(block).build())

/**
 * Starts an asynchronous sentiment detection job for a collection of documents. Use the operation to track the status of a job.
 */
public suspend inline fun ComprehendClient.startSentimentDetectionJob(crossinline block: StartSentimentDetectionJobRequest.Builder.() -> Unit): StartSentimentDetectionJobResponse = startSentimentDetectionJob(StartSentimentDetectionJobRequest.Builder().apply(block).build())

/**
 * Starts an asynchronous targeted sentiment detection job for a collection of documents. Use the `DescribeTargetedSentimentDetectionJob` operation to track the status of a job.
 */
public suspend inline fun ComprehendClient.startTargetedSentimentDetectionJob(crossinline block: StartTargetedSentimentDetectionJobRequest.Builder.() -> Unit): StartTargetedSentimentDetectionJobResponse = startTargetedSentimentDetectionJob(StartTargetedSentimentDetectionJobRequest.Builder().apply(block).build())

/**
 * Starts an asynchronous topic detection job. Use the `DescribeTopicDetectionJob` operation to track the status of a job.
 */
public suspend inline fun ComprehendClient.startTopicsDetectionJob(crossinline block: StartTopicsDetectionJobRequest.Builder.() -> Unit): StartTopicsDetectionJobResponse = startTopicsDetectionJob(StartTopicsDetectionJobRequest.Builder().apply(block).build())

/**
 * Stops a dominant language detection job in progress.
 *
 * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
 *
 * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
 *
 * When a job is stopped, any documents already processed are written to the output location.
 */
public suspend inline fun ComprehendClient.stopDominantLanguageDetectionJob(crossinline block: StopDominantLanguageDetectionJobRequest.Builder.() -> Unit): StopDominantLanguageDetectionJobResponse = stopDominantLanguageDetectionJob(StopDominantLanguageDetectionJobRequest.Builder().apply(block).build())

/**
 * Stops an entities detection job in progress.
 *
 * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
 *
 * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
 *
 * When a job is stopped, any documents already processed are written to the output location.
 */
public suspend inline fun ComprehendClient.stopEntitiesDetectionJob(crossinline block: StopEntitiesDetectionJobRequest.Builder.() -> Unit): StopEntitiesDetectionJobResponse = stopEntitiesDetectionJob(StopEntitiesDetectionJobRequest.Builder().apply(block).build())

/**
 * Stops an events detection job in progress.
 */
public suspend inline fun ComprehendClient.stopEventsDetectionJob(crossinline block: StopEventsDetectionJobRequest.Builder.() -> Unit): StopEventsDetectionJobResponse = stopEventsDetectionJob(StopEventsDetectionJobRequest.Builder().apply(block).build())

/**
 * Stops a key phrases detection job in progress.
 *
 * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
 *
 * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
 *
 * When a job is stopped, any documents already processed are written to the output location.
 */
public suspend inline fun ComprehendClient.stopKeyPhrasesDetectionJob(crossinline block: StopKeyPhrasesDetectionJobRequest.Builder.() -> Unit): StopKeyPhrasesDetectionJobResponse = stopKeyPhrasesDetectionJob(StopKeyPhrasesDetectionJobRequest.Builder().apply(block).build())

/**
 * Stops a PII entities detection job in progress.
 */
public suspend inline fun ComprehendClient.stopPiiEntitiesDetectionJob(crossinline block: StopPiiEntitiesDetectionJobRequest.Builder.() -> Unit): StopPiiEntitiesDetectionJobResponse = stopPiiEntitiesDetectionJob(StopPiiEntitiesDetectionJobRequest.Builder().apply(block).build())

/**
 * Stops a sentiment detection job in progress.
 *
 * If the job state is `IN_PROGRESS`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is be stopped and put into the `STOPPED` state.
 *
 * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
 *
 * When a job is stopped, any documents already processed are written to the output location.
 */
public suspend inline fun ComprehendClient.stopSentimentDetectionJob(crossinline block: StopSentimentDetectionJobRequest.Builder.() -> Unit): StopSentimentDetectionJobResponse = stopSentimentDetectionJob(StopSentimentDetectionJobRequest.Builder().apply(block).build())

/**
 * Stops a targeted sentiment detection job in progress.
 *
 * If the job state is `IN_PROGRESS`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is be stopped and put into the `STOPPED` state.
 *
 * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
 *
 * When a job is stopped, any documents already processed are written to the output location.
 */
public suspend inline fun ComprehendClient.stopTargetedSentimentDetectionJob(crossinline block: StopTargetedSentimentDetectionJobRequest.Builder.() -> Unit): StopTargetedSentimentDetectionJobResponse = stopTargetedSentimentDetectionJob(StopTargetedSentimentDetectionJobRequest.Builder().apply(block).build())

/**
 * Stops a document classifier training job while in progress.
 *
 * If the training job state is `TRAINING`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the training job completes before it can be stopped, it is put into the `TRAINED`; otherwise the training job is stopped and put into the `STOPPED` state and the service sends back an HTTP 200 response with an empty HTTP body.
 */
public suspend inline fun ComprehendClient.stopTrainingDocumentClassifier(crossinline block: StopTrainingDocumentClassifierRequest.Builder.() -> Unit): StopTrainingDocumentClassifierResponse = stopTrainingDocumentClassifier(StopTrainingDocumentClassifierRequest.Builder().apply(block).build())

/**
 * Stops an entity recognizer training job while in progress.
 *
 * If the training job state is `TRAINING`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the training job completes before it can be stopped, it is put into the `TRAINED`; otherwise the training job is stopped and putted into the `STOPPED` state and the service sends back an HTTP 200 response with an empty HTTP body.
 */
public suspend inline fun ComprehendClient.stopTrainingEntityRecognizer(crossinline block: StopTrainingEntityRecognizerRequest.Builder.() -> Unit): StopTrainingEntityRecognizerResponse = stopTrainingEntityRecognizer(StopTrainingEntityRecognizerRequest.Builder().apply(block).build())

/**
 * Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
 */
public suspend inline fun ComprehendClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a specific tag associated with an Amazon Comprehend resource.
 */
public suspend inline fun ComprehendClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates information about the specified endpoint. For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
 */
public suspend inline fun ComprehendClient.updateEndpoint(crossinline block: UpdateEndpointRequest.Builder.() -> Unit): UpdateEndpointResponse = updateEndpoint(UpdateEndpointRequest.Builder().apply(block).build())

/**
 * Update the configuration information for an existing flywheel.
 */
public suspend inline fun ComprehendClient.updateFlywheel(crossinline block: UpdateFlywheelRequest.Builder.() -> Unit): UpdateFlywheelResponse = updateFlywheel(UpdateFlywheelRequest.Builder().apply(block).build())
