// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.serde

import aws.sdk.kotlin.services.comprehend.model.BatchDetectTargetedSentimentItemResult
import aws.sdk.kotlin.services.comprehend.model.BatchDetectTargetedSentimentResponse
import aws.sdk.kotlin.services.comprehend.model.BatchItemError
import aws.sdk.kotlin.services.comprehend.model.ComprehendException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchDetectTargetedSentimentOperationDeserializer: HttpDeserializer.NonStreaming<BatchDetectTargetedSentimentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchDetectTargetedSentimentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchDetectTargetedSentimentError(context, call, payload)
        }
        val builder = BatchDetectTargetedSentimentResponse.Builder()

        if (payload != null) {
            deserializeBatchDetectTargetedSentimentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchDetectTargetedSentimentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ComprehendException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BatchSizeLimitExceededException" -> BatchSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedLanguageException" -> UnsupportedLanguageExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TextSizeLimitExceededException" -> TextSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ComprehendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchDetectTargetedSentimentOperationBody(builder: BatchDetectTargetedSentimentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ErrorList"))
    val RESULTLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResultList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORLIST_DESCRIPTOR)
        field(RESULTLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORLIST_DESCRIPTOR.index -> builder.errorList =
                    deserializer.deserializeList(ERRORLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchItemError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchItemErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESULTLIST_DESCRIPTOR.index -> builder.resultList =
                    deserializer.deserializeList(RESULTLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchDetectTargetedSentimentItemResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchDetectTargetedSentimentItemResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
