// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides configuration parameters to override the default actions for extracting text from PDF documents and image files.
 *
 *  By default, Amazon Comprehend performs the following actions to extract text from files, based on the input file type:
 * + **Word files** - Amazon Comprehend parser extracts the text.
 * + **Digital PDF files** - Amazon Comprehend parser extracts the text.
 * + **Image files and scanned PDF files** - Amazon Comprehend uses the Amazon Textract `DetectDocumentText` API to extract the text.
 *
 * `DocumentReaderConfig` does not apply to plain text files or Word files.
 *
 *  For image files and PDF documents, you can override these default actions using the fields listed below. For more information, see [ Setting text extraction options](https://docs.aws.amazon.com/comprehend/latest/dg/idp-set-textract-options.html) in the Comprehend Developer Guide.
 */
public class DocumentReaderConfig private constructor(builder: Builder) {
    /**
     * This field defines the Amazon Textract API operation that Amazon Comprehend uses to extract text from PDF files and image files. Enter one of the following values:
     * + `TEXTRACT_DETECT_DOCUMENT_TEXT` - The Amazon Comprehend service uses the `DetectDocumentText` API operation.
     * + `TEXTRACT_ANALYZE_DOCUMENT` - The Amazon Comprehend service uses the `AnalyzeDocument` API operation.
     */
    public val documentReadAction: aws.sdk.kotlin.services.comprehend.model.DocumentReadAction = requireNotNull(builder.documentReadAction) { "A non-null value must be provided for documentReadAction" }
    /**
     * Determines the text extraction actions for PDF files. Enter one of the following values:
     * + `SERVICE_DEFAULT` - use the Amazon Comprehend service defaults for PDF files.
     * + `FORCE_DOCUMENT_READ_ACTION` - Amazon Comprehend uses the Textract API specified by DocumentReadAction for all PDF files, including digital PDF files.
     */
    public val documentReadMode: aws.sdk.kotlin.services.comprehend.model.DocumentReadMode? = builder.documentReadMode
    /**
     * Specifies the type of Amazon Textract features to apply. If you chose `TEXTRACT_ANALYZE_DOCUMENT` as the read action, you must specify one or both of the following values:
     * + `TABLES` - Returns additional information about any tables that are detected in the input document.
     * + `FORMS` - Returns additional information about any forms that are detected in the input document.
     */
    public val featureTypes: List<DocumentReadFeatureTypes>? = builder.featureTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentReaderConfig(")
        append("documentReadAction=$documentReadAction,")
        append("documentReadMode=$documentReadMode,")
        append("featureTypes=$featureTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentReadAction.hashCode()
        result = 31 * result + (documentReadMode?.hashCode() ?: 0)
        result = 31 * result + (featureTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentReaderConfig

        if (documentReadAction != other.documentReadAction) return false
        if (documentReadMode != other.documentReadMode) return false
        if (featureTypes != other.featureTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This field defines the Amazon Textract API operation that Amazon Comprehend uses to extract text from PDF files and image files. Enter one of the following values:
         * + `TEXTRACT_DETECT_DOCUMENT_TEXT` - The Amazon Comprehend service uses the `DetectDocumentText` API operation.
         * + `TEXTRACT_ANALYZE_DOCUMENT` - The Amazon Comprehend service uses the `AnalyzeDocument` API operation.
         */
        public var documentReadAction: aws.sdk.kotlin.services.comprehend.model.DocumentReadAction? = null
        /**
         * Determines the text extraction actions for PDF files. Enter one of the following values:
         * + `SERVICE_DEFAULT` - use the Amazon Comprehend service defaults for PDF files.
         * + `FORCE_DOCUMENT_READ_ACTION` - Amazon Comprehend uses the Textract API specified by DocumentReadAction for all PDF files, including digital PDF files.
         */
        public var documentReadMode: aws.sdk.kotlin.services.comprehend.model.DocumentReadMode? = null
        /**
         * Specifies the type of Amazon Textract features to apply. If you chose `TEXTRACT_ANALYZE_DOCUMENT` as the read action, you must specify one or both of the following values:
         * + `TABLES` - Returns additional information about any tables that are detected in the input document.
         * + `FORMS` - Returns additional information about any forms that are detected in the input document.
         */
        public var featureTypes: List<DocumentReadFeatureTypes>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig) : this() {
            this.documentReadAction = x.documentReadAction
            this.documentReadMode = x.documentReadMode
            this.featureTypes = x.featureTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig = DocumentReaderConfig(this)

        internal fun correctErrors(): Builder {
            if (documentReadAction == null) documentReadAction = DocumentReadAction.SdkUnknown("no value provided")
            return this
        }
    }
}
