// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Properties associated with the dataset.
 */
public class DatasetProperties private constructor(builder: Builder) {
    /**
     * Creation time of the dataset.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The ARN of the dataset.
     */
    public val datasetArn: kotlin.String? = builder.datasetArn
    /**
     * The name of the dataset.
     */
    public val datasetName: kotlin.String? = builder.datasetName
    /**
     * The S3 URI where the dataset is stored.
     */
    public val datasetS3Uri: kotlin.String? = builder.datasetS3Uri
    /**
     * The dataset type (training data or test data).
     */
    public val datasetType: aws.sdk.kotlin.services.comprehend.model.DatasetType? = builder.datasetType
    /**
     * Description of the dataset.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Time when the data from the dataset becomes available in the data lake.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * A description of the status of the dataset.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The number of documents in the dataset.
     */
    public val numberOfDocuments: kotlin.Long? = builder.numberOfDocuments
    /**
     * The dataset status. While the system creates the dataset, the status is `CREATING`. When the dataset is ready to use, the status changes to `COMPLETED`.
     */
    public val status: aws.sdk.kotlin.services.comprehend.model.DatasetStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.DatasetProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetProperties(")
        append("creationTime=$creationTime,")
        append("datasetArn=$datasetArn,")
        append("datasetName=$datasetName,")
        append("datasetS3Uri=$datasetS3Uri,")
        append("datasetType=$datasetType,")
        append("description=$description,")
        append("endTime=$endTime,")
        append("message=$message,")
        append("numberOfDocuments=$numberOfDocuments,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (datasetArn?.hashCode() ?: 0)
        result = 31 * result + (datasetName?.hashCode() ?: 0)
        result = 31 * result + (datasetS3Uri?.hashCode() ?: 0)
        result = 31 * result + (datasetType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (numberOfDocuments?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetProperties

        if (creationTime != other.creationTime) return false
        if (datasetArn != other.datasetArn) return false
        if (datasetName != other.datasetName) return false
        if (datasetS3Uri != other.datasetS3Uri) return false
        if (datasetType != other.datasetType) return false
        if (description != other.description) return false
        if (endTime != other.endTime) return false
        if (message != other.message) return false
        if (numberOfDocuments != other.numberOfDocuments) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.DatasetProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Creation time of the dataset.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the dataset.
         */
        public var datasetArn: kotlin.String? = null
        /**
         * The name of the dataset.
         */
        public var datasetName: kotlin.String? = null
        /**
         * The S3 URI where the dataset is stored.
         */
        public var datasetS3Uri: kotlin.String? = null
        /**
         * The dataset type (training data or test data).
         */
        public var datasetType: aws.sdk.kotlin.services.comprehend.model.DatasetType? = null
        /**
         * Description of the dataset.
         */
        public var description: kotlin.String? = null
        /**
         * Time when the data from the dataset becomes available in the data lake.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the status of the dataset.
         */
        public var message: kotlin.String? = null
        /**
         * The number of documents in the dataset.
         */
        public var numberOfDocuments: kotlin.Long? = null
        /**
         * The dataset status. While the system creates the dataset, the status is `CREATING`. When the dataset is ready to use, the status changes to `COMPLETED`.
         */
        public var status: aws.sdk.kotlin.services.comprehend.model.DatasetStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.DatasetProperties) : this() {
            this.creationTime = x.creationTime
            this.datasetArn = x.datasetArn
            this.datasetName = x.datasetName
            this.datasetS3Uri = x.datasetS3Uri
            this.datasetType = x.datasetType
            this.description = x.description
            this.endTime = x.endTime
            this.message = x.message
            this.numberOfDocuments = x.numberOfDocuments
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.DatasetProperties = DatasetProperties(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
