// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ClassifyDocumentResponse private constructor(builder: Builder) {
    /**
     * The classes used by the document being analyzed. These are used for models trained in multi-class mode. Individual classes are mutually exclusive and each document is expected to have only a single class assigned to it. For example, an animal can be a dog or a cat, but not both at the same time.
     *
     * For prompt safety classification, the response includes only two classes (SAFE_PROMPT and UNSAFE_PROMPT), along with a confidence score for each class. The value range of the score is zero to one, where one is the highest confidence.
     */
    public val classes: List<DocumentClass>? = builder.classes
    /**
     * Extraction information about the document. This field is present in the response only if your request includes the `Byte` parameter.
     */
    public val documentMetadata: aws.sdk.kotlin.services.comprehend.model.DocumentMetadata? = builder.documentMetadata
    /**
     * The document type for each page in the input document. This field is present in the response only if your request includes the `Byte` parameter.
     */
    public val documentType: List<DocumentTypeListItem>? = builder.documentType
    /**
     * Page-level errors that the system detected while processing the input document. The field is empty if the system encountered no errors.
     */
    public val errors: List<ErrorsListItem>? = builder.errors
    /**
     * The labels used in the document being analyzed. These are used for multi-label trained models. Individual labels represent different categories that are related in some manner and are not mutually exclusive. For example, a movie can be just an action movie, or it can be an action movie, a science fiction movie, and a comedy, all at the same time.
     */
    public val labels: List<DocumentLabel>? = builder.labels
    /**
     * Warnings detected while processing the input document. The response includes a warning if there is a mismatch between the input document type and the model type associated with the endpoint that you specified. The response can also include warnings for individual pages that have a mismatch.
     *
     * The field is empty if the system generated no warnings.
     */
    public val warnings: List<WarningsListItem>? = builder.warnings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.ClassifyDocumentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClassifyDocumentResponse(")
        append("*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = classes?.hashCode() ?: 0
        result = 31 * result + (documentMetadata?.hashCode() ?: 0)
        result = 31 * result + (documentType?.hashCode() ?: 0)
        result = 31 * result + (errors?.hashCode() ?: 0)
        result = 31 * result + (labels?.hashCode() ?: 0)
        result = 31 * result + (warnings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClassifyDocumentResponse

        if (classes != other.classes) return false
        if (documentMetadata != other.documentMetadata) return false
        if (documentType != other.documentType) return false
        if (errors != other.errors) return false
        if (labels != other.labels) return false
        if (warnings != other.warnings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.ClassifyDocumentResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The classes used by the document being analyzed. These are used for models trained in multi-class mode. Individual classes are mutually exclusive and each document is expected to have only a single class assigned to it. For example, an animal can be a dog or a cat, but not both at the same time.
         *
         * For prompt safety classification, the response includes only two classes (SAFE_PROMPT and UNSAFE_PROMPT), along with a confidence score for each class. The value range of the score is zero to one, where one is the highest confidence.
         */
        public var classes: List<DocumentClass>? = null
        /**
         * Extraction information about the document. This field is present in the response only if your request includes the `Byte` parameter.
         */
        public var documentMetadata: aws.sdk.kotlin.services.comprehend.model.DocumentMetadata? = null
        /**
         * The document type for each page in the input document. This field is present in the response only if your request includes the `Byte` parameter.
         */
        public var documentType: List<DocumentTypeListItem>? = null
        /**
         * Page-level errors that the system detected while processing the input document. The field is empty if the system encountered no errors.
         */
        public var errors: List<ErrorsListItem>? = null
        /**
         * The labels used in the document being analyzed. These are used for multi-label trained models. Individual labels represent different categories that are related in some manner and are not mutually exclusive. For example, a movie can be just an action movie, or it can be an action movie, a science fiction movie, and a comedy, all at the same time.
         */
        public var labels: List<DocumentLabel>? = null
        /**
         * Warnings detected while processing the input document. The response includes a warning if there is a mismatch between the input document type and the model type associated with the endpoint that you specified. The response can also include warnings for individual pages that have a mismatch.
         *
         * The field is empty if the system generated no warnings.
         */
        public var warnings: List<WarningsListItem>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.ClassifyDocumentResponse) : this() {
            this.classes = x.classes
            this.documentMetadata = x.documentMetadata
            this.documentType = x.documentType
            this.errors = x.errors
            this.labels = x.labels
            this.warnings = x.warnings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.ClassifyDocumentResponse = ClassifyDocumentResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.DocumentMetadata] inside the given [block]
         */
        public fun documentMetadata(block: aws.sdk.kotlin.services.comprehend.model.DocumentMetadata.Builder.() -> kotlin.Unit) {
            this.documentMetadata = aws.sdk.kotlin.services.comprehend.model.DocumentMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
