// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The bounding box around the detected page or around an element on a document page. The left (x-coordinate) and top (y-coordinate) are coordinates that represent the top and left sides of the bounding box. Note that the upper-left corner of the image is the origin (0,0).
 *
 * For additional information, see [BoundingBox](https://docs.aws.amazon.com/textract/latest/dg/API_BoundingBox.html) in the Amazon Textract API reference.
 */
public class BoundingBox private constructor(builder: Builder) {
    /**
     * The height of the bounding box as a ratio of the overall document page height.
     */
    public val height: kotlin.Float? = builder.height
    /**
     * The left coordinate of the bounding box as a ratio of overall document page width.
     */
    public val left: kotlin.Float? = builder.left
    /**
     * The top coordinate of the bounding box as a ratio of overall document page height.
     */
    public val top: kotlin.Float? = builder.top
    /**
     * The width of the bounding box as a ratio of the overall document page width.
     */
    public val width: kotlin.Float? = builder.width

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.BoundingBox = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BoundingBox(")
        append("height=$height,")
        append("left=$left,")
        append("top=$top,")
        append("width=$width")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = height?.hashCode() ?: 0
        result = 31 * result + (left?.hashCode() ?: 0)
        result = 31 * result + (top?.hashCode() ?: 0)
        result = 31 * result + (width?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BoundingBox

        if (!(height?.equals(other.height) ?: (other.height == null))) return false
        if (!(left?.equals(other.left) ?: (other.left == null))) return false
        if (!(top?.equals(other.top) ?: (other.top == null))) return false
        if (!(width?.equals(other.width) ?: (other.width == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.BoundingBox = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The height of the bounding box as a ratio of the overall document page height.
         */
        public var height: kotlin.Float? = null
        /**
         * The left coordinate of the bounding box as a ratio of overall document page width.
         */
        public var left: kotlin.Float? = null
        /**
         * The top coordinate of the bounding box as a ratio of overall document page height.
         */
        public var top: kotlin.Float? = null
        /**
         * The width of the bounding box as a ratio of the overall document page width.
         */
        public var width: kotlin.Float? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.BoundingBox) : this() {
            this.height = x.height
            this.left = x.left
            this.top = x.top
            this.width = x.width
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.BoundingBox = BoundingBox(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
