// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An augmented manifest file that provides training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
 */
public class AugmentedManifestsListItem private constructor(builder: Builder) {
    /**
     * The S3 prefix to the annotation files that are referred in the augmented manifest file.
     */
    public val annotationDataS3Uri: kotlin.String? = builder.annotationDataS3Uri
    /**
     * The JSON attribute that contains the annotations for your training documents. The number of attribute names that you specify depends on whether your augmented manifest file is the output of a single labeling job or a chained labeling job.
     *
     * If your file is the output of a single labeling job, specify the LabelAttributeName key that was used when the job was created in Ground Truth.
     *
     * If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from an individual job.
     */
    public val attributeNames: List<String> = requireNotNull(builder.attributeNames) { "A non-null value must be provided for attributeNames" }
    /**
     * The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don't specify, the default is PlainTextDocument.
     * + `PLAIN_TEXT_DOCUMENT` A document type that represents any unicode text that is encoded in UTF-8.
     * + `SEMI_STRUCTURED_DOCUMENT` A document type with positional and structural context, like a PDF. For training with Amazon Comprehend, only PDFs are supported. For inference, Amazon Comprehend support PDFs, DOCX and TXT.
     */
    public val documentType: aws.sdk.kotlin.services.comprehend.model.AugmentedManifestsDocumentTypeFormat? = builder.documentType
    /**
     * The Amazon S3 location of the augmented manifest file.
     */
    public val s3Uri: kotlin.String = requireNotNull(builder.s3Uri) { "A non-null value must be provided for s3Uri" }
    /**
     * The S3 prefix to the source files (PDFs) that are referred to in the augmented manifest file.
     */
    public val sourceDocumentsS3Uri: kotlin.String? = builder.sourceDocumentsS3Uri
    /**
     * The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If you don't specify, the default is train.
     *
     * TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.
     *
     *  TEST - all of the documents in the manifest will be used for testing.
     */
    public val split: aws.sdk.kotlin.services.comprehend.model.Split? = builder.split

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.AugmentedManifestsListItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AugmentedManifestsListItem(")
        append("annotationDataS3Uri=$annotationDataS3Uri,")
        append("attributeNames=$attributeNames,")
        append("documentType=$documentType,")
        append("s3Uri=$s3Uri,")
        append("sourceDocumentsS3Uri=$sourceDocumentsS3Uri,")
        append("split=$split")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = annotationDataS3Uri?.hashCode() ?: 0
        result = 31 * result + (attributeNames.hashCode())
        result = 31 * result + (documentType?.hashCode() ?: 0)
        result = 31 * result + (s3Uri.hashCode())
        result = 31 * result + (sourceDocumentsS3Uri?.hashCode() ?: 0)
        result = 31 * result + (split?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AugmentedManifestsListItem

        if (annotationDataS3Uri != other.annotationDataS3Uri) return false
        if (attributeNames != other.attributeNames) return false
        if (documentType != other.documentType) return false
        if (s3Uri != other.s3Uri) return false
        if (sourceDocumentsS3Uri != other.sourceDocumentsS3Uri) return false
        if (split != other.split) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.AugmentedManifestsListItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The S3 prefix to the annotation files that are referred in the augmented manifest file.
         */
        public var annotationDataS3Uri: kotlin.String? = null
        /**
         * The JSON attribute that contains the annotations for your training documents. The number of attribute names that you specify depends on whether your augmented manifest file is the output of a single labeling job or a chained labeling job.
         *
         * If your file is the output of a single labeling job, specify the LabelAttributeName key that was used when the job was created in Ground Truth.
         *
         * If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from an individual job.
         */
        public var attributeNames: List<String>? = null
        /**
         * The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don't specify, the default is PlainTextDocument.
         * + `PLAIN_TEXT_DOCUMENT` A document type that represents any unicode text that is encoded in UTF-8.
         * + `SEMI_STRUCTURED_DOCUMENT` A document type with positional and structural context, like a PDF. For training with Amazon Comprehend, only PDFs are supported. For inference, Amazon Comprehend support PDFs, DOCX and TXT.
         */
        public var documentType: aws.sdk.kotlin.services.comprehend.model.AugmentedManifestsDocumentTypeFormat? = null
        /**
         * The Amazon S3 location of the augmented manifest file.
         */
        public var s3Uri: kotlin.String? = null
        /**
         * The S3 prefix to the source files (PDFs) that are referred to in the augmented manifest file.
         */
        public var sourceDocumentsS3Uri: kotlin.String? = null
        /**
         * The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If you don't specify, the default is train.
         *
         * TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.
         *
         *  TEST - all of the documents in the manifest will be used for testing.
         */
        public var split: aws.sdk.kotlin.services.comprehend.model.Split? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.AugmentedManifestsListItem) : this() {
            this.annotationDataS3Uri = x.annotationDataS3Uri
            this.attributeNames = x.attributeNames
            this.documentType = x.documentType
            this.s3Uri = x.s3Uri
            this.sourceDocumentsS3Uri = x.sourceDocumentsS3Uri
            this.split = x.split
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.AugmentedManifestsListItem = AugmentedManifestsListItem(this)

        internal fun correctErrors(): Builder {
            if (attributeNames == null) attributeNames = emptyList()
            if (s3Uri == null) s3Uri = ""
            return this
        }
    }
}
