// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about an entity.
 */
public class Entity private constructor(builder: Builder) {
    /**
     * The zero-based offset from the beginning of the source text to the first character in the entity.
     *
     * This field is empty for non-text input.
     */
    public val beginOffset: kotlin.Int? = builder.beginOffset
    /**
     * A reference to each block for this entity. This field is empty for plain-text input.
     */
    public val blockReferences: List<BlockReference>? = builder.blockReferences
    /**
     * The zero-based offset from the beginning of the source text to the last character in the entity.
     *
     * This field is empty for non-text input.
     */
    public val endOffset: kotlin.Int? = builder.endOffset
    /**
     * The level of confidence that Amazon Comprehend has in the accuracy of the detection.
     */
    public val score: kotlin.Float? = builder.score
    /**
     * The text of the entity.
     */
    public val text: kotlin.String? = builder.text
    /**
     * The entity type. For entity detection using the built-in model, this field contains one of the standard entity types listed below.
     *
     * For custom entity detection, this field contains one of the entity types that you specified when you trained your custom model.
     */
    public val type: aws.sdk.kotlin.services.comprehend.model.EntityType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.Entity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Entity(")
        append("beginOffset=$beginOffset,")
        append("blockReferences=$blockReferences,")
        append("endOffset=$endOffset,")
        append("score=$score,")
        append("text=$text,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = beginOffset ?: 0
        result = 31 * result + (blockReferences?.hashCode() ?: 0)
        result = 31 * result + (endOffset ?: 0)
        result = 31 * result + (score?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Entity

        if (beginOffset != other.beginOffset) return false
        if (blockReferences != other.blockReferences) return false
        if (endOffset != other.endOffset) return false
        if (!(score?.equals(other.score) ?: (other.score == null))) return false
        if (text != other.text) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.Entity = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The zero-based offset from the beginning of the source text to the first character in the entity.
         *
         * This field is empty for non-text input.
         */
        public var beginOffset: kotlin.Int? = null
        /**
         * A reference to each block for this entity. This field is empty for plain-text input.
         */
        public var blockReferences: List<BlockReference>? = null
        /**
         * The zero-based offset from the beginning of the source text to the last character in the entity.
         *
         * This field is empty for non-text input.
         */
        public var endOffset: kotlin.Int? = null
        /**
         * The level of confidence that Amazon Comprehend has in the accuracy of the detection.
         */
        public var score: kotlin.Float? = null
        /**
         * The text of the entity.
         */
        public var text: kotlin.String? = null
        /**
         * The entity type. For entity detection using the built-in model, this field contains one of the standard entity types listed below.
         *
         * For custom entity detection, this field contains one of the entity types that you specified when you trained your custom model.
         */
        public var type: aws.sdk.kotlin.services.comprehend.model.EntityType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.Entity) : this() {
            this.beginOffset = x.beginOffset
            this.blockReferences = x.blockReferences
            this.endOffset = x.endOffset
            this.score = x.score
            this.text = x.text
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.Entity = Entity(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
