// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DetectEntitiesResponse private constructor(builder: Builder) {
    /**
     * Information about each block of text in the input document. Blocks are nested. A page block contains a block for each line of text, which contains a block for each word.
     *
     * The `Block` content for a Word input document does not include a `Geometry` field.
     *
     * The `Block` field is not present in the response for plain-text inputs.
     */
    public val blocks: List<Block>? = builder.blocks
    /**
     * Information about the document, discovered during text extraction. This field is present in the response only if your request used the `Byte` parameter.
     */
    public val documentMetadata: aws.sdk.kotlin.services.comprehend.model.DocumentMetadata? = builder.documentMetadata
    /**
     * The document type for each page in the input document. This field is present in the response only if your request used the `Byte` parameter.
     */
    public val documentType: List<DocumentTypeListItem>? = builder.documentType
    /**
     * A collection of entities identified in the input text. For each entity, the response provides the entity text, entity type, where the entity text begins and ends, and the level of confidence that Amazon Comprehend has in the detection.
     *
     * If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that the model is trained to recognize. Otherwise, it detects the default entity types. For a list of default entity types, see [Entities](https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html) in the Comprehend Developer Guide.
     */
    public val entities: List<Entity>? = builder.entities
    /**
     * Page-level errors that the system detected while processing the input document. The field is empty if the system encountered no errors.
     */
    public val errors: List<ErrorsListItem>? = builder.errors

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.DetectEntitiesResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DetectEntitiesResponse(")
        append("*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blocks?.hashCode() ?: 0
        result = 31 * result + (documentMetadata?.hashCode() ?: 0)
        result = 31 * result + (documentType?.hashCode() ?: 0)
        result = 31 * result + (entities?.hashCode() ?: 0)
        result = 31 * result + (errors?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DetectEntitiesResponse

        if (blocks != other.blocks) return false
        if (documentMetadata != other.documentMetadata) return false
        if (documentType != other.documentType) return false
        if (entities != other.entities) return false
        if (errors != other.errors) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.DetectEntitiesResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about each block of text in the input document. Blocks are nested. A page block contains a block for each line of text, which contains a block for each word.
         *
         * The `Block` content for a Word input document does not include a `Geometry` field.
         *
         * The `Block` field is not present in the response for plain-text inputs.
         */
        public var blocks: List<Block>? = null
        /**
         * Information about the document, discovered during text extraction. This field is present in the response only if your request used the `Byte` parameter.
         */
        public var documentMetadata: aws.sdk.kotlin.services.comprehend.model.DocumentMetadata? = null
        /**
         * The document type for each page in the input document. This field is present in the response only if your request used the `Byte` parameter.
         */
        public var documentType: List<DocumentTypeListItem>? = null
        /**
         * A collection of entities identified in the input text. For each entity, the response provides the entity text, entity type, where the entity text begins and ends, and the level of confidence that Amazon Comprehend has in the detection.
         *
         * If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that the model is trained to recognize. Otherwise, it detects the default entity types. For a list of default entity types, see [Entities](https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html) in the Comprehend Developer Guide.
         */
        public var entities: List<Entity>? = null
        /**
         * Page-level errors that the system detected while processing the input document. The field is empty if the system encountered no errors.
         */
        public var errors: List<ErrorsListItem>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.DetectEntitiesResponse) : this() {
            this.blocks = x.blocks
            this.documentMetadata = x.documentMetadata
            this.documentType = x.documentType
            this.entities = x.entities
            this.errors = x.errors
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.DetectEntitiesResponse = DetectEntitiesResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.DocumentMetadata] inside the given [block]
         */
        public fun documentMetadata(block: aws.sdk.kotlin.services.comprehend.model.DocumentMetadata.Builder.() -> kotlin.Unit) {
            this.documentMetadata = aws.sdk.kotlin.services.comprehend.model.DocumentMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
